// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ProgressBar, constants, date_to_unixtime, fork, is_dict, make_email, make_full_username, path, purge,
    __slice = [].slice;

  fork = require('child_process').fork;

  path = require('path');

  constants = require('./constants').constants;

  ProgressBar = require('progress');

  exports.dict_union = function() {
    var args, d, k, out, v, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    out = {};
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      d = args[_i];
      for (k in d) {
        v = d[k];
        out[k] = v;
      }
    }
    return out;
  };

  exports.rmkey = function(obj, key) {
    var ret;
    ret = obj[key];
    delete obj[key];
    return ret;
  };

  exports.daemon = function(args) {
    var icmd;
    icmd = path.join(__dirname, "..", "node_modules", ".bin", "iced");
    return fork(process.argv[1], args, {
      execPath: icmd,
      detatched: true
    });
  };

  exports.js2unix = function(t) {
    return Math.floor(t / 1000);
  };

  is_dict = function(d) {
    return (typeof d === 'object') && !(Array.isArray(d));
  };

  exports.purge = purge = function(d) {
    var k, out, v;
    out = {};
    for (k in d) {
      v = d[k];
      if (v != null) {
        out[k] = is_dict(v) ? purge(v) : v;
      }
    }
    return out;
  };

  exports.make_scrypt_progress_hook = function() {
    var bar, prev, progress_hook;
    bar = null;
    prev = 0;
    progress_hook = function(obj) {
      if (obj.what !== "scrypt") {

      } else {
        bar || (bar = new ProgressBar("- run scrypt [:bar] :percent", {
          width: 35,
          total: obj.total
        }));
        bar.tick(obj.i - prev);
        return prev = obj.i;
      }
    };
    return progress_hook;
  };

  exports.make_email = make_email = function(un) {
    return un + "@" + constants.canonical_host;
  };

  exports.make_full_username = make_full_username = function(un) {
    return constants.canonical_host + "/" + un;
  };

  exports.date_to_unixtime = date_to_unixtime = function(s) {
    return ~~(s.getTime() / 1000);
  };

  exports.date_to_unix = function(o) {
    switch (typeof o) {
      case 'string':
        return date_to_unixtime(new Date(o));
      case 'number':
        return o;
      case 'object':
        if (o instanceof Date) {
          return date_to_unixtime(o);
        } else {
          return null;
        }
        break;
      default:
        return null;
    }
  };

}).call(this);
