/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.bitext;

import java.io.IOException;
import junit.framework.TestCase;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.DifferentLengthRule;

public class DifferentLengthRuleTest
extends TestCase {
    public void testRule() throws IOException {
        DifferentLengthRule rule = new DifferentLengthRule();
        JLanguageTool trgLangTool = new JLanguageTool(TestTools.getDemoLanguage());
        JLanguageTool srcLangTool = new JLanguageTool((Language)new FakeLanguage());
        rule.setSourceLanguage(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(srcLangTool.getAnalyzedSentence("This is a test sentence."), trgLangTool.getAnalyzedSentence("To zdanie testowe."));
        DifferentLengthRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(srcLangTool.getAnalyzedSentence("Click this button."), trgLangTool.getAnalyzedSentence("Kliknij ten przycisk."));
        DifferentLengthRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(srcLangTool.getAnalyzedSentence("Open a file, and check if it is corrupt."), trgLangTool.getAnalyzedSentence("Otw\u00f3rz plik."));
        DifferentLengthRuleTest.assertEquals((int)1, (int)matches.length);
    }
}

