/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support.filter;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.validation.Validator;

public enum FileFilterType implements Validator<String>
{
    CSV("(*.csv)", "csv"),
    JAR("(*.jar)", "jar"),
    PDF("(*.pdf)", "pdf"),
    TXT("(*.txt)", "txt"),
    LOG("(*.log)", "log"),
    XML("(*.xml)", "xml"),
    HTML("(*.html, *.htm)", "html", "htm"),
    DIRECTORIES(DefaultI18nContext.getInstance().i18n("Directories"), new String[0]);

    private String description;
    private String[] acceptedExtensions;

    private FileFilterType(String description, String ... extensions) {
        this.description = description;
        this.acceptedExtensions = extensions;
    }

    String getDescription() {
        return this.description;
    }

    boolean accept(File file) {
        if (file != null) {
            if (ArrayUtils.isNotEmpty(this.acceptedExtensions)) {
                return this.isAccepted(file);
            }
            return file.isDirectory();
        }
        return false;
    }

    private boolean isAccepted(File file) {
        for (String accepted : this.acceptedExtensions) {
            if (!accepted.equalsIgnoreCase(FilenameUtils.getExtension(file.getAbsolutePath()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid(String input) {
        try {
            return StringUtils.isNotBlank(input) && this.accept(Paths.get(input, new String[0]).toFile());
        }
        catch (InvalidPathException ipe) {
            return false;
        }
    }
}

