/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.Annotations;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.AddBackPagesParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddBackPagesTask
extends BaseTask<AddBackPagesParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(AddBackPagesTask.class);
    private int totalSteps;
    private PDDocumentHandler sourceDocumentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PDDocumentHandler backPagesSource;
    private PDDocumentHandler destinationDocument;

    @Override
    public void before(AddBackPagesParameters parameters) {
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(AddBackPagesParameters parameters) throws TaskException {
        LOG.debug("Opening back pages source {}", (Object)parameters.getBackPagesSource());
        this.backPagesSource = parameters.getBackPagesSource().open(this.documentLoader);
        List<PDPage> back = parameters.getPages(this.backPagesSource.getNumberOfPages()).stream().map(p -> this.backPagesSource.getPage((int)p)).collect(Collectors.toList());
        if (back.size() <= 0) {
            throw new TaskExecutionException("No back page was selected");
        }
        LOG.debug("Retrieved {} back pages", (Object)back.size());
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            this.stopTaskIfCancelled();
            this.destinationDocument = new PDDocumentHandler();
            this.destinationDocument.setCreatorOnPDDocument();
            this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
            this.destinationDocument.setCompress(parameters.isCompress());
            LOG.debug("Opening {}", (Object)source);
            this.sourceDocumentHandler = source.open(this.documentLoader);
            this.sourceDocumentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
            File tmpFile = IOUtils.createTemporaryPdfBuffer();
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            int pageCounter = 0;
            LookupTable<PDPage> pagesLookup = new LookupTable<PDPage>();
            LOG.debug("Adding pages and back pages");
            for (PDPage current : this.sourceDocumentHandler.getPages()) {
                this.stopTaskIfCancelled();
                pagesLookup.addLookupEntry(current, this.destinationDocument.importPage(current));
                if (++pageCounter % parameters.getStep() != 0) continue;
                back.forEach(p -> this.destinationDocument.importPage((PDPage)p));
            }
            LookupTable<PDAnnotation> annotationsLookup = Annotations.processAnnotations(pagesLookup, this.sourceDocumentHandler.getUnderlyingPDDocument());
            SignatureClipper.clipSignatures(annotationsLookup.values());
            this.destinationDocument.savePDDocument(tmpFile);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
            ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(this.totalSteps);
        }
        ComponentsUtility.nullSafeCloseQuietly(this.backPagesSource);
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Back pages added after every {} pages to {} input documents and written to {}", parameters.getStep(), parameters.getSourceList().size(), parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.backPagesSource);
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
        ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
    }
}

