/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.Annotations;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.TaskPermissionsException;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfAlternateMixer
extends PDDocumentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PdfAlternateMixer.class);
    private PdfMixInput firstInput;
    private PdfMixInput secondInput;
    private PDDocumentHandler firstDocumentHandler;
    private PDDocumentHandler secondDocumentHandler;
    private PdfSourceOpener<PDDocumentHandler> documentLoader = new DefaultPdfSourceOpener();

    public PdfAlternateMixer(PdfMixInput firstInput, PdfMixInput secondInput) {
        this.firstInput = firstInput;
        this.secondInput = secondInput;
    }

    public void mix(NotifiableTaskMetadata taskMetadata) throws TaskException {
        this.firstDocumentHandler = this.openInput(this.firstInput);
        this.secondDocumentHandler = this.openInput(this.secondInput);
        this.setCreatorOnPDDocument();
        int firstDocPages = this.firstDocumentHandler.getNumberOfPages();
        int secondDocPages = this.secondDocumentHandler.getNumberOfPages();
        PdfMixInput.PdfMixInputProcessStatus firstDocStatus = this.firstInput.newProcessingStatus(firstDocPages);
        PdfMixInput.PdfMixInputProcessStatus secondDocStatus = this.secondInput.newProcessingStatus(secondDocPages);
        int currentStep = 0;
        int totalSteps = firstDocPages + secondDocPages;
        LookupTable<PDPage> lookupFirst = new LookupTable<PDPage>();
        LookupTable<PDPage> lookupSecond = new LookupTable<PDPage>();
        while (firstDocStatus.hasNextPage() || secondDocStatus.hasNextPage()) {
            PDPage current;
            int i;
            taskMetadata.stopTaskIfCancelled();
            for (i = 0; i < this.firstInput.getStep() && firstDocStatus.hasNextPage(); ++i) {
                current = this.firstDocumentHandler.getPage(firstDocStatus.nextPage());
                lookupFirst.addLookupEntry(current, this.importPage(current));
                ApplicationEventsNotifier.notifyEvent(taskMetadata).stepsCompleted(++currentStep).outOf(totalSteps);
            }
            for (i = 0; i < this.secondInput.getStep() && secondDocStatus.hasNextPage(); ++i) {
                current = this.secondDocumentHandler.getPage(secondDocStatus.nextPage());
                lookupSecond.addLookupEntry(current, this.importPage(current));
                ApplicationEventsNotifier.notifyEvent(taskMetadata).stepsCompleted(++currentStep).outOf(totalSteps);
            }
        }
        LookupTable<PDAnnotation> annotationsLookup = Annotations.processAnnotations(lookupFirst, this.firstDocumentHandler.getUnderlyingPDDocument());
        SignatureClipper.clipSignatures(annotationsLookup.values());
        annotationsLookup = Annotations.processAnnotations(lookupSecond, this.secondDocumentHandler.getUnderlyingPDDocument());
        SignatureClipper.clipSignatures(annotationsLookup.values());
    }

    private PDDocumentHandler openInput(PdfMixInput input) throws TaskIOException, TaskPermissionsException {
        LOG.debug("Opening input {} ", (Object)input.getSource());
        PDDocumentHandler documentHandler = input.getSource().open(this.documentLoader);
        documentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
        return documentHandler;
    }

    @Override
    public void close() throws IOException {
        super.close();
        ComponentsUtility.nullSafeCloseQuietly(this.firstDocumentHandler);
        ComponentsUtility.nullSafeCloseQuietly(this.secondDocumentHandler);
    }
}

