/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.text.PDFTextStripper;

public class PdfTextExtractor
implements Closeable {
    private PDFTextStripper textStripper = null;
    private Writer outputWriter;
    private String encoding;

    public PdfTextExtractor(String encoding) throws TaskException {
        this(encoding, 1, Integer.MAX_VALUE);
    }

    public PdfTextExtractor(String encoding, int startPageOneBased, int endPageIncluding) throws TaskException {
        try {
            this.encoding = encoding;
            this.textStripper = new PDFTextStripper();
            this.textStripper.setStartPage(startPageOneBased);
            this.textStripper.setEndPage(endPageIncluding);
        }
        catch (IOException e) {
            throw new TaskException("Unable to create text extractor.", e);
        }
    }

    public void extract(PDDocument document, File output) throws TaskException {
        if (document == null) {
            throw new TaskException("Unable to extract text from a null document.");
        }
        if (output == null || !output.isFile() || !output.canWrite()) {
            throw new TaskException(String.format("Cannot write extracted text to a the given output file '%s'.", output));
        }
        try {
            this.outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), this.encoding));
            this.textStripper.writeText(document, this.outputWriter);
        }
        catch (IOException e) {
            throw new TaskExecutionException("An error occurred extracting text from a pdf source.", e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.outputWriter);
    }
}

