/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.toc.ToCPolicy;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.util.Matrix;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOfContentsCreator {
    private static final Logger LOG = LoggerFactory.getLogger(TableOfContentsCreator.class);
    private static final int FONT_SIZE = 14;
    private static final int LINE_HEIGHT = 23;
    private static final PDRectangle PAGE_SIZE = PDRectangle.A4;
    private static final int MARGIN = 40;
    private static final float FONT_SCALE = 0.014f;
    private static final String SEPARATOR = "  ";
    private final Deque<ToCItem> items = new LinkedList<ToCItem>();
    private PDDocument document;
    private ToCPolicy policy;

    public TableOfContentsCreator(ToCPolicy policy, PDDocument document) {
        RequireUtils.requireNotNullArg(document, "Containing document cannot be null");
        this.document = document;
        this.policy = Optional.ofNullable(policy).orElse(ToCPolicy.NONE);
    }

    public void appendItem(String text, long page, PDAnnotation annotation) {
        RequireUtils.requireNotBlank(text, "ToC item cannot be blank");
        RequireUtils.requireArg(page > 0L, "ToC item cannot point to a negative page");
        RequireUtils.requireNotNullArg(annotation, "ToC annotation cannot be null");
        if (this.shouldGenerateToC()) {
            this.items.add(new ToCItem(text, page, annotation));
        }
    }

    public void addToC() {
        try {
            PDPageTree pagesTree = this.document.getPages();
            Optional.ofNullable(this.generateToC()).filter(l -> !l.isEmpty()).ifPresent(t -> t.descendingIterator().forEachRemaining(p -> {
                if (pagesTree.getCount() > 0) {
                    pagesTree.insertBefore((PDPage)p, pagesTree.get(0));
                } else {
                    pagesTree.add((PDPage)p);
                }
            }));
        }
        catch (IOException e) {
            LOG.error("An error occured while create the ToC. Skipping ToC creation.", e);
        }
    }

    private LinkedList<PDPage> generateToC() throws IOException {
        LinkedList<PDPage> pages = new LinkedList<PDPage>();
        if (this.shouldGenerateToC()) {
            PDFont font = PDType1Font.HELVETICA;
            int maxRows = (int)(PAGE_SIZE.getHeight() - 80.0f) / 23;
            while (!this.items.isEmpty()) {
                int row = 0;
                float separatorWidth = this.stringLength(font, SEPARATOR);
                float separatingLineEndingX = this.getSeparatingLineEndingX(separatorWidth, font);
                PDPage page = this.createPage(pages);
                PDPageContentStream stream = new PDPageContentStream(this.document, page);
                Throwable throwable = null;
                try {
                    while (!this.items.isEmpty() && row < maxRows) {
                        ToCItem i = this.items.poll();
                        if (!Objects.nonNull(i)) continue;
                        font = FontUtils.fontOrFallback(i.text, font, () -> FontUtils.findFontFor(this.document, i.text));
                        RequireUtils.requireIOCondition(Objects.nonNull(font), "Unable to find suitable font for " + i.text);
                        float y = PAGE_SIZE.getHeight() - 40.0f - (float)(++row * 23);
                        stream.beginText();
                        stream.setFont(font, 14.0f);
                        stream.setTextMatrix(new Matrix(AffineTransform.getTranslateInstance(40.0, y)));
                        String itemText = this.sanitize(i.text, font, separatingLineEndingX, separatorWidth);
                        stream.showText(itemText);
                        String pageString = SEPARATOR + Long.toString(i.page);
                        stream.setTextMatrix(new Matrix(AffineTransform.getTranslateInstance(this.getPageNumberX(separatorWidth, PDType1Font.HELVETICA, i), y)));
                        stream.setFont(PDType1Font.HELVETICA, 14.0f);
                        stream.showText(pageString);
                        stream.endText();
                        i.annotation.setRectangle(new PDRectangle(40.0f, y, PAGE_SIZE.getWidth() - 40.0f, 14.0f));
                        page.getAnnotations().add(i.annotation);
                        if (!itemText.equals(i.text)) continue;
                        stream.moveTo(40.0f + separatorWidth + this.stringLength(font, i.text), y);
                        stream.lineTo(separatingLineEndingX, y);
                        stream.setLineWidth(0.5f);
                        stream.stroke();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        return pages;
    }

    private String sanitize(String text, PDFont font, float separatingLineEndingX, float separatorWidth) throws IOException {
        float maxLen = PAGE_SIZE.getWidth() - 40.0f - (PAGE_SIZE.getWidth() - separatingLineEndingX) - separatorWidth;
        if (this.stringLength(font, text) > maxLen) {
            LOG.debug("Truncating ToC text to fit available space");
            int currentLength = text.length() / 2;
            while (this.stringLength(font, text.substring(0, currentLength)) > maxLen) {
                currentLength /= 2;
            }
            int currentChunk = currentLength;
            while (currentChunk > 1) {
                if (!(this.stringLength(font, text.substring(0, currentLength + (currentChunk /= 2))) < maxLen)) continue;
                currentLength += currentChunk;
            }
            return text.substring(0, currentLength);
        }
        return text;
    }

    private PDPage createPage(LinkedList<PDPage> pages) {
        LOG.debug("Creating new ToC page");
        PDPage page = new PDPage(PAGE_SIZE);
        pages.add(page);
        return page;
    }

    private float getSeparatingLineEndingX(float separatorWidth, PDFont font) throws IOException {
        return this.getPageNumberX(separatorWidth, font, this.items.peekLast());
    }

    private float getPageNumberX(float separatorWidth, PDFont font, ToCItem i) throws IOException {
        return PAGE_SIZE.getWidth() - 40.0f - separatorWidth - this.stringLength(font, Long.toString(i.page));
    }

    private float stringLength(PDFont font, String text) throws IOException {
        return font.getStringWidth(text) * 0.014f;
    }

    public boolean hasToc() {
        return !this.items.isEmpty();
    }

    public boolean shouldGenerateToC() {
        return this.policy != ToCPolicy.NONE;
    }

    private static class ToCItem {
        public final String text;
        public final long page;
        public final PDAnnotation annotation;

        public ToCItem(String text, long page, PDAnnotation annotation) {
            this.text = text;
            this.page = page;
            this.annotation = annotation;
        }
    }
}

