/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.common.filespecification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.common.PDStream;

public class PDEmbeddedFile
extends PDStream {
    public PDEmbeddedFile(COSStream str) {
        super(str);
    }

    public PDEmbeddedFile(InputStream str) throws IOException {
        super(str);
        this.getStream().setItem(COSName.TYPE, (COSBase)COSName.EMBEDDED_FILE);
    }

    public PDEmbeddedFile(InputStream input, COSName filter) throws IOException {
        super(input, filter);
        this.getStream().setItem(COSName.TYPE, (COSBase)COSName.EMBEDDED_FILE);
    }

    public void setSubtype(String mimeType) {
        this.getStream().setName(COSName.SUBTYPE, mimeType);
    }

    public String getSubtype() {
        return this.getStream().getNameAsString(COSName.SUBTYPE);
    }

    public int getSize() {
        return this.getStream().getEmbeddedInt("Params", "Size");
    }

    public void setSize(long size) {
        this.getStream().setEmbeddedInt("Params", "Size", size);
    }

    public Calendar getCreationDate() {
        return this.getStream().getEmbeddedDate("Params", "CreationDate");
    }

    public void setCreationDate(Calendar creation) {
        this.getStream().setEmbeddedDate("Params", "CreationDate", creation);
    }

    public Calendar getModDate() {
        return this.getStream().getEmbeddedDate("Params", "ModDate");
    }

    public void setModDate(Calendar mod) {
        this.getStream().setEmbeddedDate("Params", "ModDate", mod);
    }

    public String getCheckSum() {
        return this.getStream().getEmbeddedString("Params", "CheckSum");
    }

    public void setCheckSum(String checksum) {
        this.getStream().setEmbeddedString("Params", "CheckSum", checksum);
    }

    public String getMacSubtype() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "Subtype");
        }
        return retval;
    }

    public void setMacSubtype(String macSubtype) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params == null && macSubtype != null) {
            params = new COSDictionary();
            this.getStream().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "Subtype", macSubtype);
        }
    }

    public String getMacCreator() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "Creator");
        }
        return retval;
    }

    public void setMacCreator(String macCreator) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params == null && macCreator != null) {
            params = new COSDictionary();
            this.getStream().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "Creator", macCreator);
        }
    }

    public String getMacResFork() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "ResFork");
        }
        return retval;
    }

    public void setMacResFork(String macResFork) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params == null && macResFork != null) {
            params = new COSDictionary();
            this.getStream().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "ResFork", macResFork);
        }
    }
}

