/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.SampleResponse;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.model.StructuralNode;

public class Analyser {
    private static final Logger logger = Logger.getLogger(Analyser.class);
    private static final String p_REMOVE_HEADER = "(?m)(?i)(?s)<HEAD>.*?</HEAD>";
    private static final Pattern patternNotFound = Pattern.compile("(\\bnot\\b(found|exist))|(\\b404\\berror\\b)|(\\berror\\b404\\b)", 10);
    private static Random staticRandomGenerator = new Random();
    private static final String[] staticSuffixList = new String[]{".cfm", ".jsp", ".php", ".asp", ".aspx", ".dll", ".exe", ".pl"};
    private HttpSender httpSender = null;
    private TreeMap<String, SampleResponse> mapVisited = new TreeMap();
    private boolean isStop = false;
    private int delayInMs;
    HostProcess parent = null;

    public Analyser() {
    }

    public Analyser(HttpSender httpSender, HostProcess hostProcess) {
        this.httpSender = httpSender;
        this.parent = hostProcess;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void stop() {
        this.isStop = true;
    }

    public void start(StructuralNode structuralNode) {
        this.inOrderAnalyse(structuralNode);
    }

    private void addAnalysedHost(URI uRI, HttpMessage httpMessage, int n) {
        try {
            this.mapVisited.put(uRI.toString(), new SampleResponse(httpMessage, n));
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            logger.error((Object)("Failed to persist the message: " + exception.getMessage()), (Throwable)exception);
        }
    }

    private void analyse(StructuralNode structuralNode) throws Exception {
        if (structuralNode.getHistoryReference() == null) {
            return;
        }
        if (!this.parent.nodeInScope(structuralNode.getName())) {
            return;
        }
        HttpMessage httpMessage = structuralNode.getHistoryReference().getHttpMessage();
        URI uRI = (URI)httpMessage.getRequestHeader().getURI().clone();
        uRI.setQuery(null);
        if (this.mapVisited.get(uRI.toString()) != null) {
            return;
        }
        String string = this.getRandomPathSuffix(structuralNode, uRI);
        HttpMessage httpMessage2 = httpMessage.cloneRequest();
        URI uRI2 = (URI)uRI.clone();
        uRI2.setPath(string);
        httpMessage2.getRequestHeader().setURI(uRI2);
        this.sendAndReceive(httpMessage2);
        if (httpMessage2.getResponseHeader().getStatusCode() == 404) {
            this.addAnalysedHost(uRI, httpMessage2, 0);
            return;
        }
        if (HttpStatusCode.isRedirection(httpMessage2.getResponseHeader().getStatusCode())) {
            this.addAnalysedHost(uRI, httpMessage2, 2);
            return;
        }
        if (httpMessage2.getResponseHeader().getStatusCode() != 200) {
            this.addAnalysedHost(uRI, httpMessage2, 1);
            return;
        }
        HttpMessage httpMessage3 = httpMessage.cloneRequest();
        URI uRI3 = httpMessage3.getRequestHeader().getURI();
        String string2 = this.getRandomPathSuffix(structuralNode, uRI3);
        uRI3 = (URI)uRI.clone();
        uRI3.setPath(string2);
        httpMessage3.getRequestHeader().setURI(uRI3);
        this.sendAndReceive(httpMessage3);
        String string3 = httpMessage2.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        String string4 = httpMessage3.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        if (string3.equals(string4)) {
            httpMessage2.getResponseBody().setBody(string3);
            this.addAnalysedHost(uRI, httpMessage2, 3);
            return;
        }
        if ((string3 = string3.replaceAll(this.getPathRegex(uRI2), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", "")).equals(string4 = string4.replaceAll(this.getPathRegex(uRI3), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", ""))) {
            httpMessage2.getResponseBody().setBody(string3);
            this.addAnalysedHost(uRI, httpMessage2, 4);
            return;
        }
        this.addAnalysedHost(uRI, httpMessage2, 5);
    }

    private String getChildSuffix(StructuralNode structuralNode, boolean bl) {
        String string = "";
        String string2 = null;
        StructuralNode structuralNode2 = null;
        try {
            for (int i = 0; i < staticSuffixList.length; ++i) {
                string2 = staticSuffixList[i];
                Iterator<StructuralNode> iterator = structuralNode.getChildIterator();
                while (iterator.hasNext()) {
                    structuralNode2 = iterator.next();
                    try {
                        if (!structuralNode2.getURI().getPath().endsWith(string2)) continue;
                        return string2;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (bl) {
                Iterator<StructuralNode> iterator = structuralNode.getChildIterator();
                while (iterator.hasNext()) {
                    structuralNode2 = iterator.next();
                    string = this.getChildSuffix(structuralNode2, bl);
                    if (string.equals("")) continue;
                    return string;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getPathRegex(URI uRI) throws URIException {
        URI uRI2;
        try {
            uRI2 = (URI)uRI.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new URIException(cloneNotSupportedException.getMessage());
        }
        String string = uRI2.getQuery();
        StringBuilder stringBuilder = new StringBuilder(100);
        uRI2.setQuery(null);
        stringBuilder.append(uRI2.toString().replaceAll("\\.", "\\."));
        if (string != null) {
            String string2 = "(\\?" + string + ")?";
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String getRandomPathSuffix(StructuralNode structuralNode, URI uRI) throws URIException {
        String string = this.getChildSuffix(structuralNode, true);
        String string2 = "";
        string2 = uRI.getPath() == null ? "" : uRI.getPath();
        string2 = string2 + (string2.endsWith("/") ? "" : "/") + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
        string2 = string2 + string;
        return string2;
    }

    private int inOrderAnalyse(StructuralNode structuralNode) {
        int n;
        block6: {
            n = 0;
            if (this.isStop) {
                return 0;
            }
            if (structuralNode == null) {
                return 0;
            }
            try {
                if (structuralNode.isRoot()) break block6;
                if (!structuralNode.isLeaf() || structuralNode.isLeaf() && structuralNode.getParent().isRoot()) {
                    this.analyse(structuralNode);
                    break block6;
                }
                return 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Iterator<StructuralNode> iterator = structuralNode.getChildIterator();
        while (iterator.hasNext()) {
            n += this.inOrderAnalyse(iterator.next());
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileExist(HttpMessage httpMessage) {
        Object object;
        Object object2;
        if (httpMessage.getResponseHeader().isEmpty()) {
            return false;
        }
        if (httpMessage.getResponseHeader().getStatusCode() == 404) {
            return false;
        }
        URI uRI = null;
        String string = null;
        try {
            uRI = (URI)httpMessage.getRequestHeader().getURI().clone();
            uRI.setQuery(null);
            object2 = uRI.getPath();
            object2 = ((String)object2).replaceAll("/[^/]*$", "");
            uRI.setPath((String)object2);
        }
        catch (Exception exception) {
        }
        finally {
            if (uRI != null) {
                string = uRI.toString();
            }
        }
        object2 = this.mapVisited.get(string);
        if (object2 == null) {
            try {
                uRI.setPath(null);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            object = uRI.toString();
            object2 = this.mapVisited.get(object);
        }
        if (object2 == null) {
            return httpMessage.getResponseHeader().getStatusCode() == 200;
        }
        if (HttpStatusCode.isRedirection(httpMessage.getResponseHeader().getStatusCode())) {
            try {
                if (((SampleResponse)object2).getMessage().getResponseHeader().getStatusCode() == httpMessage.getResponseHeader().getStatusCode() && (object = httpMessage.getResponseHeader().getHeader("Location")) != null && ((String)object).equals(((SampleResponse)object2).getMessage().getResponseHeader().getHeader("Location"))) {
                    return false;
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return true;
        }
        if (httpMessage.getResponseHeader().getStatusCode() != 200) {
            return false;
        }
        object = patternNotFound.matcher(httpMessage.getResponseBody().toString());
        if (((Matcher)object).find()) {
            return false;
        }
        String string2 = httpMessage.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        if (((SampleResponse)object2).getErrorPageType() == 3) {
            try {
                if (((SampleResponse)object2).getMessage().getResponseBody().toString().equals(string2)) {
                    return false;
                }
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                logger.error((Object)("Failed to read the message: " + exception.getMessage()), (Throwable)exception);
            }
            return true;
        }
        uRI = httpMessage.getRequestHeader().getURI();
        try {
            if (((SampleResponse)object2).getErrorPageType() == 4) {
                string2 = httpMessage.getResponseBody().toString().replaceAll(this.getPathRegex(uRI), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", "");
                return !((SampleResponse)object2).getMessage().getResponseBody().toString().equals(string2);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return true;
    }

    private void sendAndReceive(HttpMessage httpMessage) throws HttpException, IOException {
        if (this.getDelayInMs() > 0) {
            try {
                Thread.sleep(this.getDelayInMs());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.httpSender.sendAndReceive(httpMessage, true);
        if (this.parent != null) {
            this.parent.notifyNewMessage(httpMessage);
        }
    }

    public int getDelayInMs() {
        return this.delayInMs;
    }

    public void setDelayInMs(int n) {
        this.delayInMs = n;
    }
}

