/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.TabbedPanel2;

public class WorkbenchPanel
extends JPanel {
    private static final long serialVersionUID = -4610792807151921550L;
    private static final String PREF_DIVIDER_LOCATION = "divider.location";
    private static final String DIVIDER_VERTICAL = "vertical";
    private static final String DIVIDER_HORIZONTAL = "horizontal";
    private JSplitPane splitVert = null;
    private JSplitPane splitHoriz = null;
    private JPanel paneStatus = null;
    private JPanel paneSelect = null;
    private JPanel paneWork = null;
    private TabbedPanel2 tabbedStatus = null;
    private TabbedPanel2 tabbedWork = null;
    private TabbedPanel2 tabbedSelect = null;
    private TabbedPanel2 tabbedOldStatus = null;
    private TabbedPanel2 tabbedOldWork = null;
    private TabbedPanel2 tabbedOldSelect = null;
    private int displayOption;
    private int previousDisplayOption = -1;
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private final Logger logger = Logger.getLogger(WorkbenchPanel.class);

    public WorkbenchPanel(int n) {
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.displayOption = n;
        this.previousDisplayOption = n;
        this.initialize();
    }

    private void minimizeMaximizedPanels() {
        if (this.tabbedSelect != null && this.tabbedSelect.isInAlternativeParent()) {
            this.tabbedSelect.alternateParent();
        } else if (this.tabbedStatus != null && this.tabbedStatus.isInAlternativeParent()) {
            this.tabbedStatus.alternateParent();
        } else if (this.tabbedWork != null && this.tabbedWork.isInAlternativeParent()) {
            this.tabbedWork.alternateParent();
        }
        if (this.previousDisplayOption != -1) {
            View.getSingleton().getMessagePanelsPositionController().restoreOriginalParentTabbedPanel();
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        View.setDisplayOption(this.displayOption);
        this.minimizeMaximizedPanels();
        switch (this.displayOption) {
            case 0: {
                this.add((Component)this.getSplitHoriz(), gridBagConstraints);
                break;
            }
            case 2: {
                this.add((Component)this.getPaneStatus(), gridBagConstraints);
                break;
            }
            default: {
                this.add((Component)this.getSplitVert(), gridBagConstraints);
            }
        }
        switch (this.displayOption) {
            case 2: {
                if (this.previousDisplayOption != 2) {
                    this.tabbedOldSelect = this.tabbedSelect;
                    this.tabbedOldStatus = this.tabbedStatus;
                    this.tabbedOldWork = this.tabbedWork;
                }
                this.getTabbedStatus().addTab(View.getSingleton().getRequestPanel().getName(), View.getSingleton().getRequestPanel().getIcon(), View.getSingleton().getRequestPanel());
                this.getTabbedStatus().addTab(View.getSingleton().getResponsePanel().getName(), View.getSingleton().getResponsePanel().getIcon(), View.getSingleton().getResponsePanel());
                this.getTabbedStatus().addTab(View.getSingleton().getSiteTreePanel().getName(), View.getSingleton().getSiteTreePanel().getIcon(), View.getSingleton().getSiteTreePanel());
                for (Component component : this.getTabbedWork().getTabList()) {
                    if (!(component instanceof AbstractPanel)) continue;
                    this.getTabbedStatus().addTab((AbstractPanel)component);
                }
                for (Component component : this.getTabbedSelect().getTabList()) {
                    if (!(component instanceof AbstractPanel)) continue;
                    this.getTabbedStatus().addTab((AbstractPanel)component);
                }
                break;
            }
            default: {
                if (this.previousDisplayOption != 1 || this.previousDisplayOption != 0) {
                    this.getTabbedWork().addTab(View.getSingleton().getRequestPanel().getName(), View.getSingleton().getRequestPanel().getIcon(), View.getSingleton().getRequestPanel());
                    this.getTabbedWork().addTab(View.getSingleton().getResponsePanel().getName(), View.getSingleton().getResponsePanel().getIcon(), View.getSingleton().getResponsePanel());
                    this.getTabbedSelect().addTab(View.getSingleton().getSiteTreePanel().getName(), View.getSingleton().getSiteTreePanel().getIcon(), View.getSingleton().getSiteTreePanel());
                }
                if (this.previousDisplayOption == 2) {
                    for (Component component : this.getTabbedOldWork().getTabList()) {
                        if (!(component instanceof AbstractPanel)) continue;
                        this.getTabbedWork().addTab((AbstractPanel)component);
                    }
                    for (Component component : this.getTabbedOldSelect().getTabList()) {
                        if (!(component instanceof AbstractPanel)) continue;
                        this.getTabbedSelect().addTab((AbstractPanel)component);
                    }
                }
                if (this.getTabbedWork().getSelectedComponent() == null && this.getTabbedWork().getTabCount() > 0) {
                    this.getTabbedWork().setSelectedIndex(0);
                }
                if (this.getTabbedSelect().getSelectedComponent() != null || this.getTabbedSelect().getTabCount() <= 0) break;
                this.getTabbedSelect().setSelectedIndex(0);
            }
        }
        if (this.previousDisplayOption != -1 && this.displayOption != 2) {
            View.getSingleton().getMessagePanelsPositionController().restoreState();
        }
        this.previousDisplayOption = this.displayOption;
    }

    public void changeDisplayOption(int n) {
        this.displayOption = n;
        this.removeAll();
        this.splitVert = null;
        this.splitHoriz = null;
        this.initialize();
        this.validate();
        this.repaint();
    }

    private JSplitPane getSplitVert() {
        if (this.splitVert == null) {
            this.splitVert = new JSplitPane();
            this.splitVert.setDividerLocation(this.restoreDividerLocation(DIVIDER_VERTICAL, 300));
            this.splitVert.addPropertyChangeListener("dividerLocation", new DividerResizedListener(DIVIDER_VERTICAL));
            this.splitVert.setDividerSize(3);
            this.splitVert.setOrientation(0);
            this.splitVert.setResizeWeight(0.5);
            switch (this.displayOption) {
                case 0: {
                    this.splitVert.setTopComponent(this.getPaneWork());
                    break;
                }
                default: {
                    this.splitVert.setTopComponent(this.getSplitHoriz());
                }
            }
            this.splitVert.setBottomComponent(this.getPaneStatus());
            this.splitVert.setContinuousLayout(false);
            this.splitVert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.splitVert;
    }

    private JSplitPane getSplitHoriz() {
        if (this.splitHoriz == null) {
            this.splitHoriz = new JSplitPane();
            this.splitHoriz.setLeftComponent(this.getPaneSelect());
            switch (this.displayOption) {
                case 0: {
                    this.splitHoriz.setRightComponent(this.getSplitVert());
                    break;
                }
                default: {
                    this.splitHoriz.setRightComponent(this.getPaneWork());
                }
            }
            this.splitHoriz.setDividerLocation(this.restoreDividerLocation(DIVIDER_HORIZONTAL, 300));
            this.splitHoriz.addPropertyChangeListener("dividerLocation", new DividerResizedListener(DIVIDER_HORIZONTAL));
            this.splitHoriz.setDividerSize(3);
            this.splitHoriz.setResizeWeight(0.3);
            this.splitHoriz.setContinuousLayout(false);
            this.splitHoriz.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.splitHoriz;
    }

    private JPanel getPaneStatus() {
        if (this.paneStatus == null) {
            this.paneStatus = new JPanel();
            this.paneStatus.setLayout(new BorderLayout(0, 0));
            this.paneStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneStatus.add(this.getTabbedStatus());
        }
        return this.paneStatus;
    }

    private JPanel getPaneSelect() {
        if (this.paneSelect == null) {
            this.paneSelect = new JPanel();
            this.paneSelect.setLayout(new BorderLayout(0, 0));
            this.paneSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneSelect.add(this.getTabbedSelect());
        }
        return this.paneSelect;
    }

    private JPanel getPaneWork() {
        if (this.paneWork == null) {
            this.paneWork = new JPanel();
            this.paneWork.setLayout(new BorderLayout(0, 0));
            this.paneWork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneWork.setCursor(new Cursor(0));
            this.paneWork.add(this.getTabbedWork());
        }
        return this.paneWork;
    }

    public void splitPaneWorkWithTabbedPanel(TabbedPanel tabbedPanel, int n) {
        this.getPaneWork().removeAll();
        JSplitPane jSplitPane = new JSplitPane(n);
        jSplitPane.setDividerSize(3);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setDoubleBuffered(true);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setRightComponent(tabbedPanel);
        jSplitPane.setLeftComponent(this.getTabbedWork());
        this.getPaneWork().add(jSplitPane);
        this.getPaneWork().validate();
    }

    public void removeSplitPaneWork() {
        this.getPaneWork().removeAll();
        this.getPaneWork().add(this.getTabbedWork());
        this.getPaneWork().validate();
    }

    public TabbedPanel2 getTabbedStatus() {
        if (this.tabbedStatus == null) {
            this.tabbedStatus = new TabbedPanel2();
            this.tabbedStatus.setPreferredSize(new Dimension(800, 200));
            this.tabbedStatus.setTabPlacement(1);
            this.tabbedStatus.setName("tabbedStatus");
            this.tabbedStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedStatus;
    }

    public TabbedPanel2 getTabbedOldStatus() {
        if (this.tabbedOldStatus == null) {
            this.tabbedOldStatus = new TabbedPanel2();
            this.tabbedOldStatus.setPreferredSize(new Dimension(800, 200));
            this.tabbedOldStatus.setTabPlacement(1);
            this.tabbedOldStatus.setName("tabbedOldStatus");
            this.tabbedOldStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedOldStatus;
    }

    public TabbedPanel2 getTabbedWork() {
        if (this.tabbedWork == null) {
            this.tabbedWork = new TabbedPanel2();
            this.tabbedWork.setPreferredSize(new Dimension(600, 400));
            this.tabbedWork.setName("tabbedWork");
            this.tabbedWork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedWork;
    }

    public TabbedPanel2 getTabbedOldWork() {
        if (this.tabbedOldWork == null) {
            this.tabbedOldWork = new TabbedPanel2();
            this.tabbedOldWork.setPreferredSize(new Dimension(600, 400));
            this.tabbedOldWork.setName("tabbedOldWork");
            this.tabbedOldWork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedOldWork;
    }

    public void setTabbedOldWork(TabbedPanel2 tabbedPanel2) {
        this.tabbedOldWork = tabbedPanel2.clone(tabbedPanel2);
    }

    public void setTabbedOldStatus(TabbedPanel2 tabbedPanel2) {
        this.tabbedOldStatus = tabbedPanel2.clone(tabbedPanel2);
    }

    public void setTabbedOldSelect(TabbedPanel2 tabbedPanel2) {
        this.tabbedOldSelect = tabbedPanel2.clone(tabbedPanel2);
    }

    public void toggleTabNames(boolean bl) {
        this.getTabbedStatus().setShowTabNames(bl);
        this.getTabbedSelect().setShowTabNames(bl);
        this.getTabbedWork().setShowTabNames(bl);
    }

    public TabbedPanel2 getTabbedSelect() {
        if (this.tabbedSelect == null) {
            this.tabbedSelect = new TabbedPanel2();
            this.tabbedSelect.setPreferredSize(new Dimension(200, 400));
            this.tabbedSelect.setName("tabbedSelect");
            this.tabbedSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedSelect;
    }

    public TabbedPanel2 getTabbedOldSelect() {
        if (this.tabbedOldSelect == null) {
            this.tabbedOldSelect = new TabbedPanel2();
            this.tabbedOldSelect.setPreferredSize(new Dimension(200, 400));
            this.tabbedOldSelect.setName("tabbedOldSelect");
            this.tabbedOldSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedOldSelect;
    }

    private void saveDividerLocation(String string, int n) {
        if (n > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving preference " + this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION + "=" + n));
            }
            this.preferences.put(this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION, Integer.toString(n));
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                this.logger.error((Object)"Error while saving the preferences", (Throwable)backingStoreException);
            }
        }
    }

    private int restoreDividerLocation(String string, int n) {
        int n2 = n;
        String string2 = this.preferences.get(this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION, null);
        if (string2 != null) {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n3 > 0) {
                n2 = n3;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring preference " + this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION + "=" + n3));
                }
            }
        }
        return n2;
    }

    private final class DividerResizedListener
    implements PropertyChangeListener {
        private final String prefix;

        public DividerResizedListener(String string) {
            assert (string != null);
            this.prefix = string;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
            if (jSplitPane != null) {
                if (WorkbenchPanel.this.logger.isDebugEnabled()) {
                    WorkbenchPanel.this.logger.debug((Object)(WorkbenchPanel.this.prefnzPrefix + this.prefix + "." + "location" + "=" + jSplitPane.getDividerLocation()));
                }
                WorkbenchPanel.this.saveDividerLocation(this.prefix, jSplitPane.getDividerLocation());
            }
        }
    }
}

