/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.model.VulnerabilitiesLoader;
import org.zaproxy.zap.model.Vulnerability;

public class VulnerabilitiesLoaderUnitTest {
    private static final Path DIRECTORY = Paths.get("test/resources/vulnerabilities/", new String[0]);
    private static final Path DIRECTORY_INVALID = Paths.get("test/resources/vulnerabilities/invalid", new String[0]);
    private static final String FILE_NAME = "vulnerabilities-test";
    private static final String FILE_EXTENSION = ".xml";
    public VulnerabilitiesLoader loader;

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrownExceptionIfDirectoryIsNull() {
        Path path = null;
        this.loader = new VulnerabilitiesLoader(path, FILE_NAME, FILE_EXTENSION);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrownExceptionIfFileNameIsNull() {
        String string = null;
        this.loader = new VulnerabilitiesLoader(DIRECTORY, string, FILE_EXTENSION);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrownExceptionIfFileNameIsEmpty() {
        String string = "";
        this.loader = new VulnerabilitiesLoader(DIRECTORY, string, FILE_EXTENSION);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrownExceptionIfFileExtensionIsNull() {
        String string = null;
        this.loader = new VulnerabilitiesLoader(DIRECTORY, FILE_NAME, string);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrownExceptionIfFileExtensionIsEmpty() {
        String string = "";
        this.loader = new VulnerabilitiesLoader(DIRECTORY, FILE_NAME, string);
    }

    @Test
    public void shouldReturnEmptyListIfVulnerabilitiesFileNotFound() {
        this.loader = new VulnerabilitiesLoader(DIRECTORY, "FileNotFound", ".NoExtension");
        List<Vulnerability> list = this.loader.load(Locale.ROOT);
        Assert.assertThat(list, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldReturnListWithVulnerabilitiesForDefaultLocale() {
        this.loader = new VulnerabilitiesLoader(DIRECTORY, FILE_NAME, FILE_EXTENSION);
        List<Vulnerability> list = this.loader.load(Locale.ROOT);
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        Vulnerability vulnerability = list.get(0);
        Assert.assertThat((Object)vulnerability.getId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"wasc_1")));
        Assert.assertThat((Object)vulnerability.getAlert(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Locale default")));
        Assert.assertThat((Object)vulnerability.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Description default")));
        Assert.assertThat((Object)vulnerability.getSolution(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Solution default")));
        Assert.assertThat((Object)vulnerability.getReferences().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        Assert.assertThat((Object)vulnerability.getReferences().get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Reference default 1")));
        Assert.assertThat((Object)vulnerability.getReferences().get(1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Reference default 2")));
        Vulnerability vulnerability2 = list.get(1);
        Assert.assertThat((Object)vulnerability2.getId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"wasc_2")));
        Assert.assertThat((Object)vulnerability2.getAlert(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Alert 2")));
        Assert.assertThat((Object)vulnerability2.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Description 2")));
        Assert.assertThat((Object)vulnerability2.getSolution(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Solution 2")));
        Assert.assertThat((Object)vulnerability2.getReferences().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((Object)vulnerability2.getReferences().get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Reference 2")));
    }

    @Test
    public void shouldLoadFileWithSameLanguageCountryWhenAvailable() {
        Locale locale = new Locale.Builder().setLanguage("nl").setRegion("NL").build();
        this.loader = new VulnerabilitiesLoader(DIRECTORY, FILE_NAME, FILE_EXTENSION);
        List<Vulnerability> list = this.loader.load(locale);
        Assert.assertThat(list, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Assert.assertThat((Object)list.get(0).getAlert(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Locale nl_NL")));
    }

    @Test
    public void shouldLoadDefaultFileEvenIfFileWithSameLanguageButDifferentCountryIsAvailable() {
        Locale.setDefault(new Locale("nl", "XX"));
        Locale locale = new Locale.Builder().setLanguage("nl").setRegion("XX").build();
        this.loader = new VulnerabilitiesLoader(DIRECTORY, FILE_NAME, FILE_EXTENSION);
        List<Vulnerability> list = this.loader.load(locale);
        Assert.assertThat(list, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Assert.assertThat((Object)list.get(0).getAlert(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Locale default")));
    }

    @Test
    public void shouldLoadFileWithOnlyLanguageMatchWhenLanguageCountryNotAvailable() {
        Locale locale = new Locale.Builder().setLanguage("es").setRegion("AR").build();
        this.loader = new VulnerabilitiesLoader(DIRECTORY, FILE_NAME, FILE_EXTENSION);
        List<Vulnerability> list = this.loader.load(locale);
        Assert.assertThat(list, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Assert.assertThat((Object)list.get(0).getAlert(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Locale es")));
    }

    @Test
    public void shouldReturnEmptyListIfFoundFileIsEmpty() {
        this.loader = new VulnerabilitiesLoader(DIRECTORY_INVALID, "vulnerabilities-test-empty", FILE_EXTENSION);
        List<Vulnerability> list = this.loader.load(Locale.ROOT);
        Assert.assertThat(list, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldReturnEmptyListIfFoundFileIsNotValidXml() {
        this.loader = new VulnerabilitiesLoader(DIRECTORY_INVALID, "vulnerabilities-test-invalid-xml", FILE_EXTENSION);
        List<Vulnerability> list = this.loader.load(Locale.ROOT);
        Assert.assertThat(list, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }
}

