/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagecontainer.http;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.messagecontainer.http.DefaultMultipleHistoryReferencesContainer;
import org.zaproxy.zap.view.messagecontainer.http.PersistedHttpMessagesList;
import org.zaproxy.zap.view.messagecontainer.http.SelectableHistoryReferencesContainer;

public class DefaultSelectableHistoryReferencesContainer
extends DefaultMultipleHistoryReferencesContainer
implements SelectableHistoryReferencesContainer {
    private final List<HistoryReference> selectedHistoryReferences;
    private final List<HttpMessage> selectedHttpMessages;

    public DefaultSelectableHistoryReferencesContainer(String string, Component component) {
        this(string, component, null, null);
    }

    public DefaultSelectableHistoryReferencesContainer(String string, Component component, List<HistoryReference> list) {
        this(string, component, list, null);
    }

    public DefaultSelectableHistoryReferencesContainer(String string, Component component, List<HistoryReference> list, List<HistoryReference> list2) {
        super(string, component, list);
        if (list2 == null || list2.isEmpty()) {
            this.selectedHistoryReferences = Collections.emptyList();
            this.selectedHttpMessages = Collections.emptyList();
        } else {
            this.selectedHistoryReferences = Collections.unmodifiableList(new ArrayList<HistoryReference>(list2));
            this.selectedHttpMessages = new PersistedHttpMessagesList(list2);
        }
    }

    @Override
    public boolean hasSelectedMessages() {
        return !this.selectedHttpMessages.isEmpty();
    }

    @Override
    public boolean isOnlyOneMessageSelected() {
        return this.selectedHttpMessages.size() == 1;
    }

    @Override
    public HttpMessage getSelectedMessage() {
        if (this.hasSelectedMessages()) {
            return this.selectedHttpMessages.get(0);
        }
        return null;
    }

    @Override
    public int getNumberOfSelectedMessages() {
        return this.selectedHttpMessages.size();
    }

    @Override
    public List<HttpMessage> getSelectedMessages() {
        return this.selectedHttpMessages;
    }

    @Override
    public HistoryReference getSelectedHistoryReference() {
        if (this.hasSelectedMessages()) {
            return this.selectedHistoryReferences.get(0);
        }
        return null;
    }

    @Override
    public List<HistoryReference> getSelectedHistoryReferences() {
        return this.selectedHistoryReferences;
    }
}

