/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Clipboard;
import java.util.HashMap;

public class ClipboardAssistance {
    private final HashMap<String, Object> cacheData = new HashMap();
    private final Clipboard clipboard;
    private int supportedActions = 0x4FFFFFFF;

    public ClipboardAssistance(String cipboardName) {
        this.clipboard = Clipboard.get(cipboardName);
        this.clipboard.add(this);
    }

    public void close() {
        this.clipboard.remove(this);
    }

    public void flush() {
        this.clipboard.flush(this, this.cacheData, this.supportedActions);
    }

    public void emptyCache() {
        this.cacheData.clear();
    }

    public boolean isCacheEmpty() {
        return this.cacheData.isEmpty();
    }

    public void setData(String mimeType, Object data) {
        this.cacheData.put(mimeType, data);
    }

    public Object getData(String mimeType) {
        return this.clipboard.getData(mimeType);
    }

    public void setSupportedActions(int supportedActions) {
        this.supportedActions = supportedActions;
    }

    public int getSupportedSourceActions() {
        return this.clipboard.getSupportedSourceActions();
    }

    public void setTargetAction(int actionDone) {
        this.clipboard.setTargetAction(actionDone);
    }

    public void contentChanged() {
    }

    public void actionPerformed(int action) {
    }

    public String[] getMimeTypes() {
        return this.clipboard.getMimeTypes();
    }

    public String toString() {
        return "ClipboardAssistance[" + this.clipboard + "]";
    }

    public String dumpToString() {
        StringBuilder out = new StringBuilder("{ClipboardAssistance[").append(this.clipboard.toString()).append("]");
        String[] mimes = this.getMimeTypes();
        if (mimes == null) {
            out.append(" clipbard is empty");
        } else {
            for (String mime : mimes) {
                out.append("\nmimeType:").append(mime).append(" value:").append(this.getData(mime));
            }
            out.append("\n");
        }
        out.append("}ClipboardAssistance");
        return out.toString();
    }
}

