/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.event.EventHandlerManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;

@DefaultProperty(value="content")
public class Tab
implements EventTarget {
    private StringProperty id;
    private StringProperty style;
    private ReadOnlyBooleanWrapper selected;
    private ReadOnlyObjectWrapper<TabPane> tabPane;
    private StringProperty text;
    private ObjectProperty<Node> graphic;
    private ObjectProperty<Node> content;
    private ObjectProperty<ContextMenu> contextMenu;
    private BooleanProperty closable;
    public static final EventType<Event> SELECTION_CHANGED_EVENT = new EventType();
    private ObjectProperty<EventHandler<Event>> onSelectionChanged;
    public static final EventType<Event> CLOSED_EVENT = new EventType();
    private ObjectProperty<EventHandler<Event>> onClosed;
    private ObjectProperty<Tooltip> tooltip;
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    private BooleanProperty disable;
    private ReadOnlyBooleanWrapper disabled;
    private static final Object USER_DATA_KEY = new Object();
    private ObservableMap<Object, Object> properties;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private static final String DEFAULT_STYLE_CLASS = "tab";
    protected Styleable styleable;

    public Tab() {
        this(null);
    }

    public Tab(String string) {
        this.setText(string);
        this.styleClass.addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final void setId(String string) {
        this.idProperty().set(string);
    }

    public final String getId() {
        return this.id == null ? null : (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty(this, "id");
        }
        return this.id;
    }

    public final void setStyle(String string) {
        this.styleProperty().set(string);
    }

    public final String getStyle() {
        return this.style == null ? null : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty(this, "style");
        }
        return this.style;
    }

    final void setSelected(boolean bl) {
        this.selectedPropertyImpl().set(bl);
    }

    public final boolean isSelected() {
        return this.selected == null ? false : this.selected.get();
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selectedPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper selectedPropertyImpl() {
        if (this.selected == null) {
            this.selected = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    if (Tab.this.getOnSelectionChanged() != null) {
                        Event.fireEvent(Tab.this, new Event(SELECTION_CHANGED_EVENT));
                    }
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    final void setTabPane(TabPane tabPane) {
        this.tabPanePropertyImpl().set(tabPane);
    }

    public final TabPane getTabPane() {
        return this.tabPane == null ? null : (TabPane)this.tabPane.get();
    }

    public final ReadOnlyObjectProperty<TabPane> tabPaneProperty() {
        return this.tabPanePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TabPane> tabPanePropertyImpl() {
        if (this.tabPane == null) {
            this.tabPane = new ReadOnlyObjectWrapper(this, "tabPane");
        }
        return this.tabPane;
    }

    public final void setText(String string) {
        this.textProperty().set(string);
    }

    public final String getText() {
        return this.text == null ? null : (String)this.text.get();
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty(this, "text");
        }
        return this.text;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().set(node);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty<Node>(this, "graphic");
        }
        return this.graphic;
    }

    public final void setContent(Node node) {
        this.contentProperty().set(node);
    }

    public final Node getContent() {
        return this.content == null ? null : (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty().set(contextMenu);
    }

    public final ContextMenu getContextMenu() {
        return this.contextMenu == null ? null : (ContextMenu)this.contextMenu.get();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        if (this.contextMenu == null) {
            this.contextMenu = new SimpleObjectProperty<ContextMenu>(this, "contextMenu");
        }
        return this.contextMenu;
    }

    public final void setClosable(boolean bl) {
        this.closableProperty().set(bl);
    }

    public final boolean isClosable() {
        return this.closable == null ? true : this.closable.get();
    }

    public final BooleanProperty closableProperty() {
        if (this.closable == null) {
            this.closable = new SimpleBooleanProperty(this, "closable", true);
        }
        return this.closable;
    }

    public final void setOnSelectionChanged(EventHandler<Event> eventHandler) {
        this.onSelectionChangedProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnSelectionChanged() {
        return this.onSelectionChanged == null ? null : (EventHandler)this.onSelectionChanged.get();
    }

    public final ObjectProperty<EventHandler<Event>> onSelectionChangedProperty() {
        if (this.onSelectionChanged == null) {
            this.onSelectionChanged = new ObjectPropertyBase<EventHandler<Event>>(){

                @Override
                protected void invalidated() {
                    Tab.this.setEventHandler(SELECTION_CHANGED_EVENT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "onSelectionChanged";
                }
            };
        }
        return this.onSelectionChanged;
    }

    public final void setOnClosed(EventHandler<Event> eventHandler) {
        this.onClosedProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnClosed() {
        return this.onClosed == null ? null : (EventHandler)this.onClosed.get();
    }

    public final ObjectProperty<EventHandler<Event>> onClosedProperty() {
        if (this.onClosed == null) {
            this.onClosed = new ObjectPropertyBase<EventHandler<Event>>(){

                @Override
                protected void invalidated() {
                    Tab.this.setEventHandler(CLOSED_EVENT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "onClosed";
                }
            };
        }
        return this.onClosed;
    }

    public final void setTooltip(Tooltip tooltip) {
        this.tooltipProperty().setValue(tooltip);
    }

    public final Tooltip getTooltip() {
        return this.tooltip == null ? null : (Tooltip)this.tooltip.getValue();
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new SimpleObjectProperty<Tooltip>(this, "tooltip");
        }
        return this.tooltip;
    }

    public final void setDisable(boolean bl) {
        this.disableProperty().set(bl);
    }

    public final boolean isDisable() {
        return this.disable == null ? false : this.disable.get();
    }

    public final BooleanProperty disableProperty() {
        if (this.disable == null) {
            this.disable = new BooleanPropertyBase(false){

                @Override
                protected void invalidated() {
                    Tab.this.updateDisabled();
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "disable";
                }
            };
        }
        return this.disable;
    }

    private final void setDisabled(boolean bl) {
        this.disabledPropertyImpl().set(bl);
    }

    public final boolean isDisabled() {
        return this.disabled == null ? false : this.disabled.get();
    }

    public final ReadOnlyBooleanProperty disabledProperty() {
        return this.disabledPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper disabledPropertyImpl() {
        if (this.disabled == null) {
            this.disabled = new ReadOnlyBooleanWrapper(){

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "disabled";
                }
            };
        }
        return this.disabled;
    }

    private void updateDisabled() {
        this.setDisabled(this.isDisable() || this.getTabPane() != null && this.getTabPane().isDisabled());
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.prepend(this.eventHandlerManager);
    }

    protected <E extends Event> void setEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.setEventHandler(eventType, eventHandler);
    }

    @Deprecated
    public Styleable impl_getStyleable() {
        if (this.styleable == null) {
            this.styleable = new Styleable(){

                @Override
                public String getId() {
                    return Tab.this.getId();
                }

                @Override
                public List<String> getStyleClass() {
                    return Tab.this.getStyleClass();
                }

                @Override
                public String getStyle() {
                    return Tab.this.getStyle();
                }

                @Override
                public Styleable getStyleableParent() {
                    return Tab.this.getTabPane() != null ? Tab.this.getTabPane().impl_getStyleable() : null;
                }

                @Override
                public List<StyleableProperty> getStyleableProperties() {
                    return Collections.EMPTY_LIST;
                }

                @Override
                public Node getNode() {
                    return null;
                }
            };
        }
        return this.styleable;
    }
}

