/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.preferences;

import java.awt.Component;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.model.Filter;
import net.sourceforge.glsof.common.preferences.AbstractCommandDialog;
import net.sourceforge.glsof.common.preferences.LsofParameterType;
import net.sourceforge.glsof.common.utils.GBCBuilder;

class TextExcludeCommandDialog
extends AbstractCommandDialog {
    protected JTextField _text = new JTextField(20);
    protected JCheckBox _exclude = new JCheckBox(Messages.NLS("Exclude"));

    public TextExcludeCommandDialog(LsofParameterType type) {
        super(type);
    }

    @Override
    protected void createDialogArea(JPanel parent) {
        parent.add((Component)this.createLabel(), new GBCBuilder().gridx(0).gridy(0).anchor(17).insets(new Insets(5, 5, 5, 5)).build());
        parent.add((Component)this._text, new GBCBuilder().gridx(1).gridy(0).weightx(1.0).fill(2).insets(new Insets(5, 5, 5, 5)).gridwidth(3).build());
        parent.add((Component)this._exclude, new GBCBuilder().gridx(4).gridy(0).anchor(21).insets(new Insets(5, 5, 5, 5)).build());
    }

    @Override
    protected boolean inputIsCorrect() {
        return this.inputIsCorrect(this._text.getText(), Messages.NLS("You_cannot_entry_an_empty_value"));
    }

    @Override
    protected List<String> getModelFilterValuesFromTheMask() {
        return Arrays.asList(this._text.getText().trim(), String.valueOf(this._exclude.isSelected()));
    }

    @Override
    public void copyValuesInTheMask(Filter filter) {
        List<String> values = filter.getValues();
        this._text.setText(values.get(0).trim());
        this._exclude.setSelected(Boolean.valueOf(values.get(1)));
    }
}

