/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.Arara;
import com.github.arara.exception.AraraException;
import com.github.arara.model.AraraConfiguration;
import com.github.arara.model.AraraFilePattern;
import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.AraraLogging;
import com.github.arara.utils.AraraUtils;
import com.github.arara.utils.LanguageController;
import java.io.File;
import java.io.FileReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationLoader {
    private List<String> paths = new ArrayList<String>();
    private String applicationPath;
    private List<AraraFilePattern> filePatterns;
    private String[] validExtensions;
    private AraraFilePattern chosenFilePattern;
    static final AraraLocalization localization = AraraLocalization.getInstance();

    public ConfigurationLoader() {
        try {
            this.applicationPath = Arara.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            this.applicationPath = URLDecoder.decode(this.applicationPath, "UTF-8");
            this.applicationPath = new File(this.applicationPath).getParentFile().getPath();
        }
        catch (Exception exception) {
            this.applicationPath = "";
        }
    }

    public void load() throws Exception {
        LanguageController languageController;
        AraraFilePattern texPattern = new AraraFilePattern();
        texPattern.setExtension("tex");
        texPattern.setPattern("^(\\s)*%\\s+");
        AraraFilePattern dtxPattern = new AraraFilePattern();
        dtxPattern.setExtension("dtx");
        dtxPattern.setPattern("^(\\s)*%\\s+");
        AraraFilePattern ltxPattern = new AraraFilePattern();
        ltxPattern.setExtension("ltx");
        ltxPattern.setPattern("^(\\s)*%\\s+");
        ArrayList<AraraFilePattern> defaultPatterns = new ArrayList<AraraFilePattern>();
        defaultPatterns.add(texPattern);
        defaultPatterns.add(dtxPattern);
        defaultPatterns.add(ltxPattern);
        this.filePatterns = new ArrayList<AraraFilePattern>();
        File configurationFile = new File(SystemUtils.USER_HOME + File.separator + "araraconfig.yaml");
        if (!configurationFile.exists()) {
            this.paths.add(this.applicationPath + File.separator + "rules");
            this.filePatterns.addAll(defaultPatterns);
            this.validExtensions = new String[this.filePatterns.size()];
            for (int i = 0; i < this.filePatterns.size(); ++i) {
                this.validExtensions[i] = ".".concat(this.filePatterns.get(i).getExtension());
            }
            return;
        }
        Representer representer = new Representer();
        representer.addClassTag(AraraConfiguration.class, new Tag("!config"));
        representer.addClassTag(AraraFilePattern.class, new Tag("!pattern"));
        Yaml yaml = new Yaml(new Constructor(AraraConfiguration.class), representer);
        FileReader fileReader = new FileReader(configurationFile);
        AraraConfiguration configuration = null;
        try {
            configuration = (AraraConfiguration)yaml.load(fileReader);
        }
        catch (MarkedYAMLException yamlException) {
            AraraLogging.enableLogging(false);
            throw new AraraException(localization.getMessage("Error_InvalidYAMLConfigurationFile").concat("\n\n").concat(AraraUtils.extractInformationFromYAMLException(yamlException)));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        fileReader.close();
        if (configuration == null) {
            AraraLogging.enableLogging(false);
            throw new AraraException(localization.getMessage("Error_InvalidConfigurationFile"));
        }
        if (configuration.getLanguage() != null && !(languageController = new LanguageController()).setLanguage(configuration.getLanguage())) {
            AraraLogging.enableLogging(false);
            throw new AraraException(localization.getMessage("Error_InvalidLanguageConfigurationFile", languageController.getLanguagesList()));
        }
        if (configuration.getPaths() != null) {
            if (configuration.getPathRuntimeException() != null) {
                AraraLogging.enableLogging(false);
                throw new AraraException(localization.getMessage("Error_PathRuntimeErrorConfigurationFile", AraraUtils.getVariableFromException(configuration.getPathRuntimeException())));
            }
            if (configuration.getPathIOException() != null) {
                AraraLogging.enableLogging(false);
                throw new AraraException(localization.getMessage("Error_PathIOErrorConfigurationFile"));
            }
            for (String currentPath : configuration.getPaths()) {
                this.paths.add(currentPath);
            }
        }
        this.paths.add(this.applicationPath + File.separator + "rules");
        if (configuration.getFiletypes() != null) {
            List<AraraFilePattern> filetypes = configuration.getFiletypes();
            for (int i = 0; i < defaultPatterns.size(); ++i) {
                if (this.isAlreadyDefined((AraraFilePattern)defaultPatterns.get(i), filetypes)) continue;
                this.filePatterns.add((AraraFilePattern)defaultPatterns.get(i));
            }
            this.filePatterns.addAll(filetypes);
            this.validExtensions = new String[this.filePatterns.size()];
            int counter = 0;
            for (AraraFilePattern currentPattern : this.filePatterns) {
                if (currentPattern.getPattern() == null || currentPattern.getExtension() == null) {
                    AraraLogging.enableLogging(false);
                    throw new AraraException(localization.getMessage("Error_InvalidFiletypesConfigurationFile"));
                }
                this.validExtensions[counter] = ".".concat(currentPattern.getExtension());
                ++counter;
            }
        } else {
            this.filePatterns.addAll(defaultPatterns);
            this.validExtensions = new String[this.filePatterns.size()];
            for (int i = 0; i < this.filePatterns.size(); ++i) {
                this.validExtensions[i] = ".".concat(this.filePatterns.get(i).getExtension());
            }
        }
    }

    private boolean isAlreadyDefined(AraraFilePattern filePattern, List<AraraFilePattern> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!filePattern.getExtension().equalsIgnoreCase(list.get(i).getExtension())) continue;
            if (list.get(i).getPattern() == null) {
                list.set(i, filePattern);
            }
            return true;
        }
        return false;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<AraraFilePattern> getFilePatterns() {
        return this.filePatterns;
    }

    public String[] getValidExtensions() {
        return this.validExtensions;
    }

    public void setChosenFilePattern(String extension) {
        for (AraraFilePattern currentPattern : this.filePatterns) {
            if (!".".concat(currentPattern.getExtension()).equals(extension)) continue;
            this.chosenFilePattern = currentPattern;
            return;
        }
        this.chosenFilePattern = null;
    }

    public AraraFilePattern getChosenFilePattern() {
        return this.chosenFilePattern;
    }
}

