/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.layouting.input.style.keys.color.ColorStyleKeys;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.modules.output.graphics.PageDrawable;
import org.jfree.layouting.output.pageable.BorderShapeFactory;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.text.Glyph;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class LogicalPageDrawable
implements PageDrawable {
    private static final boolean OUTLINE_MODE = false;
    private LogicalPageBox rootBox;
    private PageFormat pageFormat;
    private double width;
    private double height;

    public LogicalPageDrawable(LogicalPageBox logicalPageBox) {
        this.rootBox = logicalPageBox;
        this.width = (float)logicalPageBox.getPageWidth() / 1000.0f;
        this.height = (float)logicalPageBox.getPageHeight() / 1000.0f;
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, this.width, this.height);
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(paper);
    }

    public PageFormat getPageFormat() {
        return (PageFormat)this.pageFormat.clone();
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)this.width, (int)this.height);
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setPaint(Color.white);
        graphics2D.fill(rectangle2D);
        this.drawBox(graphics2D, this.rootBox.getHeaderArea(), 0);
        this.drawBox(graphics2D, this.rootBox, 0);
        this.drawBox(graphics2D, this.rootBox.getFooterArea(), 0);
    }

    private void drawDebugBox(Graphics2D graphics2D, RenderBox renderBox) {
        if (renderBox instanceof TableCellRenderBox) {
            graphics2D.setPaint(Color.yellow);
        } else if (renderBox instanceof TableRowRenderBox) {
            graphics2D.setPaint(Color.green);
        } else if (renderBox instanceof TableSectionRenderBox) {
            graphics2D.setPaint(Color.red);
        } else if (renderBox instanceof TableRenderBox) {
            graphics2D.setPaint(Color.blue);
        } else if (renderBox instanceof ParagraphRenderBox) {
            graphics2D.setPaint(Color.magenta);
        } else if (renderBox instanceof ParagraphPoolBox) {
            graphics2D.setPaint(Color.orange);
        } else {
            graphics2D.setPaint(Color.lightGray);
        }
        int n = (int)(renderBox.getX() / 1000L);
        int n2 = (int)(renderBox.getY() / 1000L);
        int n3 = (int)(renderBox.getWidth() / 1000L);
        int n4 = (int)(renderBox.getHeight() / 1000L);
        graphics2D.drawRect(n, n2, n3, n4);
    }

    public void drawBox(Graphics2D graphics2D, RenderBox renderBox, int n) {
        Object object = new BorderShapeFactory(renderBox);
        ((BorderShapeFactory)object).generateBorder(graphics2D);
        for (object = renderBox.getFirstChild(); object != null; object = ((RenderNode)object).getNext()) {
            if (object instanceof RenderBox) {
                this.drawBox(graphics2D, (RenderBox)object, n + 1);
                continue;
            }
            if (object instanceof RenderableText) {
                this.drawText(graphics2D, (RenderableText)object);
                continue;
            }
            if (!(object instanceof RenderableReplacedContent)) continue;
            this.drawReplacedContent(graphics2D, (RenderableReplacedContent)object);
        }
    }

    private void drawReplacedContent(Graphics2D graphics2D, RenderableReplacedContent renderableReplacedContent) {
        Object object = renderableReplacedContent.getRawObject();
        if (object instanceof Image) {
            int n = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getX());
            int n2 = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getY());
            int n3 = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getWidth());
            int n4 = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getHeight());
            graphics2D.drawImage((Image)object, n, n2, n3, n4, null);
        } else if (object instanceof DrawableWrapper) {
            double d = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getX());
            double d2 = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getY());
            double d3 = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getWidth());
            double d4 = (int)StrictGeomUtility.toExternalValue(renderableReplacedContent.getHeight());
            DrawableWrapper drawableWrapper = (DrawableWrapper)object;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            drawableWrapper.draw(graphics2D2, (Rectangle2D)new Rectangle2D.Double(d, d2, d3, d4));
            graphics2D2.dispose();
        }
    }

    private void drawText(Graphics2D graphics2D, RenderableText renderableText) {
        Glyph[] glyphArray = renderableText.getGlyphs();
        long l = renderableText.getX();
        long l2 = renderableText.getY();
        long l3 = l;
        LayoutContext layoutContext = renderableText.getLayoutContext();
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        int n = 0;
        if (fontSpecification.getFontWeight() > 400) {
            n |= 1;
        }
        if (fontSpecification.isItalic() || fontSpecification.isOblique()) {
            n |= 2;
        }
        CSSColorValue cSSColorValue = (CSSColorValue)layoutContext.getValue(ColorStyleKeys.COLOR);
        graphics2D.setColor(cSSColorValue);
        graphics2D.setFont(new Font(fontSpecification.getFontFamily(), n, (int)fontSpecification.getFontSize()));
        int n2 = renderableText.getOffset() + renderableText.getLength();
        for (int i = renderableText.getOffset(); i < n2; ++i) {
            Glyph glyph = glyphArray[i];
            graphics2D.drawString(LogicalPageDrawable.glpyhToString(glyph), (float)l3 / 1000.0f, (float)(l2 + (long)glyph.getBaseLine()) / 1000.0f);
            l3 += (long)glyph.getWidth();
        }
    }

    public static String glpyhToString(Glyph glyph) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(0xFFFF & glyph.getCodepoint()));
        int[] nArray = glyph.getExtraChars();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(", ");
            int n = nArray[i];
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }
}

