/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class ITextFontRecord
implements FontRecord,
FontIdentifier {
    private FontFamily fontFamily;
    private boolean bold;
    private boolean italic;
    private boolean oblique;

    public ITextFontRecord(FontFamily fontFamily, boolean bold, boolean italic, boolean oblique) {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = fontFamily;
        this.bold = bold;
        this.italic = italic;
        this.oblique = oblique;
    }

    public FontFamily getFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isOblique() {
        return this.oblique;
    }

    public FontIdentifier getIdentifier() {
        return this;
    }

    public boolean isScalable() {
        return true;
    }

    public FontType getFontType() {
        return FontType.OTHER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ITextFontRecord that = (ITextFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.italic != that.italic) {
            return false;
        }
        if (this.oblique != that.oblique) {
            return false;
        }
        return this.fontFamily.equals(that.fontFamily);
    }

    public int hashCode() {
        int result = this.fontFamily.hashCode();
        result = 29 * result + (this.bold ? 1 : 0);
        result = 29 * result + (this.italic ? 1 : 0);
        result = 29 * result + (this.oblique ? 1 : 0);
        return result;
    }
}

