/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockBodyContent;
import com.mockrunner.mock.web.MockJspWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;

public class MockPageContext
extends PageContext {
    protected ServletConfig config;
    protected ServletRequest request;
    protected ServletResponse response;
    private JspWriter jspWriter;
    private Stack outStack;
    private Exception exception;
    private Object page;
    private HashMap attributes;

    public MockPageContext() {
        this(null, null, null);
    }

    public MockPageContext(ServletConfig servletConfig, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.config = servletConfig;
        this.request = servletRequest;
        this.jspWriter = new MockJspWriter();
        this.initJspWriterWithResponse(servletResponse);
        this.outStack = new Stack();
        this.attributes = new HashMap();
    }

    private void initJspWriterWithResponse(ServletResponse servletResponse) {
        this.response = servletResponse;
        if (null != servletResponse && servletResponse instanceof HttpServletResponse) {
            try {
                this.jspWriter = new MockJspWriter((HttpServletResponse)servletResponse);
            }
            catch (IOException iOException) {
                throw new NestedApplicationException(iOException);
            }
        }
    }

    public void setJspWriter(JspWriter jspWriter) {
        this.jspWriter = jspWriter;
    }

    public void setPage(Object object) {
        this.page = object;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.config = servletConfig;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this.request = servletRequest;
    }

    public void setServletResponse(ServletResponse servletResponse) {
        this.response = servletResponse;
        this.initJspWriterWithResponse(servletResponse);
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Object findAttribute(String string) {
        Object object = this.getAttribute(string, 1);
        if (object == null) {
            object = this.getAttribute(string, 2);
        }
        if (object == null) {
            object = this.getAttribute(string, 3);
        }
        if (object == null) {
            object = this.getAttribute(string, 4);
        }
        return object;
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, 1);
    }

    public Object getAttribute(String string, int n) {
        if (n == 1) {
            return this.attributes.get(string);
        }
        if (n == 2) {
            if (null == this.request) {
                return null;
            }
            return this.request.getAttribute(string);
        }
        if (n == 3) {
            if (null == this.getSession()) {
                return null;
            }
            return this.getSession().getAttribute(string);
        }
        if (n == 4) {
            if (null == this.getServletContext()) {
                return null;
            }
            return this.getServletContext().getAttribute(string);
        }
        throw new IllegalArgumentException("Invalid scope " + n);
    }

    public void removeAttribute(String string) {
        int n = this.getAttributesScope(string);
        if (n != 0) {
            this.removeAttribute(string, n);
        }
    }

    public void removeAttribute(String string, int n) {
        if (n == 1) {
            this.attributes.remove(string);
        } else if (n == 2) {
            if (this.request != null) {
                this.request.removeAttribute(string);
            }
        } else if (n == 3) {
            if (this.getSession() != null) {
                this.getSession().removeAttribute(string);
            }
        } else if (n == 4) {
            if (this.getServletContext() != null) {
                this.getServletContext().removeAttribute(string);
            }
        } else {
            throw new IllegalArgumentException("Invalid scope " + n);
        }
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(string, object, 1);
    }

    public void setAttribute(String string, Object object, int n) {
        if (n == 1) {
            this.attributes.put(string, object);
        } else if (n == 2) {
            if (this.request != null) {
                this.request.setAttribute(string, object);
            }
        } else if (n == 3) {
            if (this.getSession() != null) {
                this.getSession().setAttribute(string, object);
            }
        } else if (n == 4) {
            if (this.getServletContext() != null) {
                this.getServletContext().setAttribute(string, object);
            }
        } else {
            throw new IllegalArgumentException("Invalid scope " + n);
        }
    }

    public int getAttributesScope(String string) {
        if (this.getAttribute(string, 1) != null) {
            return 1;
        }
        if (this.getAttribute(string, 2) != null) {
            return 2;
        }
        if (this.getAttribute(string, 3) != null) {
            return 3;
        }
        if (this.getAttribute(string, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration getAttributeNamesInScope(int n) {
        if (n == 1) {
            return new WrappedEnumeration(this.attributes.keySet().iterator());
        }
        if (n == 2) {
            if (this.request == null) {
                return new NullEnumeration();
            }
            return this.request.getAttributeNames();
        }
        if (n == 3) {
            if (this.getSession() == null) {
                return new NullEnumeration();
            }
            return this.getSession().getAttributeNames();
        }
        if (n == 4) {
            if (this.getServletContext() == null) {
                return new NullEnumeration();
            }
            return this.getServletContext().getAttributeNames();
        }
        throw new IllegalArgumentException("Invalid scope " + n);
    }

    public JspWriter getOut() {
        return this.jspWriter;
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getPage() {
        return this.page;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        if (null == this.config) {
            return null;
        }
        return this.config.getServletContext();
    }

    public HttpSession getSession() {
        if (null == this.request) {
            return null;
        }
        return ((HttpServletRequest)this.request).getSession();
    }

    public void handlePageException(Exception exception) {
    }

    public void handlePageException(Throwable throwable) {
    }

    public void forward(String string) throws ServletException, IOException {
        RequestDispatcher requestDispatcher;
        if (null != this.request && null != (requestDispatcher = this.request.getRequestDispatcher(string))) {
            requestDispatcher.forward(this.request, this.response);
        }
    }

    public void include(String string) throws ServletException, IOException {
        RequestDispatcher requestDispatcher;
        if (null != this.request && null != (requestDispatcher = this.request.getRequestDispatcher(string))) {
            requestDispatcher.include(this.request, this.response);
        }
    }

    public void include(String string, boolean bl) throws ServletException, IOException {
        if (bl) {
            this.jspWriter.flush();
        }
        this.include(string);
    }

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
        this.config = servlet.getServletConfig();
        this.request = servletRequest;
        this.response = servletResponse;
        this.jspWriter = new MockJspWriter();
        this.outStack = new Stack();
        this.attributes = new HashMap();
    }

    public JspWriter popBody() {
        this.jspWriter = (JspWriter)this.outStack.pop();
        return this.jspWriter;
    }

    public BodyContent pushBody() {
        this.outStack.push(this.jspWriter);
        this.jspWriter = new MockBodyContent(this.jspWriter);
        return (BodyContent)this.jspWriter;
    }

    public JspWriter pushBody(Writer writer) {
        this.outStack.push(this.jspWriter);
        this.jspWriter = new MockJspWriter(writer);
        return this.jspWriter;
    }

    public void release() {
        this.jspWriter = new MockJspWriter();
        this.outStack = new Stack();
    }

    private class WrappedEnumeration
    implements Enumeration {
        private Iterator iterator;

        public WrappedEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }

    private class NullEnumeration
    implements Enumeration {
        private NullEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

