/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class StackMapFrameCodeStream
extends CodeStream {
    public int[] stateIndexes;
    public int stateIndexesCounter;
    private HashMap framePositions;
    public Set exceptionMarkers;
    public ArrayList stackDepthMarkers;
    public ArrayList stackMarkers;

    public StackMapFrameCodeStream(ClassFile classFile) {
        super(classFile);
        this.generateAttributes |= 0x10;
    }

    @Override
    public void addDefinitelyAssignedVariables(Scope scope, int n) {
        block0: for (int i = 0; i < this.visibleLocalsCount; ++i) {
            LocalVariableBinding localVariableBinding = this.visibleLocals[i];
            if (localVariableBinding == null) continue;
            boolean bl = this.isDefinitelyAssigned(scope, n, localVariableBinding);
            if (!bl) {
                if (this.stateIndexes == null) continue;
                int n2 = this.stateIndexesCounter;
                for (int j = 0; j < n2; ++j) {
                    if (!this.isDefinitelyAssigned(scope, this.stateIndexes[j], localVariableBinding)) continue;
                    if (localVariableBinding.initializationCount != 0 && localVariableBinding.initializationPCs[(localVariableBinding.initializationCount - 1 << 1) + 1] == -1) continue block0;
                    localVariableBinding.recordInitializationStartPC(this.position);
                    continue block0;
                }
                continue;
            }
            if (localVariableBinding.initializationCount != 0 && localVariableBinding.initializationPCs[(localVariableBinding.initializationCount - 1 << 1) + 1] == -1) continue;
            localVariableBinding.recordInitializationStartPC(this.position);
        }
    }

    public void addExceptionMarker(int n, TypeBinding typeBinding) {
        if (this.exceptionMarkers == null) {
            this.exceptionMarkers = new HashSet();
        }
        if (typeBinding == null) {
            this.exceptionMarkers.add(new ExceptionMarker(n, ConstantPool.JavaLangThrowableConstantPoolName));
        } else {
            switch (typeBinding.id) {
                case 12: {
                    this.exceptionMarkers.add(new ExceptionMarker(n, ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName));
                    break;
                }
                case 7: {
                    this.exceptionMarkers.add(new ExceptionMarker(n, ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName));
                    break;
                }
                default: {
                    this.exceptionMarkers.add(new ExceptionMarker(n, typeBinding.constantPoolName()));
                }
            }
        }
    }

    public void addFramePosition(int n) {
        Integer n2 = new Integer(n);
        FramePosition framePosition = (FramePosition)this.framePositions.get(n2);
        if (framePosition != null) {
            ++framePosition.counter;
        } else {
            this.framePositions.put(n2, new FramePosition());
        }
    }

    @Override
    public void optimizeBranch(int n, BranchLabel branchLabel) {
        super.optimizeBranch(n, branchLabel);
        this.removeFramePosition(n);
    }

    public void removeFramePosition(int n) {
        Integer n2 = new Integer(n);
        FramePosition framePosition = (FramePosition)this.framePositions.get(n2);
        if (framePosition != null) {
            --framePosition.counter;
            if (framePosition.counter <= 0) {
                this.framePositions.remove(n2);
            }
        }
    }

    @Override
    public void addVariable(LocalVariableBinding localVariableBinding) {
        if (localVariableBinding.initializationPCs == null) {
            this.record(localVariableBinding);
        }
        localVariableBinding.recordInitializationStartPC(this.position);
    }

    private void addStackMarker(int n, int n2) {
        if (this.stackMarkers == null) {
            this.stackMarkers = new ArrayList();
            this.stackMarkers.add(new StackMarker(n, n2));
        } else {
            int n3 = this.stackMarkers.size();
            if (n3 == 0 || ((StackMarker)this.stackMarkers.get((int)(n3 - 1))).pc != this.position) {
                this.stackMarkers.add(new StackMarker(n, n2));
            }
        }
    }

    private void addStackDepthMarker(int n, int n2, TypeBinding typeBinding) {
        if (this.stackDepthMarkers == null) {
            this.stackDepthMarkers = new ArrayList();
            this.stackDepthMarkers.add(new StackDepthMarker(n, n2, typeBinding));
        } else {
            int n3 = this.stackDepthMarkers.size();
            if (n3 == 0) {
                this.stackDepthMarkers.add(new StackDepthMarker(n, n2, typeBinding));
            } else {
                StackDepthMarker stackDepthMarker = (StackDepthMarker)this.stackDepthMarkers.get(n3 - 1);
                if (stackDepthMarker.pc != this.position) {
                    this.stackDepthMarkers.add(new StackDepthMarker(n, n2, typeBinding));
                } else {
                    this.stackDepthMarkers.set(n3 - 1, new StackDepthMarker(n, n2, typeBinding));
                }
            }
        }
    }

    @Override
    public void decrStackSize(int n) {
        super.decrStackSize(n);
        this.addStackDepthMarker(this.position, -1, null);
    }

    @Override
    public void recordExpressionType(TypeBinding typeBinding) {
        this.addStackDepthMarker(this.position, 0, typeBinding);
    }

    @Override
    public void generateClassLiteralAccessForType(TypeBinding typeBinding, FieldBinding fieldBinding) {
        if (typeBinding.isBaseType() && typeBinding != TypeBinding.NULL) {
            this.getTYPE(typeBinding.id);
            return;
        }
        if (this.targetLevel >= 0x310000L) {
            this.ldc(typeBinding);
        } else {
            BranchLabel branchLabel = new BranchLabel(this);
            if (fieldBinding != null) {
                this.fieldAccess((byte)-78, fieldBinding, null);
                this.dup();
                this.ifnonnull(branchLabel);
                this.pop();
            }
            ExceptionLabel exceptionLabel = new ExceptionLabel(this, TypeBinding.NULL);
            exceptionLabel.placeStart();
            this.ldc(typeBinding == TypeBinding.NULL ? "java.lang.Object" : String.valueOf(typeBinding.constantPoolName()).replace('/', '.'));
            this.invokeClassForName();
            exceptionLabel.placeEnd();
            if (fieldBinding != null) {
                this.dup();
                this.fieldAccess((byte)-77, fieldBinding, null);
            }
            int n = this.position;
            this.goto_(branchLabel);
            int n2 = this.stackDepth;
            this.pushExceptionOnStack(TypeBinding.NULL);
            exceptionLabel.place();
            this.newNoClassDefFoundError();
            this.dup_x1();
            this.swap();
            this.invokeThrowableGetMessage();
            this.invokeNoClassDefFoundErrorStringConstructor();
            this.athrow();
            branchLabel.place();
            this.addStackMarker(n, this.position);
            this.stackDepth = n2;
        }
    }

    @Override
    public void generateOuterAccess(Object[] objectArray, ASTNode aSTNode, Binding binding, Scope scope) {
        int n = this.position;
        super.generateOuterAccess(objectArray, aSTNode, binding, scope);
        if (n == this.position) {
            throw new AbortMethod(scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    public ExceptionMarker[] getExceptionMarkers() {
        Set set = this.exceptionMarkers;
        if (this.exceptionMarkers == null) {
            return null;
        }
        int n = set.size();
        Object[] objectArray = new ExceptionMarker[n];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectArray[n2++] = (ExceptionMarker)iterator.next();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public int[] getFramePositions() {
        Set set = this.framePositions.keySet();
        int n = set.size();
        int[] nArray = new int[n];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            nArray[n2++] = (Integer)iterator.next();
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public StackDepthMarker[] getStackDepthMarkers() {
        if (this.stackDepthMarkers == null) {
            return null;
        }
        int n = this.stackDepthMarkers.size();
        if (n == 0) {
            return null;
        }
        StackDepthMarker[] stackDepthMarkerArray = new StackDepthMarker[n];
        this.stackDepthMarkers.toArray(stackDepthMarkerArray);
        return stackDepthMarkerArray;
    }

    public StackMarker[] getStackMarkers() {
        if (this.stackMarkers == null) {
            return null;
        }
        int n = this.stackMarkers.size();
        if (n == 0) {
            return null;
        }
        StackMarker[] stackMarkerArray = new StackMarker[n];
        this.stackMarkers.toArray(stackMarkerArray);
        return stackMarkerArray;
    }

    public boolean hasFramePositions() {
        return this.framePositions.size() != 0;
    }

    @Override
    public void init(ClassFile classFile) {
        super.init(classFile);
        this.stateIndexesCounter = 0;
        if (this.framePositions != null) {
            this.framePositions.clear();
        }
        if (this.exceptionMarkers != null) {
            this.exceptionMarkers.clear();
        }
        if (this.stackDepthMarkers != null) {
            this.stackDepthMarkers.clear();
        }
        if (this.stackMarkers != null) {
            this.stackMarkers.clear();
        }
    }

    @Override
    public void initializeMaxLocals(MethodBinding methodBinding) {
        super.initializeMaxLocals(methodBinding);
        if (this.framePositions == null) {
            this.framePositions = new HashMap();
        } else {
            this.framePositions.clear();
        }
    }

    public void popStateIndex() {
        --this.stateIndexesCounter;
    }

    public void pushStateIndex(int n) {
        int n2;
        if (this.stateIndexes == null) {
            this.stateIndexes = new int[3];
        }
        if ((n2 = this.stateIndexes.length) == this.stateIndexesCounter) {
            this.stateIndexes = new int[n2 * 2];
            System.arraycopy(this.stateIndexes, 0, this.stateIndexes, 0, n2);
        }
        this.stateIndexes[this.stateIndexesCounter++] = n;
    }

    @Override
    public void removeNotDefinitelyAssignedVariables(Scope scope, int n) {
        int n2 = this.visibleLocalsCount;
        block0: for (int i = 0; i < n2; ++i) {
            boolean bl;
            LocalVariableBinding localVariableBinding = this.visibleLocals[i];
            if (localVariableBinding == null || localVariableBinding.initializationCount <= 0 || (bl = this.isDefinitelyAssigned(scope, n, localVariableBinding))) continue;
            if (this.stateIndexes != null) {
                int n3 = this.stateIndexesCounter;
                for (int j = 0; j < n3; ++j) {
                    if (this.isDefinitelyAssigned(scope, this.stateIndexes[j], localVariableBinding)) continue block0;
                }
            }
            localVariableBinding.recordInitializationEndPC(this.position);
        }
    }

    @Override
    public void reset(ClassFile classFile) {
        super.reset(classFile);
        this.stateIndexesCounter = 0;
        if (this.framePositions != null) {
            this.framePositions.clear();
        }
        if (this.exceptionMarkers != null) {
            this.exceptionMarkers.clear();
        }
        if (this.stackDepthMarkers != null) {
            this.stackDepthMarkers.clear();
        }
        if (this.stackMarkers != null) {
            this.stackMarkers.clear();
        }
    }

    @Override
    protected void writePosition(BranchLabel branchLabel) {
        super.writePosition(branchLabel);
        this.addFramePosition(branchLabel.position);
    }

    @Override
    protected void writePosition(BranchLabel branchLabel, int n) {
        super.writePosition(branchLabel, n);
        this.addFramePosition(branchLabel.position);
    }

    @Override
    protected void writeSignedWord(int n, int n2) {
        super.writeSignedWord(n, n2);
        this.addFramePosition(this.position);
    }

    @Override
    protected void writeWidePosition(BranchLabel branchLabel) {
        super.writeWidePosition(branchLabel);
        this.addFramePosition(branchLabel.position);
    }

    @Override
    public void areturn() {
        super.areturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void ireturn() {
        super.ireturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void lreturn() {
        super.lreturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void freturn() {
        super.freturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void dreturn() {
        super.dreturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void return_() {
        super.return_();
        this.addFramePosition(this.position);
    }

    @Override
    public void athrow() {
        super.athrow();
        this.addFramePosition(this.position);
    }

    @Override
    public void pushOnStack(TypeBinding typeBinding) {
        super.pushOnStack(typeBinding);
        this.addStackDepthMarker(this.position, 1, typeBinding);
    }

    @Override
    public void pushExceptionOnStack(TypeBinding typeBinding) {
        super.pushExceptionOnStack(typeBinding);
        this.addExceptionMarker(this.position, typeBinding);
    }

    @Override
    public void goto_(BranchLabel branchLabel) {
        super.goto_(branchLabel);
        this.addFramePosition(this.position);
    }

    @Override
    public void goto_w(BranchLabel branchLabel) {
        super.goto_w(branchLabel);
        this.addFramePosition(this.position);
    }

    @Override
    public void resetInWideMode() {
        this.resetSecretLocals();
        super.resetInWideMode();
    }

    @Override
    public void resetForCodeGenUnusedLocals() {
        this.resetSecretLocals();
        super.resetForCodeGenUnusedLocals();
    }

    public void resetSecretLocals() {
        for (LocalVariableBinding localVariableBinding : this.locals) {
            if (localVariableBinding == null || !localVariableBinding.isSecret()) continue;
            localVariableBinding.resetInitializations();
        }
    }

    static class FramePosition {
        int counter;

        FramePosition() {
        }
    }

    public static class StackMarker {
        public int pc;
        public int destinationPC;
        public VerificationTypeInfo[] infos;

        public StackMarker(int n, int n2) {
            this.pc = n;
            this.destinationPC = n2;
        }

        public void setInfos(VerificationTypeInfo[] verificationTypeInfoArray) {
            this.infos = verificationTypeInfoArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[copy stack items from ").append(this.pc).append(" to ").append(this.destinationPC);
            if (this.infos != null) {
                int n = this.infos.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.infos[i]);
                }
            }
            stringBuffer.append(']');
            return String.valueOf(stringBuffer);
        }
    }

    public static class StackDepthMarker {
        public int pc;
        public int delta;
        public TypeBinding typeBinding;

        public StackDepthMarker(int n, int n2, TypeBinding typeBinding) {
            this.pc = n;
            this.typeBinding = typeBinding;
            this.delta = n2;
        }

        public StackDepthMarker(int n, int n2) {
            this.pc = n;
            this.delta = n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(').append(this.pc).append(',').append(this.delta);
            if (this.typeBinding != null) {
                stringBuffer.append(',').append(this.typeBinding.qualifiedPackageName()).append(this.typeBinding.qualifiedSourceName());
            }
            stringBuffer.append(')');
            return String.valueOf(stringBuffer);
        }
    }

    public static class ExceptionMarker
    implements Comparable {
        public char[] constantPoolName;
        public int pc;

        public ExceptionMarker(int n, char[] cArray) {
            this.pc = n;
            this.constantPoolName = cArray;
        }

        public int compareTo(Object object) {
            if (object instanceof ExceptionMarker) {
                return this.pc - ((ExceptionMarker)object).pc;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof ExceptionMarker) {
                ExceptionMarker exceptionMarker = (ExceptionMarker)object;
                return this.pc == exceptionMarker.pc && CharOperation.equals(this.constantPoolName, exceptionMarker.constantPoolName);
            }
            return false;
        }

        public int hashCode() {
            return this.pc + this.constantPoolName.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(').append(this.pc).append(',').append(this.constantPoolName).append(')');
            return String.valueOf(stringBuffer);
        }
    }
}

