/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InferenceSubstitution;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class TypeVariableBinding
extends ReferenceBinding {
    public Binding declaringElement;
    public int rank;
    public TypeBinding firstBound;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public char[] genericTypeSignature;
    LookupEnvironment environment;
    boolean inRecursiveFunction = false;

    public TypeVariableBinding(char[] cArray, Binding binding, int n, LookupEnvironment lookupEnvironment) {
        this.sourceName = cArray;
        this.declaringElement = binding;
        this.rank = n;
        this.modifiers = 0x40000001;
        this.tagBits |= 0x20000000L;
        this.environment = lookupEnvironment;
        this.typeBits = 0x8000000;
    }

    public TypeVariableBinding(TypeVariableBinding typeVariableBinding) {
        super(typeVariableBinding);
        this.declaringElement = typeVariableBinding.declaringElement;
        this.rank = typeVariableBinding.rank;
        this.firstBound = typeVariableBinding.firstBound;
        this.superclass = typeVariableBinding.superclass;
        this.superInterfaces = typeVariableBinding.superInterfaces;
        this.genericTypeSignature = typeVariableBinding.genericTypeSignature;
        this.environment = typeVariableBinding.environment;
        typeVariableBinding.tagBits |= 0x800000L;
        this.tagBits &= 0xFFFFFFFFFF7FFFFFL;
    }

    public int boundCheck(Substitution substitution, TypeBinding typeBinding, Scope scope) {
        TypeBinding typeBinding2;
        int n = this.internalBoundCheck(substitution, typeBinding, scope);
        if (n == 2 && typeBinding instanceof TypeVariableBinding && scope != null && (typeBinding2 = ((TypeVariableBinding)typeBinding).firstBound) instanceof ParameterizedTypeBinding) {
            int n2 = this.boundCheck(substitution, typeBinding2.capture(scope, -1), scope);
            return Math.min(n, n2);
        }
        return n;
    }

    private int internalBoundCheck(Substitution substitution, TypeBinding typeBinding, Scope scope) {
        long l;
        boolean bl;
        if (typeBinding == TypeBinding.NULL || TypeBinding.equalsEquals(typeBinding, this)) {
            return 0;
        }
        boolean bl2 = bl = substitution != null;
        if (!(typeBinding instanceof ReferenceBinding) && !typeBinding.isArrayType()) {
            return 2;
        }
        if (this.superclass == null) {
            return 0;
        }
        if (typeBinding.kind() == 516) {
            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
            switch (wildcardBinding.boundKind) {
                case 1: {
                    TypeBinding typeBinding2 = wildcardBinding.bound;
                    if (TypeBinding.equalsEquals(typeBinding2, this)) {
                        return 0;
                    }
                    boolean bl3 = typeBinding2.isArrayType();
                    if (!typeBinding2.isInterface()) {
                        TypeBinding typeBinding3;
                        ReferenceBinding referenceBinding;
                        TypeBinding typeBinding4 = referenceBinding = bl ? Scope.substitute(substitution, this.superclass) : this.superclass;
                        if (referenceBinding.id != 1 && (bl3 ? !typeBinding2.isCompatibleWith(referenceBinding, scope) : ((typeBinding3 = typeBinding2.findSuperTypeOriginatingFrom(referenceBinding)) != null ? referenceBinding.isProvablyDistinct(typeBinding3) : ((typeBinding3 = referenceBinding.findSuperTypeOriginatingFrom(typeBinding2)) != null ? typeBinding3.isProvablyDistinct(typeBinding2) : !typeBinding2.isTypeVariable() && !referenceBinding.isTypeVariable())))) {
                            return 2;
                        }
                    }
                    boolean bl4 = bl3 || ((ReferenceBinding)typeBinding2).isFinal();
                    int n = this.superInterfaces.length;
                    for (int i = 0; i < n; ++i) {
                        TypeBinding typeBinding5;
                        ReferenceBinding referenceBinding;
                        TypeBinding typeBinding6 = referenceBinding = bl ? Scope.substitute(substitution, this.superInterfaces[i]) : this.superInterfaces[i];
                        if (!(bl3 ? !typeBinding2.isCompatibleWith(referenceBinding, scope) : ((typeBinding5 = typeBinding2.findSuperTypeOriginatingFrom(referenceBinding)) != null ? referenceBinding.isProvablyDistinct(typeBinding5) : bl4))) continue;
                        return 2;
                    }
                    break;
                }
                case 2: {
                    if (wildcardBinding.bound.isTypeVariable() && ((TypeVariableBinding)wildcardBinding.bound).superclass.id == 1) break;
                    return this.boundCheck(substitution, wildcardBinding.bound, scope);
                }
            }
            return 0;
        }
        boolean bl5 = false;
        if (this.superclass.id != 1) {
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding7 = referenceBinding = bl ? Scope.substitute(substitution, this.superclass) : this.superclass;
            if (TypeBinding.notEquals(referenceBinding, typeBinding)) {
                if (!typeBinding.isCompatibleWith(referenceBinding, scope)) {
                    return 2;
                }
                TypeBinding typeBinding8 = typeBinding.findSuperTypeOriginatingFrom(referenceBinding);
                if (typeBinding8 != null && typeBinding8.isRawType() && referenceBinding.isBoundParameterizedType()) {
                    bl5 = true;
                }
            }
        }
        int n = this.superInterfaces.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding9 = referenceBinding = bl ? Scope.substitute(substitution, this.superInterfaces[i]) : this.superInterfaces[i];
            if (!TypeBinding.notEquals(referenceBinding, typeBinding)) continue;
            if (!typeBinding.isCompatibleWith(referenceBinding, scope)) {
                return 2;
            }
            TypeBinding typeBinding10 = typeBinding.findSuperTypeOriginatingFrom(referenceBinding);
            if (typeBinding10 == null || !typeBinding10.isRawType() || !referenceBinding.isBoundParameterizedType()) continue;
            bl5 = true;
        }
        long l2 = NullAnnotationMatching.validNullTagBits(this.tagBits);
        if (l2 == 0L || (l = NullAnnotationMatching.validNullTagBits(typeBinding.tagBits)) != l2) {
            // empty if block
        }
        return bl5 ? 1 : 0;
    }

    public int boundsCount() {
        if (this.firstBound == null) {
            return 0;
        }
        if (TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
            return this.superInterfaces.length + 1;
        }
        return this.superInterfaces.length;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        int n2;
        if (this.declaringElement != inferenceContext.genericMethod) {
            return;
        }
        switch (typeBinding.kind()) {
            case 132: {
                if (typeBinding == TypeBinding.NULL) {
                    return;
                }
                TypeBinding typeBinding2 = scope.environment().computeBoxingType(typeBinding);
                if (typeBinding2 == typeBinding) {
                    return;
                }
                typeBinding = typeBinding2;
                break;
            }
            case 516: 
            case 65540: {
                return;
            }
        }
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        inferenceContext.recordSubstitute(this, typeBinding, n2);
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Binding binding = this.declaringElement;
        if (!bl && binding.kind() == 8) {
            MethodBinding methodBinding = (MethodBinding)binding;
            object = methodBinding.declaringClass;
            stringBuffer.append(((ReferenceBinding)object).computeUniqueKey(false));
            stringBuffer.append(':');
            MethodBinding[] methodBindingArray = ((ReferenceBinding)object).methods();
            if (methodBindingArray != null) {
                int n = methodBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    MethodBinding methodBinding2 = methodBindingArray[i];
                    if (methodBinding2 != methodBinding) continue;
                    stringBuffer.append(i);
                    break;
                }
            }
        } else {
            stringBuffer.append(binding.computeUniqueKey(false));
            stringBuffer.append(':');
        }
        stringBuffer.append(this.genericTypeSignature());
        int n = stringBuffer.length();
        object = new char[n];
        stringBuffer.getChars(0, n, (char[])object, 0);
        return object;
    }

    @Override
    public char[] constantPoolName() {
        if (this.firstBound != null) {
            return this.firstBound.constantPoolName();
        }
        return this.superclass.constantPoolName();
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        return new TypeVariableBinding(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String annotatedDebugName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(super.annotatedDebugName());
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                    stringBuffer.append(" extends ").append(this.superclass.annotatedDebugName());
                }
                if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    if (TypeBinding.notEquals(this.firstBound, this.superclass)) {
                        stringBuffer.append(" extends ");
                    }
                    int n = this.superInterfaces.length;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                            stringBuffer.append(" & ");
                        }
                        stringBuffer.append(this.superInterfaces[i].annotatedDebugName());
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String debugName() {
        if (this.hasTypeAnnotations()) {
            return super.annotatedDebugName();
        }
        return new String(this.sourceName);
    }

    @Override
    public TypeBinding erasure() {
        if (this.firstBound != null) {
            return this.firstBound.erasure();
        }
        return this.superclass;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.sourceName).append(':');
        int n3 = n2 = this.superInterfaces == null ? 0 : this.superInterfaces.length;
        if ((n2 == 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) && this.superclass != null) {
            stringBuffer.append(this.superclass.genericTypeSignature());
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(':').append(this.superInterfaces[n].genericTypeSignature());
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature != null) {
            return this.genericTypeSignature;
        }
        this.genericTypeSignature = CharOperation.concat('T', this.sourceName, ';');
        return this.genericTypeSignature;
    }

    TypeBound[] getTypeBounds(InferenceVariable inferenceVariable, InferenceSubstitution inferenceSubstitution) {
        int n = this.boundsCount();
        if (n == 0) {
            return NO_TYPE_BOUNDS;
        }
        TypeBound[] typeBoundArray = new TypeBound[n];
        typeBoundArray[0] = TypeBound.createBoundOrDependency(inferenceSubstitution, this.firstBound, inferenceVariable);
        int n2 = TypeBinding.equalsEquals(this.firstBound, this.superclass) ? -1 : 0;
        for (int i = 1; i < n; ++i) {
            typeBoundArray[i] = TypeBound.createBoundOrDependency(inferenceSubstitution, this.superInterfaces[i + n2], inferenceVariable);
        }
        return typeBoundArray;
    }

    boolean hasOnlyRawBounds() {
        if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass) && !this.superclass.isRawType()) {
            return false;
        }
        if (this.superInterfaces != null) {
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (this.superInterfaces[i].isRawType()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasTypeBit(int n) {
        if (this.typeBits == 0x8000000) {
            this.typeBits = 0;
            if (this.superclass != null && this.superclass.hasTypeBit(-134217729)) {
                this.typeBits |= this.superclass.typeBits & 0x13;
            }
            if (this.superInterfaces != null) {
                int n2 = this.superInterfaces.length;
                for (int i = 0; i < n2; ++i) {
                    if (!this.superInterfaces[i].hasTypeBit(-134217729)) continue;
                    this.typeBits |= this.superInterfaces[i].typeBits & 0x13;
                }
            }
        }
        return (this.typeBits & n) != 0;
    }

    public boolean isErasureBoundTo(TypeBinding typeBinding) {
        if (TypeBinding.equalsEquals(this.superclass.erasure(), typeBinding)) {
            return true;
        }
        int n = this.superInterfaces.length;
        for (int i = 0; i < n; ++i) {
            if (!TypeBinding.equalsEquals(this.superInterfaces[i].erasure(), typeBinding)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHierarchyConnected() {
        return (this.modifiers & 0x2000000) == 0;
    }

    public boolean isInterchangeableWith(TypeVariableBinding typeVariableBinding, Substitution substitution) {
        if (TypeBinding.equalsEquals(this, typeVariableBinding)) {
            return true;
        }
        int n = this.superInterfaces.length;
        if (n != typeVariableBinding.superInterfaces.length) {
            return false;
        }
        if (TypeBinding.notEquals(this.superclass, Scope.substitute(substitution, typeVariableBinding.superclass))) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superInterfaces[i]);
            for (int j = 0; j < n; ++j) {
                if (TypeBinding.equalsEquals(typeBinding, this.superInterfaces[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding) {
        if (this.isSubTypeOfRTL(typeBinding)) {
            return true;
        }
        if (this.firstBound != null && this.firstBound.isSubtypeOf(typeBinding)) {
            return true;
        }
        if (this.superclass != null && this.superclass.isSubtypeOf(typeBinding)) {
            return true;
        }
        if (this.superInterfaces != null) {
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (!this.superInterfaces[i].isSubtypeOf(typeBinding)) continue;
                return true;
            }
        }
        return typeBinding.id == 1;
    }

    @Override
    public boolean enterRecursiveFunction() {
        if (this.inRecursiveFunction) {
            return false;
        }
        this.inRecursiveFunction = true;
        return true;
    }

    @Override
    public void exitRecursiveFunction() {
        this.inRecursiveFunction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProperType(boolean bl) {
        if (this.inRecursiveFunction) {
            return true;
        }
        this.inRecursiveFunction = true;
        try {
            int n;
            if (this.superclass != null && !this.superclass.isProperType(bl)) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.superInterfaces != null) {
                int n2 = this.superInterfaces.length;
                for (n = 0; n < n2; ++n) {
                    if (this.superInterfaces[n].isProperType(bl)) continue;
                    boolean bl3 = false;
                    return bl3;
                }
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        if (this.inRecursiveFunction) {
            return this;
        }
        this.inRecursiveFunction = true;
        try {
            boolean bl = false;
            ReferenceBinding referenceBinding = this.superclass;
            if (referenceBinding != null) {
                referenceBinding = (ReferenceBinding)referenceBinding.substituteInferenceVariable(inferenceVariable, typeBinding);
                bl |= TypeBinding.notEquals(referenceBinding, this.superclass);
            }
            ReferenceBinding[] referenceBindingArray = null;
            if (this.superInterfaces != null) {
                int n = this.superInterfaces.length;
                if (bl) {
                    referenceBindingArray = new ReferenceBinding[n];
                    System.arraycopy(this.superInterfaces, 0, referenceBindingArray, 0, n);
                }
                for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding2 = this.superInterfaces[i];
                    if (referenceBinding2 == null || !TypeBinding.notEquals(referenceBinding2 = (ReferenceBinding)referenceBinding2.substituteInferenceVariable(inferenceVariable, typeBinding), this.superInterfaces[i])) continue;
                    if (referenceBindingArray == null) {
                        referenceBindingArray = new ReferenceBinding[n];
                        System.arraycopy(this.superInterfaces, 0, referenceBindingArray, 0, n);
                    }
                    referenceBindingArray[i] = referenceBinding2;
                    bl = true;
                }
            }
            if (bl) {
                TypeVariableBinding typeVariableBinding = new TypeVariableBinding(this.sourceName, this.declaringElement, this.rank, this.environment);
                typeVariableBinding.superclass = referenceBinding;
                typeVariableBinding.superInterfaces = referenceBindingArray;
                typeVariableBinding.tagBits = this.tagBits;
                TypeVariableBinding typeVariableBinding2 = typeVariableBinding;
                return typeVariableBinding2;
            }
            TypeVariableBinding typeVariableBinding = this;
            return typeVariableBinding;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    @Override
    public int kind() {
        return 4100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        if (this.inRecursiveFunction) {
            return false;
        }
        this.inRecursiveFunction = true;
        try {
            int n2;
            if (super.mentionsAny(typeBindingArray, n)) {
                boolean bl = true;
                return bl;
            }
            if (this.superclass != null && this.superclass.mentionsAny(typeBindingArray, n)) {
                boolean bl = true;
                return bl;
            }
            if (this.superInterfaces != null) {
                for (n2 = 0; n2 < this.superInterfaces.length; ++n2) {
                    if (!this.superInterfaces[n2].mentionsAny(typeBindingArray, n)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            n2 = 0;
            return n2 != 0;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        if (this.inRecursiveFunction) {
            return;
        }
        this.inRecursiveFunction = true;
        try {
            if (this.superclass != null) {
                this.superclass.collectInferenceVariables(set);
            }
            if (this.superInterfaces != null) {
                for (int i = 0; i < this.superInterfaces.length; ++i) {
                    this.superInterfaces[i].collectInferenceVariables(set);
                }
            }
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    public TypeBinding[] otherUpperBounds() {
        if (this.firstBound == null) {
            return Binding.NO_TYPES;
        }
        if (TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
            return this.superInterfaces;
        }
        int n = this.superInterfaces.length - 1;
        if (n > 0) {
            TypeBinding[] typeBindingArray = new TypeBinding[n];
            System.arraycopy(this.superInterfaces, 1, typeBindingArray, 0, n);
            return typeBindingArray;
        }
        return Binding.NO_TYPES;
    }

    @Override
    public char[] readableName() {
        return this.sourceName;
    }

    ReferenceBinding resolve() {
        int n;
        Object object;
        if ((this.modifiers & 0x2000000) == 0) {
            return this;
        }
        long l = this.tagBits & 0x180000000000000L;
        ReferenceBinding referenceBinding = this.superclass;
        ReferenceBinding referenceBinding2 = null;
        if (this.superclass != null) {
            object = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
            this.tagBits |= object.tagBits & 0x800L;
            long l2 = object.tagBits & 0x180000000000000L;
            if (l2 != 0L && l == 0L) {
                this.tagBits |= l2 | 0x100000L;
            }
            this.setSuperClass((ReferenceBinding)object);
        }
        if ((n = ((ReferenceBinding[])(object = this.superInterfaces)).length) != 0) {
            referenceBinding2 = object[0];
            int n2 = n;
            while (--n2 >= 0) {
                ReferenceBinding referenceBinding3 = (ReferenceBinding)BinaryTypeBinding.resolveType(object[n2], this.environment, true);
                this.tagBits |= referenceBinding3.tagBits & 0x800L;
                long l3 = referenceBinding3.tagBits & 0x180000000000000L;
                if (l3 != 0L && l == 0L) {
                    this.tagBits |= l3 | 0x100000L;
                }
                object[n2] = referenceBinding3;
            }
        }
        if (this.firstBound != null) {
            if (TypeBinding.equalsEquals(this.firstBound, referenceBinding)) {
                this.setFirstBound(this.superclass);
            } else if (TypeBinding.equalsEquals(this.firstBound, referenceBinding2)) {
                this.setFirstBound(object[0]);
            }
        }
        this.modifiers &= 0xFDFFFFFF;
        return this;
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.environment.getUnannotatedType(this);
        super.setTypeAnnotations(annotationBindingArray, bl);
    }

    @Override
    public char[] shortReadableName() {
        return this.readableName();
    }

    @Override
    public ReferenceBinding superclass() {
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public String toString() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append('<').append(this.sourceName);
        if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
            stringBuffer.append(" extends ").append(this.superclass.debugName());
        }
        if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
            if (TypeBinding.notEquals(this.firstBound, this.superclass)) {
                stringBuffer.append(" extends ");
            }
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                    stringBuffer.append(" & ");
                }
                stringBuffer.append(this.superInterfaces[i].debugName());
            }
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        this.appendNullAnnotation(stringBuffer, compilerOptions);
        stringBuffer.append(this.sourceName());
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                    stringBuffer.append(" extends ").append(this.superclass.nullAnnotatedReadableName(compilerOptions, bl));
                }
                if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    if (TypeBinding.notEquals(this.firstBound, this.superclass)) {
                        stringBuffer.append(" extends ");
                    }
                    int n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        if (n > 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                            stringBuffer.append(" & ");
                        }
                        stringBuffer.append(this.superInterfaces[n].nullAnnotatedReadableName(compilerOptions, bl));
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public TypeBinding unannotated() {
        return this.hasTypeAnnotations() ? this.environment.getUnannotatedType(this) : this;
    }

    public TypeBinding upperBound() {
        if (this.firstBound != null) {
            return this.firstBound;
        }
        return this.superclass;
    }

    public void evaluateNullAnnotations(Scope scope, TypeParameter typeParameter) {
        ReferenceBinding[] referenceBindingArray;
        int n;
        Object object;
        long l;
        long l2 = NullAnnotationMatching.validNullTagBits(this.tagBits);
        if (this.firstBound != null && this.firstBound.isValidBinding() && (l = NullAnnotationMatching.validNullTagBits(this.firstBound.tagBits)) != 0L) {
            if (l2 == 0L) {
                l2 |= l;
            } else if (l != l2) {
                TypeReference typeReference = this.findBound(this.firstBound, typeParameter);
                object = typeReference.findAnnotation(l);
                scope.problemReporter().contradictoryNullAnnotationsOnBounds((Annotation)object, l2);
                this.tagBits &= 0xFE7FFFFFFFFFFFFFL;
            }
        }
        if ((n = (referenceBindingArray = this.superInterfaces).length) != 0) {
            int n2 = n;
            while (--n2 >= 0) {
                object = referenceBindingArray[n2];
                long l3 = NullAnnotationMatching.validNullTagBits(((ReferenceBinding)object).tagBits);
                if (l3 != 0L) {
                    if (l2 == 0L) {
                        l2 |= l3;
                    } else if (l3 != l2) {
                        TypeReference typeReference = this.findBound(this.firstBound, typeParameter);
                        Annotation annotation = typeReference.findAnnotation(l3);
                        scope.problemReporter().contradictoryNullAnnotationsOnBounds(annotation, l2);
                        this.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                    }
                }
                referenceBindingArray[n2] = object;
            }
        }
        if (l2 != 0L) {
            this.tagBits |= l2 | 0x100000L;
        }
    }

    private TypeReference findBound(TypeBinding typeBinding, TypeParameter typeParameter) {
        if (typeParameter.type != null && TypeBinding.equalsEquals(typeParameter.type.resolvedType, typeBinding)) {
            return typeParameter.type;
        }
        TypeReference[] typeReferenceArray = typeParameter.bounds;
        if (typeReferenceArray != null) {
            for (int i = 0; i < typeReferenceArray.length; ++i) {
                if (!TypeBinding.equalsEquals(typeReferenceArray[i].resolvedType, typeBinding)) continue;
                return typeReferenceArray[i];
            }
        }
        return null;
    }

    public TypeBinding setFirstBound(TypeBinding typeBinding) {
        this.firstBound = typeBinding;
        if ((this.tagBits & 0x800000L) != 0L) {
            int n;
            TypeBinding[] typeBindingArray = this.environment.getAnnotatedTypes(this);
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBindingArray[i];
                typeVariableBinding.firstBound = typeBinding;
            }
        }
        if (typeBinding != null && typeBinding.hasNullTypeAnnotations()) {
            this.tagBits |= 0x100000L;
        }
        return typeBinding;
    }

    public ReferenceBinding setSuperClass(ReferenceBinding referenceBinding) {
        this.superclass = referenceBinding;
        if ((this.tagBits & 0x800000L) != 0L) {
            int n;
            TypeBinding[] typeBindingArray = this.environment.getAnnotatedTypes(this);
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBindingArray[i];
                typeVariableBinding.superclass = referenceBinding;
            }
        }
        return referenceBinding;
    }

    public ReferenceBinding[] setSuperInterfaces(ReferenceBinding[] referenceBindingArray) {
        this.superInterfaces = referenceBindingArray;
        if ((this.tagBits & 0x800000L) != 0L) {
            int n;
            TypeBinding[] typeBindingArray = this.environment.getAnnotatedTypes(this);
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBindingArray[i];
                typeVariableBinding.superInterfaces = referenceBindingArray;
            }
        }
        return referenceBindingArray;
    }
}

