/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.NameImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class TypeElementImpl
extends ElementImpl
implements TypeElement {
    private final ElementKind _kindHint;

    TypeElementImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, ReferenceBinding referenceBinding, ElementKind elementKind) {
        super(baseProcessingEnvImpl, referenceBinding);
        this._kindHint = elementKind;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
        return elementVisitor.visitType(this, p);
    }

    @Override
    protected AnnotationBinding[] getAnnotationBindings() {
        return ((ReferenceBinding)this._binding).getAnnotations();
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        ElementImpl elementImpl;
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        ArrayList<ExecutableElementImpl> arrayList = new ArrayList<ExecutableElementImpl>(referenceBinding.fieldCount() + referenceBinding.methods().length);
        for (MethodBinding binding : referenceBinding.methods()) {
            elementImpl = new ExecutableElementImpl(this._env, binding);
            arrayList.add((ExecutableElementImpl)elementImpl);
        }
        for (Binding binding : referenceBinding.fields()) {
            if (((FieldBinding)binding).isSynthetic()) continue;
            elementImpl = new VariableElementImpl(this._env, (VariableBinding)binding);
            arrayList.add((ExecutableElementImpl)elementImpl);
        }
        for (Binding binding : referenceBinding.memberTypes()) {
            elementImpl = new TypeElementImpl(this._env, (ReferenceBinding)binding, null);
            arrayList.add((ExecutableElementImpl)elementImpl);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Element getEnclosingElement() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
        if (null == referenceBinding2) {
            return this._env.getFactory().newPackageElement(referenceBinding.fPackage);
        }
        return this._env.getFactory().newElement(referenceBinding.enclosingType());
    }

    @Override
    public String getFileName() {
        char[] cArray = ((ReferenceBinding)this._binding).getFileName();
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }

    @Override
    public List<? extends TypeMirror> getInterfaces() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        if (null == referenceBinding.superInterfaces() || referenceBinding.superInterfaces().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(referenceBinding.superInterfaces().length);
        for (ReferenceBinding referenceBinding2 : referenceBinding.superInterfaces()) {
            TypeMirror typeMirror = this._env.getFactory().newTypeMirror(referenceBinding2);
            if (typeMirror.getKind() == TypeKind.ERROR) {
                if (this._env.getSourceVersion().compareTo(SourceVersion.RELEASE_6) <= 0) continue;
                arrayList.add(typeMirror);
                continue;
            }
            arrayList.add(typeMirror);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public ElementKind getKind() {
        if (null != this._kindHint) {
            return this._kindHint;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        if (referenceBinding.isEnum()) {
            return ElementKind.ENUM;
        }
        if (referenceBinding.isAnnotationType()) {
            return ElementKind.ANNOTATION_TYPE;
        }
        if (referenceBinding.isInterface()) {
            return ElementKind.INTERFACE;
        }
        if (referenceBinding.isClass()) {
            return ElementKind.CLASS;
        }
        throw new IllegalArgumentException("TypeElement " + new String(referenceBinding.shortReadableName()) + " has unexpected attributes " + referenceBinding.modifiers);
    }

    @Override
    public Set<Modifier> getModifiers() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        int n = referenceBinding.modifiers;
        if (referenceBinding.isInterface() && referenceBinding.isNestedType()) {
            n |= 8;
        }
        return Factory.getModifiers(n, this.getKind(), referenceBinding.isBinaryBinding());
    }

    @Override
    public NestingKind getNestingKind() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        if (referenceBinding.isAnonymousType()) {
            return NestingKind.ANONYMOUS;
        }
        if (referenceBinding.isLocalType()) {
            return NestingKind.LOCAL;
        }
        if (referenceBinding.isMemberType()) {
            return NestingKind.MEMBER;
        }
        return NestingKind.TOP_LEVEL;
    }

    @Override
    PackageElement getPackage() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        return this._env.getFactory().newPackageElement(referenceBinding.fPackage);
    }

    @Override
    public Name getQualifiedName() {
        char[] cArray;
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        if (referenceBinding.isMemberType()) {
            cArray = CharOperation.concatWith(referenceBinding.enclosingType().compoundName, referenceBinding.sourceName, '.');
            CharOperation.replace(cArray, '$', '.');
        } else {
            cArray = CharOperation.concatWith(referenceBinding.compoundName, '.');
        }
        return new NameImpl(cArray);
    }

    @Override
    public Name getSimpleName() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        return new NameImpl(referenceBinding.sourceName());
    }

    @Override
    public TypeMirror getSuperclass() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        ReferenceBinding referenceBinding2 = referenceBinding.superclass();
        if (null == referenceBinding2 || referenceBinding.isInterface()) {
            return this._env.getFactory().getNoType(TypeKind.NONE);
        }
        return this._env.getFactory().newTypeMirror(referenceBinding2);
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        if (typeVariableBindingArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeParameterElement> arrayList = new ArrayList<TypeParameterElement>(typeVariableBindingArray.length);
        for (TypeVariableBinding typeVariableBinding : typeVariableBindingArray) {
            arrayList.add(this._env.getFactory().newTypeParameterElement(typeVariableBinding, this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean hides(Element element) {
        if (!(element instanceof TypeElementImpl)) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)((TypeElementImpl)element)._binding;
        if (referenceBinding.isPrivate()) {
            return false;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)this._binding;
        if (TypeBinding.equalsEquals(referenceBinding, referenceBinding2)) {
            return false;
        }
        if (!referenceBinding.isMemberType() || !referenceBinding2.isMemberType()) {
            return false;
        }
        if (!CharOperation.equals(referenceBinding.sourceName, referenceBinding2.sourceName)) {
            return false;
        }
        return null != referenceBinding2.enclosingType().findSuperTypeOriginatingFrom(referenceBinding.enclosingType());
    }

    @Override
    public String toString() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        char[] cArray = CharOperation.concatWith(referenceBinding.compoundName, '.');
        if (referenceBinding.isNestedType()) {
            CharOperation.replace(cArray, '$', '.');
            return new String(cArray);
        }
        return new String(cArray);
    }
}

