/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleText;
import javax.swing.SwingUtilities;
import org.GNOME.Accessibility.AccessUtil;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.AccessibleFactory;
import org.GNOME.Accessibility.AccessibleHelper;
import org.GNOME.Accessibility.Application;
import org.GNOME.Accessibility.ApplicationAccessible;
import org.GNOME.Accessibility.DeviceEvent;
import org.GNOME.Accessibility.Event;
import org.GNOME.Accessibility.EventDetails;
import org.GNOME.Accessibility.EventDetailsHelper;
import org.GNOME.Accessibility.KeyEventAdapter;
import org.GNOME.Accessibility.StateTypeAdapter;
import org.omg.CORBA.Any;
import org.omg.PortableServer.POA;

public class JavaBridge {
    static PropertyChangeListener globalPropertyChangeListener = null;
    static FocusListener focusListener = null;
    static AccessibleFactory accessibleObjectFactory = null;
    static Hashtable accessibleObjectTable = new Hashtable();
    static EventQueue accessQueue = null;
    static AccessibleContext oldFocusSource = null;
    static String oldFocusText = "";
    static int oldFocusSelectStart = 0;
    static int oldFocusSelectEnd = 0;
    static AccessibleContext oldFocusCtx = null;
    static AccessibleContext savedFocusSource = null;
    static Object oldEventSource = null;
    static String oldEventName = null;
    static int oldDetail1 = -1;
    static boolean debugFlag = false;
    static Application the_app;
    javax.accessibility.Accessible appAccessible;
    private static HashMap lastTextSizes;
    private static final int max_recurse_depth = 10;
    private static final int max_children_block = 200;

    private boolean loadJni() {
        block6: {
            try {
                String string;
                File file;
                String string2 = System.getProperty("java.home");
                String string3 = System.getProperty("sun.arch.data.model");
                String string4 = System.getProperty("os.arch");
                String string5 = System.getProperty("file.separator");
                String string6 = string2 + "/lib/ext/libjava-access-bridge-jni.so";
                if ("64".equals(string3) && (file = new File((string = string2 + "/lib/ext/" + string4 + "/libjava-access-bridge-jni.so").replace('/', string5.charAt(0)))).exists()) {
                    string6 = string;
                }
                if (!string6.equals("")) {
                    string6 = string6.replace('/', string5.charAt(0));
                    System.load(string6);
                    if (debugFlag) {
                        System.err.println(string6 + " loaded");
                    }
                    break block6;
                }
                if (debugFlag) {
                    System.err.println("Error: jni library not found");
                }
                return false;
            }
            catch (Throwable throwable) {
                System.err.println(throwable + " caught.");
                throwable.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        new JavaBridge();
    }

    public JavaBridge() {
        String string;
        this.setDebug();
        if (debugFlag) {
            System.err.println("Java Accessibility Bridge for GNOME loaded.\n");
        }
        if ((string = System.getProperty("java.version")).compareTo("1.4.0") < 0) {
            System.err.println("WARNING: Java Accessibility Bridge for GNOME requires JVM version 1.4.0 or greater.");
        } else {
            this.registerApplication();
        }
    }

    public JavaBridge(String[] stringArray) {
        System.err.println(stringArray);
        new JavaBridge();
    }

    public static POA getRootPOA() {
        return AccessUtil.getRootPOA();
    }

    public static AccessibleFactory getAccessibleObjectFactory() {
        return accessibleObjectFactory;
    }

    public static Hashtable getAccessibleObjectTable() {
        return accessibleObjectTable;
    }

    public static PropertyChangeListener getGlobalPropertyChangeListener() {
        return globalPropertyChangeListener;
    }

    public static FocusListener getFocusListener() {
        return focusListener;
    }

    public static AccessibleContext getFocusContext() {
        return oldFocusSource;
    }

    public static void dispatchWindowEvent(Object object, String string) {
        try {
            if (object instanceof javax.accessibility.Accessible) {
                JavaBridge.dispatchEvent(((javax.accessibility.Accessible)object).getAccessibleContext(), string, 0, 0);
            }
        }
        catch (Exception exception) {
            System.err.println(exception + " caught.");
            exception.printStackTrace();
        }
    }

    public static void dispatchEvent(Object object, String string, int n, int n2, Any any) {
        block7: {
            try {
                Object object2;
                AccessibleContext accessibleContext = null;
                if (object instanceof AccessibleContext) {
                    accessibleContext = (AccessibleContext)object;
                } else if (object instanceof javax.accessibility.Accessible) {
                    accessibleContext = ((javax.accessibility.Accessible)object).getAccessibleContext();
                } else {
                    return;
                }
                Accessible accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                if (!any.type().equivalent(EventDetailsHelper.type())) {
                    object2 = new EventDetails();
                    object2.host_application = the_app;
                    object2.source_role = accessible.getRole();
                    object2.source_name = accessible.name();
                    object2.any_data = AccessUtil.getORB().create_any();
                    EventDetailsHelper.insert(any, object2);
                }
                object2 = new Event(string, accessible, n, n2, any);
                accessible.ref();
                AccessUtil.getRegistryObject().notifyEvent((Event)object2);
            }
            catch (Exception exception) {
                if (!debugFlag) break block7;
                System.out.println("Error dispatching event " + string + ":" + object + "; " + exception);
            }
        }
    }

    public static void dispatchEvent(Object object, String string, int n, int n2) {
        Any any = AccessUtil.getORB().create_any();
        JavaBridge.dispatchEvent(object, string, n, n2, any);
    }

    public static boolean dispatchDeviceEvent(DeviceEvent deviceEvent) {
        try {
            if (deviceEvent == null) {
                return false;
            }
            return AccessUtil.getRegistryObject().getDeviceEventController().notifyListenersSync(deviceEvent);
        }
        catch (Exception exception) {
            if (debugFlag) {
                System.out.println("Exception in dispatchDeviceEvent " + exception);
            }
            return false;
        }
    }

    public static void dispatchFocusEvent(Object object) {
        block22: {
            if (object == null) {
                oldFocusSource = null;
                return;
            }
            try {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                AccessibleContext accessibleContext;
                if (object instanceof AccessibleContext) {
                    accessibleContext = (AccessibleContext)object;
                } else if (object instanceof javax.accessibility.Accessible) {
                    accessibleContext = ((javax.accessibility.Accessible)object).getAccessibleContext();
                } else {
                    return;
                }
                if (accessibleContext == oldFocusSource) {
                    return;
                }
                if (oldFocusSource != null) {
                    object5 = oldFocusSource.getAccessibleRole();
                    if (object5 == AccessibleRole.MENU || object5 == AccessibleRole.MENU_ITEM) {
                        object4 = "javax.swing.JRootPane$AccessibleJRootPane";
                        object3 = accessibleContext.getClass().getName();
                        if (((String)object3).compareTo((String)object4) == 0) {
                            oldFocusCtx = accessibleContext;
                            return;
                        }
                    }
                    savedFocusSource = accessibleContext;
                } else if (oldFocusCtx == accessibleContext) {
                    accessibleContext = savedFocusSource;
                } else {
                    savedFocusSource = accessibleContext;
                }
                oldFocusSource = accessibleContext;
                if (accessibleContext != null && accessibleContext.getAccessibleText() != null) {
                    object5 = accessibleContext.getAccessibleText();
                    oldFocusText = JavaBridge.getTextRange((AccessibleText)object5, 0, object5.getCharCount());
                    oldFocusSelectStart = object5.getSelectionStart();
                    oldFocusSelectEnd = object5.getSelectionEnd();
                } else {
                    oldFocusText = "";
                }
                object5 = null;
                object5 = accessibleContext.getAccessibleRole();
                if (object5 == AccessibleRole.PAGE_TAB_LIST) {
                    object4 = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                    object3 = accessibleContext.getAccessibleSelection();
                    if (object3 != null && object3.getAccessibleSelectionCount() > 0) {
                        object2 = object3.getAccessibleSelection(0);
                        if (object2 instanceof AccessibleContext) {
                            accessibleContext = (AccessibleContext)object2;
                        } else if (object2 instanceof javax.accessibility.Accessible) {
                            accessibleContext = ((javax.accessibility.Accessible)object2).getAccessibleContext();
                        } else {
                            return;
                        }
                    }
                }
                object4 = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                object3 = AccessUtil.getORB().create_any();
                object2 = new EventDetails();
                ((EventDetails)object2).host_application = the_app;
                ((EventDetails)object2).source_role = object4.getRole();
                ((EventDetails)object2).source_name = object4.name();
                ((EventDetails)object2).any_data = AccessUtil.getORB().create_any();
                EventDetailsHelper.insert((Any)object3, (EventDetails)object2);
                Event event = new Event("focus:", (Accessible)object4, 0, 0, (Any)object3);
                object4.ref();
                AccessUtil.getRegistryObject().notifyEvent(event);
            }
            catch (Exception exception) {
                if (!debugFlag) break block22;
                System.out.println("Error dispatching focus event :" + object + ":" + exception);
            }
        }
    }

    public static void dispatchCaretProperty(PropertyChangeEvent propertyChangeEvent) {
        int n = Integer.parseInt(propertyChangeEvent.getOldValue().toString());
        int n2 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
        AccessibleText accessibleText = null;
        if (propertyChangeEvent.getSource() instanceof AccessibleContext && propertyChangeEvent.getSource() == oldFocusSource) {
            accessibleText = ((AccessibleContext)propertyChangeEvent.getSource()).getAccessibleText();
            int n3 = accessibleText.getSelectionStart();
            int n4 = accessibleText.getSelectionEnd();
            if (n3 != oldFocusSelectStart || n4 != oldFocusSelectEnd) {
                Any any = AccessUtil.getORB().create_any();
                int n5 = 0;
                int n6 = 0;
                if (n3 != oldFocusSelectStart) {
                    n5 = n3;
                    n6 = oldFocusSelectEnd != oldFocusSelectStart ? oldFocusSelectStart : n4;
                }
                if (n4 != oldFocusSelectEnd) {
                    n6 = n4;
                    n5 = oldFocusSelectStart != oldFocusSelectEnd ? oldFocusSelectEnd : n3;
                }
                oldFocusSelectStart = n3;
                oldFocusSelectEnd = n4;
                try {
                    if (n5 != n6) {
                        any.insert_string(oldFocusText.substring(Math.min(n5, n6), Math.max(n5, n6)));
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:text-selection-changed", n3, n4, any);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:text-caret-moved", n2, n);
    }

    public static void setInitialTextSize(AccessibleContext accessibleContext, int n) {
        lastTextSizes.put(accessibleContext, new Integer(n));
    }

    private static String getTextRange(AccessibleText accessibleText, int n, int n2) {
        int n3;
        String string = "";
        String string2 = accessibleText.getAtIndex(2, n);
        for (n3 = n; n3 < n2 && string2.equals(accessibleText.getAtIndex(2, n3)); ++n3) {
            String string3 = accessibleText.getAtIndex(1, n3);
            if (string3 == null) continue;
            string = string + string3;
        }
        while (n3 < n2) {
            if ((n3 += (string2 = accessibleText.getAtIndex(2, n3)).length()) > n2) {
                string = string + string2.substring(0, string2.length() - (n3 - n2));
                continue;
            }
            string = string + string2;
        }
        return string;
    }

    public static void dispatchTextProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            int n = 0;
            int n2 = -1;
            String string = "object:text-changed";
            Any any = AccessUtil.getORB().create_any();
            if (object instanceof Integer) {
                AccessibleContext accessibleContext = null;
                Object object3 = propertyChangeEvent.getSource();
                if (object3 instanceof AccessibleContext) {
                    accessibleContext = (AccessibleContext)object3;
                } else if (object3 instanceof javax.accessibility.Accessible) {
                    accessibleContext = ((javax.accessibility.Accessible)object3).getAccessibleContext();
                }
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                AccessibleEditableText accessibleEditableText = accessibleContext.getAccessibleEditableText();
                int n3 = accessibleText.getCharCount();
                Integer n4 = lastTextSizes.put(accessibleContext, new Integer(n3));
                int n5 = n4 == null ? 0 : n4;
                if (n3 > n5) {
                    string = string + ":insert";
                    n2 = n3 - n5;
                    if (accessibleEditableText != null) {
                        any.insert_string(accessibleEditableText.getTextRange((Integer)object, (Integer)object + n2));
                        if (accessibleContext == oldFocusSource) {
                            oldFocusText = accessibleEditableText.getTextRange(0, n3);
                        }
                    } else if (accessibleContext != null && accessibleContext == oldFocusSource) {
                        object = new Integer((Integer)object - n2);
                        oldFocusText = JavaBridge.getTextRange(accessibleText, 0, n3);
                        any.insert_string(oldFocusText.substring((Integer)object, (Integer)object + n2));
                    }
                } else if (n3 < n5) {
                    string = string + ":delete";
                    n2 = n5 - n3;
                    if (accessibleContext != null && accessibleContext == oldFocusSource && oldFocusText != "") {
                        int n6 = (Integer)object;
                        int n7 = n6 + n2;
                        if (oldFocusText.length() < n7) {
                            System.err.println("WARNING: subend " + n7 + " > len : " + oldFocusText + " - substart = " + n6);
                        }
                        any.insert_string(oldFocusText.substring((Integer)object, (Integer)object + n2));
                    }
                    oldFocusText = JavaBridge.getTextRange(accessibleText, 0, n3);
                } else {
                    string = string + ":replace";
                    if (accessibleEditableText != null) {
                        String string2 = accessibleEditableText.getTextRange(0, n3);
                        any.insert_string(string2);
                        if (accessibleContext == oldFocusSource) {
                            oldFocusText = string2;
                        }
                    } else if (accessibleContext == oldFocusSource) {
                        oldFocusText = JavaBridge.getTextRange(accessibleText, 0, n3);
                    }
                }
                n = (Integer)object;
            } else if (object instanceof Integer[] || object2 instanceof Integer[]) {
                Integer[] integerArray = (Integer[])object;
                Integer[] integerArray2 = (Integer[])object2;
                if (integerArray != null && integerArray.length != 2 || integerArray2 != null && integerArray2.length != 2) {
                    System.err.println("TEXT_CHANGED EVENT: Unexpected length of new/old values");
                }
                if (object != null && object2 == null) {
                    string = string + ":insert";
                    n = integerArray[0];
                    n2 = integerArray[1];
                } else if (object2 != null && object == null) {
                    string = string + ":delete";
                    n = integerArray2[0];
                    n2 = integerArray2[1];
                } else if (object != null && object2 != null) {
                    n = integerArray2[0];
                    n2 = integerArray2[1];
                    JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string + ":delete", n, n2, any);
                    string = string + ":insert";
                    n = integerArray[0];
                    n2 = integerArray[1];
                }
            } else if (object instanceof Object[] || object2 instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                if (objectArray != null && objectArray.length != 3 || objectArray2 != null && objectArray2.length != 3) {
                    System.err.println("TEXT_CHANGED EVENT: Unexpected length of new/old values");
                }
                Integer[] integerArray = new Integer[2];
                Integer[] integerArray3 = new Integer[2];
                String string3 = null;
                if (object != null) {
                    integerArray[0] = (Integer)objectArray[0];
                    integerArray[1] = (Integer)objectArray[1];
                }
                if (object2 != null) {
                    integerArray3[0] = (Integer)objectArray2[0];
                    integerArray3[1] = (Integer)objectArray2[1];
                }
                if (object != null && object2 == null) {
                    string = string + ":insert";
                    n = integerArray[0];
                    n2 = integerArray[1];
                    string3 = (String)objectArray[2];
                } else if (object2 != null && object == null) {
                    string = string + ":delete";
                    n = integerArray3[0];
                    n2 = integerArray3[1] - integerArray3[0];
                    string3 = (String)objectArray2[2];
                } else if (object != null && object2 != null) {
                    n = integerArray3[0];
                    n2 = integerArray3[1];
                    string3 = (String)objectArray2[2];
                    Any any2 = AccessUtil.getORB().create_any();
                    if (string3 != null) {
                        any2.insert_string(string3);
                    }
                    JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string + ":delete", n, n2, any2);
                    string = string + ":insert";
                    n = integerArray[0];
                    n2 = integerArray[1];
                    string3 = (String)objectArray[2];
                }
                if (string3 != null) {
                    any.insert_string(string3);
                }
            } else if (object != null || object2 != null) {
                System.err.println("UNHANDLED TEXT_CHANGED EVENT NewValue CLASS: " + object.getClass().getName());
            }
            JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string, n, n2, any);
        }
        catch (Exception exception) {
            System.out.println("caught " + exception);
            exception.printStackTrace();
        }
    }

    public static void dispatchChildProperty(PropertyChangeEvent propertyChangeEvent) {
        AccessibleRole accessibleRole;
        boolean bl = false;
        String string = "object:children-changed";
        if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getOldValue() == null) {
            string = string + ":add";
            bl = true;
        } else if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() == null) {
            string = string + ":remove";
            bl = false;
        } else {
            bl = false;
        }
        if (bl && propertyChangeEvent.getSource() instanceof AccessibleContext && (accessibleRole = ((AccessibleContext)propertyChangeEvent.getSource()).getAccessibleRole()) != null && (accessibleRole == AccessibleRole.MENU_BAR || accessibleRole == AccessibleRole.POPUP_MENU || accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM)) {
            JavaBridge.traverseMenus((AccessibleContext)propertyChangeEvent.getSource());
        }
        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string, 0, 0);
    }

    public static void dispatchStateProperty(PropertyChangeEvent propertyChangeEvent) {
        int n;
        StateTypeAdapter stateTypeAdapter;
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        Object object3 = propertyChangeEvent.getSource();
        if (object2 != null) {
            stateTypeAdapter = new StateTypeAdapter((AccessibleState)object2);
            n = 1;
        } else {
            stateTypeAdapter = new StateTypeAdapter((AccessibleState)object);
            n = 0;
        }
        if (stateTypeAdapter.value() == 5) {
            stateTypeAdapter = new StateTypeAdapter(AccessibleState.EXPANDED);
            n = 0;
        }
        String string = "object:state-changed:" + stateTypeAdapter.getName();
        if (object3 == oldEventSource && string.compareTo(oldEventName) == 0 && n == oldDetail1) {
            return;
        }
        oldEventSource = object3;
        oldEventName = string;
        oldDetail1 = n;
        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string, n, 0);
    }

    private static void startAttachListener(Accessible accessible) {
        SwingUtilities.invokeLater(new AttachListenerRunnable(accessible));
    }

    private static void attachListenerRecurse(Accessible accessible) {
        if (accessible == null) {
            return;
        }
        int n = accessible.childCount();
        if (n < 200) {
            for (int i = 0; i < n; ++i) {
                JavaBridge.attachListenerRecurse(accessible.getChildAtIndex(i));
            }
        } else {
            return;
        }
    }

    public static boolean traverseMenus(AccessibleContext accessibleContext) {
        return JavaBridge.traverseMenus(accessibleContext, 0);
    }

    public static boolean traverseMenus(AccessibleContext accessibleContext, int n) {
        AccessibleRole accessibleRole;
        boolean bl = false;
        if (accessibleContext != null && n < 10 && (accessibleRole = accessibleContext.getAccessibleRole()) != null) {
            if (accessibleRole == AccessibleRole.MENU_BAR || accessibleRole == AccessibleRole.POPUP_MENU || accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM) {
                Accessible accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                JavaBridge.startAttachListener(accessible);
                bl = true;
            } else {
                for (int i = 0; i < accessibleContext.getAccessibleChildrenCount(); ++i) {
                    javax.accessibility.Accessible accessible = accessibleContext.getAccessibleChild(i);
                    if (accessible == null) continue;
                    JavaBridge.getAccessibleObjectFactory().getAccessible(accessible.getAccessibleContext());
                    bl = JavaBridge.traverseMenus(accessible.getAccessibleContext(), n + 1);
                    if (bl) break;
                }
            }
        }
        return bl;
    }

    public boolean registerApplication() {
        try {
            Application application;
            Process process = Runtime.getRuntime().exec("gconftool-2 -g /desktop/gnome/interface/accessibility");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            if (string == null || !string.equals("true")) {
                return false;
            }
            if (!this.loadJni()) {
                return false;
            }
            if (AccessUtil.getRegistryObject() == null) {
                return false;
            }
            if (debugFlag) {
                System.err.println("Registering Application.");
            }
            this.appAccessible = new ApplicationAccessible();
            the_app = application = JavaBridge.getAccessibleObjectFactory().getApplication(this.appAccessible.getAccessibleContext());
            if (debugFlag) {
                System.err.println(application);
            }
            AccessUtil.getRegistryObject().registerApplication(application);
            if (debugFlag) {
                System.err.println(application.name() + ":" + application.id());
                System.err.println("Just registered Application");
            }
            return true;
        }
        catch (Exception exception) {
            if (debugFlag) {
                System.out.println("Error registering application, exception is: " + exception);
            }
            return false;
        }
    }

    public static EventQueue getEventQueue() {
        if (accessQueue == null) {
            accessQueue = new AccessQueue();
        }
        return accessQueue;
    }

    public static void exit() {
    }

    private void setDebug() {
        try {
            String string;
            Process process = Runtime.getRuntime().exec("env");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return;
            }
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("GNOME_ACCESSIBILITY") < 0) continue;
                debugFlag = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        accessibleObjectFactory = new AccessibleFactory();
        globalPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string == "AccessibleCaret") {
                    JavaBridge.dispatchCaretProperty(propertyChangeEvent);
                } else if (string == "AccessibleText") {
                    JavaBridge.dispatchTextProperty(propertyChangeEvent);
                } else if (string == "AccessibleChild") {
                    JavaBridge.dispatchChildProperty(propertyChangeEvent);
                } else if (string == "AccessibleActiveDescendant") {
                    Object object = propertyChangeEvent.getSource();
                    Object object2 = propertyChangeEvent.getNewValue();
                    AccessibleContext accessibleContext = null;
                    int n = -1;
                    Any any = AccessUtil.getORB().create_any();
                    if (object2 != null) {
                        if (object2 instanceof AccessibleContext) {
                            accessibleContext = (AccessibleContext)object2;
                        } else if (object2 instanceof javax.accessibility.Accessible) {
                            accessibleContext = ((javax.accessibility.Accessible)object2).getAccessibleContext();
                        }
                    }
                    if (accessibleContext != null) {
                        Accessible accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                        EventDetails eventDetails = new EventDetails();
                        eventDetails.host_application = the_app;
                        eventDetails.source_role = accessible.getRole();
                        eventDetails.source_name = accessible.name();
                        eventDetails.any_data = AccessUtil.getORB().create_any();
                        AccessibleHelper.insert(eventDetails.any_data, accessible);
                        EventDetailsHelper.insert(any, eventDetails);
                        n = accessibleContext.getAccessibleIndexInParent();
                    }
                    JavaBridge.dispatchEvent(object, "object:active-descendant-changed", n, 0, any);
                } else if (string == "AccessibleSelection") {
                    boolean bl = false;
                    Object object = propertyChangeEvent.getSource();
                    AccessibleRole accessibleRole = null;
                    if (object instanceof AccessibleContext) {
                        AccessibleSelection accessibleSelection;
                        accessibleRole = ((AccessibleContext)object).getAccessibleRole();
                        if (accessibleRole == AccessibleRole.TEXT || accessibleRole.toDisplayString(Locale.US).equalsIgnoreCase("paragraph")) {
                            bl = true;
                        } else if (accessibleRole == AccessibleRole.MENU_BAR) {
                            JavaBridge.dispatchFocusEvent(object);
                        } else if (accessibleRole == AccessibleRole.PAGE_TAB_LIST && (accessibleSelection = ((AccessibleContext)object).getAccessibleSelection()) != null && accessibleSelection.getAccessibleSelectionCount() > 0) {
                            javax.accessibility.Accessible accessible = accessibleSelection.getAccessibleSelection(0);
                            JavaBridge.dispatchFocusEvent(accessible);
                        }
                    }
                    if (bl) {
                        int n = 0;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        Any any = AccessUtil.getORB().create_any();
                        AccessibleContext accessibleContext = null;
                        if (object instanceof AccessibleContext) {
                            accessibleContext = (AccessibleContext)object;
                        }
                        AccessibleText accessibleText = accessibleContext.getAccessibleText();
                        boolean bl2 = true;
                        if (accessibleText != null) {
                            n = accessibleText.getSelectionStart();
                            n2 = accessibleText.getSelectionEnd();
                        }
                        if (accessibleContext != null && accessibleContext == oldFocusSource) {
                            if (n != oldFocusSelectStart || n2 != oldFocusSelectEnd) {
                                if (n != oldFocusSelectStart) {
                                    n3 = n;
                                    n4 = oldFocusSelectEnd != oldFocusSelectStart ? oldFocusSelectStart : n2;
                                }
                                if (n2 != oldFocusSelectEnd) {
                                    n4 = n2;
                                    n3 = oldFocusSelectStart != oldFocusSelectEnd ? oldFocusSelectEnd : n;
                                }
                                oldFocusSelectStart = n;
                                oldFocusSelectEnd = n2;
                            } else {
                                bl2 = false;
                            }
                        } else {
                            n3 = n;
                            n4 = n2;
                        }
                        if (bl2) {
                            Accessible accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                            EventDetails eventDetails = new EventDetails();
                            eventDetails.host_application = the_app;
                            eventDetails.source_role = accessible.getRole();
                            eventDetails.source_name = accessible.name();
                            eventDetails.any_data = AccessUtil.getORB().create_any();
                            eventDetails.any_data.insert_string(oldFocusText.substring(Math.min(n3, n4), Math.max(n3, n4)));
                            EventDetailsHelper.insert(any, eventDetails);
                            JavaBridge.dispatchEvent(object, "object:text-selection-changed", n, n2, any);
                        }
                    } else {
                        JavaBridge.dispatchEvent(object, "object:selection-changed", 0, 0);
                    }
                } else if (string != "AccessibleVisibleData") {
                    if (string == "accessibleActionProperty") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-actions", 0, 0);
                    } else if (string == "AccessibleValue") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-value", 0, 0);
                    } else if (string == "AccessibleDescription") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-description", 0, 0);
                    } else if (string == "AccessibleName") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-name", 0, 0);
                    } else if (string == "AccessibleHypertextOffset") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-hypertext-offset", 0, 0);
                    } else if (string == "accessibleTableModelChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:model-changed", 0, 0);
                    } else if (string == "accessibleTableCaptionChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-caption", 0, 0);
                    } else if (string == "accessibleTableSummaryChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-summary", 0, 0);
                    } else if (string == "accessibleTableColumnHeaderChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-column-header", 0, 0);
                    } else if (string == "accessibleTableColumnDescriptionChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-column-description", 0, 0);
                    } else if (string == "accessibleTableRowHeaderChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-row-header", 0, 0);
                    } else if (string == "accessibleTableRowDescriptionChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-row-description", 0, 0);
                    } else if (string == "AccessibleState") {
                        Object object = propertyChangeEvent.getNewValue();
                        Object object3 = propertyChangeEvent.getSource();
                        if (object == AccessibleState.ARMED) {
                            AccessibleRole accessibleRole = null;
                            javax.accessibility.Accessible accessible = null;
                            AccessibleRole accessibleRole2 = null;
                            if (object3 instanceof AccessibleContext) {
                                accessible = ((AccessibleContext)object3).getAccessibleParent();
                                if (accessible != null) {
                                    accessibleRole2 = accessible.getAccessibleContext().getAccessibleRole();
                                }
                                accessibleRole = ((AccessibleContext)object3).getAccessibleRole();
                            } else if (object3 instanceof javax.accessibility.Accessible) {
                                accessible = ((javax.accessibility.Accessible)object3).getAccessibleContext().getAccessibleParent();
                                if (accessible != null) {
                                    accessibleRole2 = accessible.getAccessibleContext().getAccessibleRole();
                                }
                                accessibleRole = ((javax.accessibility.Accessible)object3).getAccessibleContext().getAccessibleRole();
                            }
                            if (accessibleRole != null) {
                                if (accessibleRole == AccessibleRole.MENU_ITEM || accessibleRole == AccessibleRole.MENU) {
                                    JavaBridge.dispatchFocusEvent(object3);
                                } else if (accessibleRole2 != null && accessibleRole2 == AccessibleRole.MENU && (accessibleRole == AccessibleRole.CHECK_BOX || accessibleRole == AccessibleRole.RADIO_BUTTON)) {
                                    JavaBridge.dispatchFocusEvent(object3);
                                }
                            }
                        } else if (object == AccessibleState.SELECTED && object3 instanceof AccessibleContext) {
                            AccessibleRole accessibleRole = null;
                            accessibleRole = ((AccessibleContext)object3).getAccessibleRole();
                            if (accessibleRole == AccessibleRole.MENU) {
                                JavaBridge.dispatchFocusEvent(object3);
                            }
                        } else if (object == AccessibleState.FOCUSED) {
                            JavaBridge.dispatchFocusEvent(object3);
                        }
                        JavaBridge.dispatchStateProperty(propertyChangeEvent);
                    }
                }
            }
        };
        focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JavaBridge.dispatchFocusEvent(focusEvent.getSource());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        };
        lastTextSizes = new HashMap();
    }

    public static class AccessQueue
    extends EventQueue {
        static KeyEvent pendingKeyPress = null;

        @Override
        public void dispatchEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof KeyEvent) {
                this.filterKeyEvent((KeyEvent)aWTEvent);
            } else {
                super.dispatchEvent(aWTEvent);
            }
        }

        private static boolean isModifierKey(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 16: 
                case 17: 
                case 18: 
                case 157: 
                case 65406: {
                    return true;
                }
            }
            return false;
        }

        public void filterKeyEvent(KeyEvent keyEvent) {
            boolean bl = false;
            DeviceEvent deviceEvent = null;
            if (keyEvent.getID() == 401) {
                if (keyEvent.isActionKey() || AccessQueue.isModifierKey(keyEvent)) {
                    deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(keyEvent);
                    bl = JavaBridge.dispatchDeviceEvent(deviceEvent);
                    pendingKeyPress = null;
                } else {
                    pendingKeyPress = keyEvent;
                    bl = true;
                }
            } else if (keyEvent.getID() == 400) {
                if (pendingKeyPress != null) {
                    deviceEvent = KeyEventAdapter.coalescePressAndTyped(pendingKeyPress, keyEvent);
                    if (deviceEvent == null) {
                        deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(pendingKeyPress);
                        bl = JavaBridge.dispatchDeviceEvent(deviceEvent);
                        if (!bl) {
                            super.dispatchEvent(pendingKeyPress);
                        }
                        pendingKeyPress = null;
                        deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(keyEvent);
                    }
                } else {
                    deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(keyEvent);
                }
                if (bl = JavaBridge.dispatchDeviceEvent(deviceEvent)) {
                    pendingKeyPress = null;
                }
            } else if (keyEvent.getID() == 402) {
                if (pendingKeyPress != null) {
                    super.dispatchEvent(pendingKeyPress);
                }
                deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(keyEvent);
                bl = JavaBridge.dispatchDeviceEvent(deviceEvent);
                pendingKeyPress = null;
            }
            if (!bl) {
                if (pendingKeyPress != null) {
                    super.dispatchEvent(pendingKeyPress);
                    pendingKeyPress = null;
                }
                super.dispatchEvent(keyEvent);
            }
        }
    }

    private static class AttachListenerRunnable
    implements Runnable {
        private Accessible accessible;

        public AttachListenerRunnable(Accessible accessible) {
            this.accessible = accessible;
        }

        @Override
        public void run() {
            block2: {
                try {
                    JavaBridge.attachListenerRecurse(this.accessible);
                }
                catch (Exception exception) {
                    if (!debugFlag) break block2;
                    exception.printStackTrace();
                }
            }
        }
    }
}

