/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.PrintStream;
import java.security.AccessController;
import java.util.Locale;
import sun.security.action.GetPropertyAction;

public class Debug {
    private String prefix;
    private static String args = AccessController.doPrivileged(new GetPropertyAction("javax.net.debug", ""));

    public static void Help() {
        System.err.println();
        System.err.println("all            turn on all debugging");
        System.err.println("ssl            turn on ssl debugging");
        System.err.println();
        System.err.println("The following can be used with ssl:");
        System.err.println("\trecord       enable per-record tracing");
        System.err.println("\thandshake    print each handshake message");
        System.err.println("\tkeygen       print key generation data");
        System.err.println("\tsession      print session activity");
        System.err.println("\tdefaultctx   print default SSL initialization");
        System.err.println("\tsslctx       print SSLContext tracing");
        System.err.println("\tsessioncache print session cache tracing");
        System.err.println("\tkeymanager   print key manager tracing");
        System.err.println("\ttrustmanager print trust manager tracing");
        System.err.println("\tpluggability print pluggability tracing");
        System.err.println();
        System.err.println("\thandshake debugging can be widened with:");
        System.err.println("\tdata         hex dump of each handshake message");
        System.err.println("\tverbose      verbose handshake message printing");
        System.err.println();
        System.err.println("\trecord debugging can be widened with:");
        System.err.println("\tplaintext    hex dump of record plaintext");
        System.err.println("\tpacket       print raw SSL/TLS packets");
        System.err.println();
        System.exit(0);
    }

    public static Debug getInstance(String string) {
        return Debug.getInstance(string, string);
    }

    public static Debug getInstance(String string, String string2) {
        if (Debug.isOn(string)) {
            Debug debug = new Debug();
            debug.prefix = string2;
            return debug;
        }
        return null;
    }

    public static boolean isOn(String string) {
        if (args == null) {
            return false;
        }
        int n = 0;
        string = string.toLowerCase(Locale.ENGLISH);
        if (args.indexOf("all") != -1) {
            return true;
        }
        n = args.indexOf("ssl");
        if (!(n == -1 || args.indexOf("sslctx", n) != -1 || string.equals("data") || string.equals("packet") || string.equals("plaintext"))) {
            return true;
        }
        return args.indexOf(string) != -1;
    }

    public void println(String string) {
        System.err.println(this.prefix + ": " + string);
    }

    public void println() {
        System.err.println(this.prefix + ":");
    }

    public static void println(String string, String string2) {
        System.err.println(string + ": " + string2);
    }

    public static void println(PrintStream printStream, String string, byte[] byArray) {
        printStream.print(string + ":  { ");
        if (byArray == null) {
            printStream.print("null");
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                if (i != 0) {
                    printStream.print(", ");
                }
                printStream.print(byArray[i] & 0xFF);
            }
        }
        printStream.println(" }");
    }

    static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + string + " must either be 'true' or 'false'");
    }

    static String toString(byte[] byArray) {
        return sun.security.util.Debug.toString(byArray);
    }

    static {
        if ((args = args.toLowerCase(Locale.ENGLISH)).equals("help")) {
            Debug.Help();
        }
    }
}

