/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.ntlm;

import com.sun.security.ntlm.NTLMException;
import com.sun.security.ntlm.Server;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class NTLMServer
implements SaslServer {
    private static final String NTLM_VERSION = "com.sun.security.sasl.ntlm.version";
    private static final String NTLM_DOMAIN = "com.sun.security.sasl.ntlm.domain";
    private static final String NTLM_HOSTNAME = "com.sun.security.sasl.ntlm.hostname";
    private static final String NTLM_RANDOM = "com.sun.security.sasl.ntlm.random";
    private final Random random;
    private final Server server;
    private byte[] nonce;
    private int step = 0;
    private String authzId;
    private final String mech;
    private String hostname;
    private String target;

    NTLMServer(String string, String string2, String string3, Map<String, ?> map, final CallbackHandler callbackHandler) throws SaslException {
        this.mech = string;
        String string4 = null;
        String string5 = null;
        Random random = null;
        if (map != null) {
            string5 = (String)map.get(NTLM_DOMAIN);
            string4 = (String)map.get(NTLM_VERSION);
            random = (Random)map.get(NTLM_RANDOM);
        }
        Random random2 = this.random = random != null ? random : new Random();
        if (string4 == null) {
            string4 = System.getProperty("ntlm.version");
        }
        if (string5 == null) {
            string5 = string3;
        }
        if (string5 == null) {
            throw new SaslException("Domain must be provided as the serverName argument or in props");
        }
        try {
            this.server = new Server(string4, string5){

                @Override
                public char[] getPassword(String string, String string2) {
                    try {
                        RealmCallback realmCallback = string == null || string.isEmpty() ? new RealmCallback("Domain: ") : new RealmCallback("Domain: ", string);
                        NameCallback nameCallback = new NameCallback("Name: ", string2);
                        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
                        callbackHandler.handle(new Callback[]{realmCallback, nameCallback, passwordCallback});
                        char[] cArray = passwordCallback.getPassword();
                        passwordCallback.clearPassword();
                        return cArray;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    catch (UnsupportedCallbackException unsupportedCallbackException) {
                        return null;
                    }
                }
            };
        }
        catch (NTLMException nTLMException) {
            throw new SaslException("NTLM: server creation failure", nTLMException);
        }
        this.nonce = new byte[8];
    }

    @Override
    public String getMechanismName() {
        return this.mech;
    }

    @Override
    public byte[] evaluateResponse(byte[] byArray) throws SaslException {
        try {
            ++this.step;
            if (this.step == 1) {
                this.random.nextBytes(this.nonce);
                return this.server.type2(byArray, this.nonce);
            }
            String[] stringArray = this.server.verify(byArray, this.nonce);
            this.authzId = stringArray[0];
            this.hostname = stringArray[1];
            this.target = stringArray[2];
            return null;
        }
        catch (NTLMException nTLMException) {
            throw new SaslException("NTLM: generate response failure", nTLMException);
        }
    }

    @Override
    public boolean isComplete() {
        return this.step >= 2;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("authentication not complete");
        }
        return this.authzId;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("Not supported yet.");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("Not supported yet.");
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        if (!this.isComplete()) {
            throw new IllegalStateException("authentication not complete");
        }
        switch (string) {
            case "javax.security.sasl.qop": {
                return "auth";
            }
            case "javax.security.sasl.bound.server.name": {
                return this.target;
            }
            case "com.sun.security.sasl.ntlm.hostname": {
                return this.hostname;
            }
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

