/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.EnumMap;
import java.util.Map;
import java.util.Spliterator;

enum StreamOpFlag {
    DISTINCT(0, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).setAndClear(Type.OP)),
    SORTED(1, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).setAndClear(Type.OP)),
    ORDERED(2, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).setAndClear(Type.OP).clear(Type.TERMINAL_OP).clear(Type.UPSTREAM_TERMINAL_OP)),
    SIZED(3, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).clear(Type.OP)),
    SHORT_CIRCUIT(12, StreamOpFlag.set(Type.OP).set(Type.TERMINAL_OP));

    private static final int SET_BITS = 1;
    private static final int CLEAR_BITS = 2;
    private static final int PRESERVE_BITS = 3;
    private final Map<Type, Integer> maskTable;
    private final int bitPosition;
    private final int set;
    private final int clear;
    private final int preserve;
    static final int SPLITERATOR_CHARACTERISTICS_MASK;
    static final int STREAM_MASK;
    static final int OP_MASK;
    static final int TERMINAL_OP_MASK;
    static final int UPSTREAM_TERMINAL_OP_MASK;
    private static final int FLAG_MASK;
    private static final int FLAG_MASK_IS;
    private static final int FLAG_MASK_NOT;
    static final int INITIAL_OPS_VALUE;
    static final int IS_DISTINCT;
    static final int NOT_DISTINCT;
    static final int IS_SORTED;
    static final int NOT_SORTED;
    static final int IS_ORDERED;
    static final int NOT_ORDERED;
    static final int IS_SIZED;
    static final int NOT_SIZED;
    static final int IS_SHORT_CIRCUIT;

    private static MaskBuilder set(Type type) {
        return new MaskBuilder(new EnumMap<Type, Integer>(Type.class)).set(type);
    }

    private StreamOpFlag(int n2, MaskBuilder maskBuilder) {
        this.maskTable = maskBuilder.build();
        this.bitPosition = n2 *= 2;
        this.set = 1 << n2;
        this.clear = 2 << n2;
        this.preserve = 3 << n2;
    }

    int set() {
        return this.set;
    }

    int clear() {
        return this.clear;
    }

    boolean isStreamFlag() {
        return this.maskTable.get((Object)Type.STREAM) > 0;
    }

    boolean isKnown(int n) {
        return (n & this.preserve) == this.set;
    }

    boolean isCleared(int n) {
        return (n & this.preserve) == this.clear;
    }

    boolean isPreserved(int n) {
        return (n & this.preserve) == this.preserve;
    }

    boolean canSet(Type type) {
        return (this.maskTable.get((Object)type) & 1) > 0;
    }

    private static int createMask(Type type) {
        int n = 0;
        for (StreamOpFlag streamOpFlag : StreamOpFlag.values()) {
            n |= streamOpFlag.maskTable.get((Object)type) << streamOpFlag.bitPosition;
        }
        return n;
    }

    private static int createFlagMask() {
        int n = 0;
        for (StreamOpFlag streamOpFlag : StreamOpFlag.values()) {
            n |= streamOpFlag.preserve;
        }
        return n;
    }

    private static int getMask(int n) {
        return n == 0 ? FLAG_MASK : ~(n | (FLAG_MASK_IS & n) << 1 | (FLAG_MASK_NOT & n) >> 1);
    }

    static int combineOpFlags(int n, int n2) {
        return n2 & StreamOpFlag.getMask(n) | n;
    }

    static int toStreamFlags(int n) {
        return ~n >> 1 & FLAG_MASK_IS & n;
    }

    static int toCharacteristics(int n) {
        return n & SPLITERATOR_CHARACTERISTICS_MASK;
    }

    static int fromCharacteristics(Spliterator<?> spliterator) {
        int n = spliterator.characteristics();
        if ((n & 4) != 0 && spliterator.getComparator() != null) {
            return n & SPLITERATOR_CHARACTERISTICS_MASK & 0xFFFFFFFB;
        }
        return n & SPLITERATOR_CHARACTERISTICS_MASK;
    }

    static int fromCharacteristics(int n) {
        return n & SPLITERATOR_CHARACTERISTICS_MASK;
    }

    static {
        SPLITERATOR_CHARACTERISTICS_MASK = StreamOpFlag.createMask(Type.SPLITERATOR);
        STREAM_MASK = StreamOpFlag.createMask(Type.STREAM);
        OP_MASK = StreamOpFlag.createMask(Type.OP);
        TERMINAL_OP_MASK = StreamOpFlag.createMask(Type.TERMINAL_OP);
        UPSTREAM_TERMINAL_OP_MASK = StreamOpFlag.createMask(Type.UPSTREAM_TERMINAL_OP);
        FLAG_MASK = StreamOpFlag.createFlagMask();
        FLAG_MASK_IS = STREAM_MASK;
        FLAG_MASK_NOT = STREAM_MASK << 1;
        INITIAL_OPS_VALUE = FLAG_MASK_IS | FLAG_MASK_NOT;
        IS_DISTINCT = StreamOpFlag.DISTINCT.set;
        NOT_DISTINCT = StreamOpFlag.DISTINCT.clear;
        IS_SORTED = StreamOpFlag.SORTED.set;
        NOT_SORTED = StreamOpFlag.SORTED.clear;
        IS_ORDERED = StreamOpFlag.ORDERED.set;
        NOT_ORDERED = StreamOpFlag.ORDERED.clear;
        IS_SIZED = StreamOpFlag.SIZED.set;
        NOT_SIZED = StreamOpFlag.SIZED.clear;
        IS_SHORT_CIRCUIT = StreamOpFlag.SHORT_CIRCUIT.set;
    }

    private static class MaskBuilder {
        final Map<Type, Integer> map;

        MaskBuilder(Map<Type, Integer> map) {
            this.map = map;
        }

        MaskBuilder mask(Type type, Integer n) {
            this.map.put(type, n);
            return this;
        }

        MaskBuilder set(Type type) {
            return this.mask(type, 1);
        }

        MaskBuilder clear(Type type) {
            return this.mask(type, 2);
        }

        MaskBuilder setAndClear(Type type) {
            return this.mask(type, 3);
        }

        Map<Type, Integer> build() {
            for (Type type : Type.values()) {
                this.map.putIfAbsent(type, 0);
            }
            return this.map;
        }
    }

    static enum Type {
        SPLITERATOR,
        STREAM,
        OP,
        TERMINAL_OP,
        UPSTREAM_TERMINAL_OP;

    }
}

