/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Field;
import sun.reflect.UnsafeFieldAccessorImpl;

class UnsafeFloatFieldAccessorImpl
extends UnsafeFieldAccessorImpl {
    UnsafeFloatFieldAccessorImpl(Field field) {
        super(field);
    }

    @Override
    public Object get(Object object) throws IllegalArgumentException {
        return new Float(this.getFloat(object));
    }

    @Override
    public boolean getBoolean(Object object) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    @Override
    public byte getByte(Object object) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    @Override
    public char getChar(Object object) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    @Override
    public short getShort(Object object) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    @Override
    public int getInt(Object object) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    @Override
    public long getLong(Object object) throws IllegalArgumentException {
        throw this.newGetLongIllegalArgumentException();
    }

    @Override
    public float getFloat(Object object) throws IllegalArgumentException {
        this.ensureObj(object);
        return unsafe.getFloat(object, this.fieldOffset);
    }

    @Override
    public double getDouble(Object object) throws IllegalArgumentException {
        return this.getFloat(object);
    }

    @Override
    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(object2);
        }
        if (object2 == null) {
            this.throwSetIllegalArgumentException(object2);
        }
        if (object2 instanceof Byte) {
            unsafe.putFloat(object, this.fieldOffset, (float)((Byte)object2).byteValue());
            return;
        }
        if (object2 instanceof Short) {
            unsafe.putFloat(object, this.fieldOffset, (float)((Short)object2).shortValue());
            return;
        }
        if (object2 instanceof Character) {
            unsafe.putFloat(object, this.fieldOffset, (float)((Character)object2).charValue());
            return;
        }
        if (object2 instanceof Integer) {
            unsafe.putFloat(object, this.fieldOffset, (float)((Integer)object2).intValue());
            return;
        }
        if (object2 instanceof Long) {
            unsafe.putFloat(object, this.fieldOffset, (float)((Long)object2).longValue());
            return;
        }
        if (object2 instanceof Float) {
            unsafe.putFloat(object, this.fieldOffset, ((Float)object2).floatValue());
            return;
        }
        this.throwSetIllegalArgumentException(object2);
    }

    @Override
    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(bl);
    }

    @Override
    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, by);
    }

    @Override
    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, c);
    }

    @Override
    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, s);
    }

    @Override
    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, n);
    }

    @Override
    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, l);
    }

    @Override
    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(f);
        }
        unsafe.putFloat(object, this.fieldOffset, f);
    }

    @Override
    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(d);
    }
}

