/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.client;

import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;

public class ClientUtils
implements CommonConstants {
    private static final MethodNameFormatter classNameFormatter = new DefaultMethodNameFormatter(1);
    public static final String LINES_PREFIX = "[lines]";

    public static String selectionToString(SourceCodeSelection sourceCodeSelection) {
        if (sourceCodeSelection == null) {
            return "";
        }
        if (sourceCodeSelection.definedViaSourceLines()) {
            return LINES_PREFIX + sourceCodeSelection.getClassName() + "," + sourceCodeSelection.getStartLine() + "," + sourceCodeSelection.getEndLine();
        }
        if (sourceCodeSelection.getMethodName() == null) {
            return sourceCodeSelection.getClassName();
        }
        if (sourceCodeSelection.getMethodSignature() == null) {
            return sourceCodeSelection.getClassName() + "," + sourceCodeSelection.getMethodName();
        }
        return sourceCodeSelection.getClassName() + "," + sourceCodeSelection.getMethodName() + "," + sourceCodeSelection.getMethodSignature();
    }

    public static SourceCodeSelection stringToSelection(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = false;
        if (string.startsWith(LINES_PREFIX)) {
            bl = true;
            string = string.substring(LINES_PREFIX.length());
        }
        String[] stringArray = string.split(",");
        if (bl) {
            if (stringArray.length != 3) {
                return null;
            }
            try {
                return new SourceCodeSelection(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        String string2 = "";
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        String string3 = "";
        if (stringArray.length > 1) {
            string3 = stringArray[1];
        }
        String string4 = "";
        if (stringArray.length > 2) {
            string4 = stringArray[2];
        }
        return new SourceCodeSelection(string2, string3, string4);
    }

    public static String formatClassName(String string) {
        return classNameFormatter.formatMethodName(string, "", "").toFormatted();
    }

    public static String parseClassName(String string, boolean bl) {
        if (string.isEmpty()) {
            return null;
        }
        if (string.equals(".*")) {
            return bl ? "" : null;
        }
        if (string.equals(".**")) {
            return null;
        }
        String[] stringArray = string.split("\\.", -1);
        int n = stringArray.length;
        String string2 = stringArray[n - 1];
        if (n == 1) {
            if (string.startsWith("*")) {
                return null;
            }
            return ClientUtils.checkWildcards(string, bl, false) ? string : null;
        }
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].isEmpty()) {
                return null;
            }
            if (i >= n - 1 || !stringArray[i].contains("*")) continue;
            return null;
        }
        if (ClientUtils.checkWildcards(string2, bl, true)) {
            return string;
        }
        return null;
    }

    private static boolean checkWildcards(String string, boolean bl, boolean bl2) {
        int n = string.indexOf(42);
        if (n == -1) {
            return true;
        }
        if (!bl) {
            return false;
        }
        if (n == string.length() - 1) {
            return true;
        }
        if (!bl2) {
            return false;
        }
        if (n != string.length() - 2 || !string.endsWith("*")) {
            return false;
        }
        return n == 0 || string.charAt(n - 1) == '$';
    }

    public static class TargetAppOrVMTerminated
    extends Exception {
        public static final int VM = 1;
        public static final int APP = 2;
        int code;

        public TargetAppOrVMTerminated(int n) {
            this.code = n;
        }

        public TargetAppOrVMTerminated(int n, String string) {
            super(string);
            this.code = n;
        }

        public boolean isAppTerminated() {
            return this.code == 2;
        }

        @Override
        public String getMessage() {
            if (super.getMessage() == null) {
                return this.code == 1 ? "Target JVM inactive" : "Target JVM inactive";
            }
            return super.getMessage();
        }

        public boolean isVMTerminated() {
            return this.code == 1;
        }
    }

    public static class TargetAppFailedToStart
    extends Exception {
        private String origCause;

        public TargetAppFailedToStart(String string) {
            this.origCause = string;
        }

        public String getOrigCause() {
            return this.origCause;
        }
    }

    public static class SourceCodeSelection
    implements Cloneable {
        String className;
        String methodName;
        String methodSignature;
        boolean isMarkerMethod;
        int endLine;
        int startLine;

        public SourceCodeSelection(String string, int n, int n2) {
            this.className = string != null ? string : "";
            this.startLine = n;
            this.endLine = n2;
        }

        public SourceCodeSelection(String string, String string2, String string3) {
            this.className = string != null ? string : "";
            this.methodName = string2 != null ? string2 : "";
            this.methodSignature = string3 != null ? string3 : "";
            this.endLine = -1;
            this.startLine = -1;
        }

        public SourceCodeSelection(int n) {
            if (n == 1) {
                this.className = "*NO_CLASS_NAME*";
                this.methodName = "*NO_METHOD_NAME*";
                this.methodSignature = "*NO_METHOD_SIGNATURE*";
                this.endLine = 0;
                this.startLine = 0;
            }
        }

        public String getClassName() {
            return this.className;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public void setMarkerMethod(boolean bl) {
            this.isMarkerMethod = bl;
        }

        public boolean isMarkerMethod() {
            return this.isMarkerMethod;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodSignature() {
            return this.methodSignature;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public boolean isDefaultPackage() {
            return this.className.isEmpty() && this.methodName.isEmpty() && this.methodSignature.isEmpty();
        }

        public boolean isInDefaultPackage() {
            return this.isDefaultPackage() || !this.className.contains(".");
        }

        public Object clone() throws CloneNotSupportedException {
            SourceCodeSelection sourceCodeSelection = (SourceCodeSelection)super.clone();
            sourceCodeSelection.className = this.className;
            sourceCodeSelection.methodName = this.methodName;
            sourceCodeSelection.methodSignature = this.methodSignature;
            return sourceCodeSelection;
        }

        public boolean contains(SourceCodeSelection sourceCodeSelection) {
            if (this.definedViaSourceLines()) {
                if (this.className.equals(sourceCodeSelection.className)) {
                    return this.startLine >= sourceCodeSelection.startLine && this.endLine <= sourceCodeSelection.endLine;
                }
            } else {
                if (this.isDefaultPackage()) {
                    return this.isInDefaultPackage();
                }
                String string = this.toFlattened().replace('.', '\\').replace('$', '\\') + "\\";
                String string2 = sourceCodeSelection.toFlattened().replace('.', '\\').replace('$', '\\');
                return string2.startsWith(string);
            }
            return false;
        }

        public boolean definedViaMethodName() {
            return this.startLine == -1;
        }

        public boolean definedViaSourceLines() {
            return this.startLine > 0;
        }

        public boolean equals(Object object) {
            String string;
            if (object == null) {
                return false;
            }
            if (!(object instanceof SourceCodeSelection)) {
                return false;
            }
            SourceCodeSelection sourceCodeSelection = (SourceCodeSelection)object;
            if (this.startLine != sourceCodeSelection.startLine || this.endLine != sourceCodeSelection.endLine) {
                return false;
            }
            String string2 = this.className.replace("$**", "").replace(".**", "").replace(".*", "");
            if (!string2.equals(string = sourceCodeSelection.className.replace("$**", "").replace(".**", "").replace(".*", ""))) {
                return false;
            }
            if (this.methodName != null ? !this.methodName.equals(sourceCodeSelection.methodName) : sourceCodeSelection.methodName != null) {
                return false;
            }
            return !(this.methodSignature != null ? !this.methodSignature.equals(sourceCodeSelection.methodSignature) : sourceCodeSelection.methodSignature != null);
        }

        public int hashCode() {
            int n = 0;
            n += this.startLine + this.endLine;
            n += this.className.hashCode();
            n += this.methodName != null ? this.methodName.hashCode() : 0;
            return n += this.methodSignature != null ? this.methodSignature.hashCode() : 0;
        }

        public String toFlattened() {
            if (this.className == null || this.className.length() == 0) {
                return "";
            }
            boolean bl = this.className.endsWith("*");
            StringBuilder stringBuilder = new StringBuilder(this.className.replace("$**", "").replace(".**", "").replace(".*", ""));
            if (!bl && this.methodName != null && this.methodName.length() > 0 && !this.methodName.endsWith("*")) {
                stringBuilder.append('.').append(this.methodName);
            }
            if (!bl && this.methodSignature != null && this.methodSignature.length() > 0 && !this.methodSignature.endsWith("*")) {
                stringBuilder.append(this.methodSignature);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            if (this.definedViaSourceLines()) {
                return "Source Code defined via lines: [class: " + this.className + ", start line: " + this.startLine + ", end line: " + this.endLine + "]";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Source Code defined via method: ");
            stringBuilder.append("\n");
            stringBuilder.append("  class: ");
            stringBuilder.append(this.className);
            stringBuilder.append("\n  ");
            if (this.methodName != null) {
                stringBuilder.append("  method: ");
                stringBuilder.append(this.methodName);
                stringBuilder.append("  ");
                stringBuilder.append(this.methodSignature);
                stringBuilder.append("\n  ");
            }
            if (this.isMarkerMethod) {
                stringBuilder.append("[Marker Method]\n");
            }
            return stringBuilder.toString();
        }
    }
}

