/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.suggest.stats;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.index.suggest.stats.SuggestStats;

public final class ShardSuggestMetric {
    private final MeanMetric suggestMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();

    public void preSuggest() {
        this.currentMetric.inc();
    }

    public void postSuggest(long tookInNanos) {
        this.currentMetric.dec();
        this.suggestMetric.inc(tookInNanos);
    }

    public SuggestStats stats() {
        return new SuggestStats(this.suggestMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.suggestMetric.sum()), this.currentMetric.count());
    }
}

