/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.worker.RemoteTestClassProcessor;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.internal.tasks.testing.worker.TestWorker;
import org.gradle.internal.Factory;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkingTestClassProcessor
implements TestClassProcessor {
    private final Factory<WorkerProcessBuilder> workerFactory;
    private final WorkerTestClassProcessorFactory processorFactory;
    private final JavaForkOptions options;
    private final Iterable<File> classPath;
    private final Action<WorkerProcessBuilder> buildConfigAction;
    private RemoteTestClassProcessor remoteProcessor;
    private WorkerProcess workerProcess;
    private TestResultProcessor resultProcessor;

    public ForkingTestClassProcessor(Factory<WorkerProcessBuilder> workerFactory, WorkerTestClassProcessorFactory processorFactory, JavaForkOptions options, Iterable<File> classPath, Action<WorkerProcessBuilder> buildConfigAction) {
        this.workerFactory = workerFactory;
        this.processorFactory = processorFactory;
        this.options = options;
        this.classPath = classPath;
        this.buildConfigAction = buildConfigAction;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        if (this.remoteProcessor == null) {
            this.remoteProcessor = this.forkProcess();
        }
        this.remoteProcessor.processTestClass(testClass);
    }

    RemoteTestClassProcessor forkProcess() {
        WorkerProcessBuilder builder = (WorkerProcessBuilder)this.workerFactory.create();
        builder.setBaseName("Gradle Test Executor");
        builder.applicationClasspath(this.classPath);
        builder.setLoadApplicationInSystemClassLoader(true);
        builder.worker((Action)new TestWorker(this.processorFactory));
        this.options.copyTo((JavaForkOptions)builder.getJavaCommand());
        this.buildConfigAction.execute((Object)builder);
        this.workerProcess = builder.build();
        this.workerProcess.start();
        ObjectConnection connection = this.workerProcess.getConnection();
        connection.useParameterSerializer(TestEventSerializer.create());
        connection.addIncoming(TestResultProcessor.class, (Object)this.resultProcessor);
        RemoteTestClassProcessor remoteProcessor = (RemoteTestClassProcessor)connection.addOutgoing(RemoteTestClassProcessor.class);
        connection.connect();
        remoteProcessor.startProcessing();
        return remoteProcessor;
    }

    @Override
    public void stop() {
        if (this.remoteProcessor != null) {
            this.remoteProcessor.stop();
            this.workerProcess.waitForStop();
        }
    }
}

