/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.base.plugins;

import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.test.TestSuiteBinarySpec;
import org.gradle.platform.base.test.TestSuiteContainer;
import org.gradle.platform.base.test.TestSuiteSpec;
import org.gradle.testing.base.TestSuiteTaskCollection;
import org.gradle.testing.base.internal.BaseTestSuiteSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class TestingModelBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void registerTestSuiteSpec(ComponentTypeBuilder<TestSuiteSpec> builder) {
            builder.defaultImplementation(BaseTestSuiteSpec.class);
        }

        @Model
        void testSuites(TestSuiteContainer testSuites) {
        }

        @Mutate
        void copyTestBinariesToGlobalContainer(BinaryContainer binaries, TestSuiteContainer testSuites) {
            for (TestSuiteSpec testSuite : testSuites.values()) {
                for (BinarySpecInternal binary : testSuite.getBinaries().withType(BinarySpecInternal.class).values()) {
                    binaries.put(binary.getProjectScopedName(), (Object)binary);
                }
            }
        }

        @Mutate
        void attachBinariesToCheckLifecycle(@Path(value="tasks.check") Task checkTask, ModelMap<TestSuiteBinarySpec> binaries) {
            for (TestSuiteBinarySpec testBinary : binaries) {
                BinaryTasksCollection tasks = testBinary.getTasks();
                if (!(tasks instanceof TestSuiteTaskCollection)) continue;
                checkTask.dependsOn(new Object[]{((TestSuiteTaskCollection)tasks).getRun()});
            }
        }
    }
}

