/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.test.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.internal.Cast;
import org.gradle.internal.Transformers;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.JvmComponentSpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.test.JvmTestSuiteBinarySpec;
import org.gradle.jvm.test.JvmTestSuiteSpec;
import org.gradle.jvm.test.internal.JvmTestSuiteBinarySpecInternal;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.language.base.internal.model.DefaultVariantsMetaData;
import org.gradle.model.Defaults;
import org.gradle.model.ModelMap;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultLibraryBinaryDependencySpec;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmTestSuiteRules
extends RuleSource {
    public static void createJvmTestSuiteTasks(final JvmTestSuiteBinarySpec binary, final JvmAssembly jvmAssembly, final File buildDir) {
        binary.getTasks().create(JvmTestSuiteRules.testTaskNameFor(binary), Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                test.setGroup("verification");
                test.setDescription(String.format("Runs %s.", WordUtils.uncapitalize((String)binary.getDisplayName())));
                test.dependsOn(new Object[]{jvmAssembly});
                test.setTestClassesDir(binary.getClassesDir());
                test.setClasspath((FileCollection)binary.getRuntimeClasspath());
                this.configureReports((JvmTestSuiteBinarySpecInternal)binary, test);
            }

            private void configureReports(JvmTestSuiteBinarySpecInternal binary2, Test test) {
                TestTaskReports reports = test.getReports();
                File reportsDirectory = new File(buildDir, "reports");
                File reportsOutputDirectory = binary2.getNamingScheme().getOutputDirectory(reportsDirectory);
                File htmlDir = new File(reportsOutputDirectory, "tests");
                File xmlDir = new File(buildDir, "test-results");
                File xmlDirOutputDirectory = binary2.getNamingScheme().getOutputDirectory(xmlDir);
                File binDir = new File(xmlDirOutputDirectory, "binary");
                reports.getHtml().setDestination((Object)htmlDir);
                reports.getJunitXml().setDestination(xmlDirOutputDirectory);
                test.setBinResultsDir(binDir);
            }
        });
    }

    @Defaults
    public void createTestSuiteTasks(ModelMap<JvmTestSuiteBinarySpec> binaries, final @Path(value="buildDir") File buildDir) {
        binaries.afterEach((Action)new Action<JvmTestSuiteBinarySpec>(){

            public void execute(JvmTestSuiteBinarySpec binary) {
                JvmAssembly jvmAssembly = ((WithJvmAssembly)binary).getAssembly();
                JvmTestSuiteRules.createJvmTestSuiteTasks(binary, jvmAssembly, buildDir);
            }
        });
    }

    public static void createJvmTestSuiteBinaries(ModelMap<BinarySpec> testBinaries, ServiceRegistry registry, PlatformResolvers platformResolver, JvmTestSuiteSpec testSuite, JavaToolChainRegistry toolChains, ModelSchemaStore modelSchemaStore, Class<? extends JvmTestSuiteBinarySpec> testSuiteBinary) {
        JvmComponentSpec testedComponent = testSuite.getTestedComponent();
        if (testedComponent == null) {
            JvmTestSuiteRules.createJvmTestSuiteBinary(testBinaries, testSuiteBinary, testSuite, null, toolChains, platformResolver, registry, modelSchemaStore);
        } else {
            for (JvmBinarySpec testedBinary : JvmTestSuiteRules.testedBinariesOf(testSuite)) {
                JvmTestSuiteRules.createJvmTestSuiteBinary(testBinaries, testSuiteBinary, testSuite, testedBinary, toolChains, platformResolver, registry, modelSchemaStore);
            }
        }
    }

    private static <T extends JvmTestSuiteBinarySpec> void createJvmTestSuiteBinary(ModelMap<BinarySpec> testBinaries, Class<T> testSuiteBinaryClass, final JvmTestSuiteSpec testSuite, final JvmBinarySpec testedBinary, final JavaToolChainRegistry toolChains, PlatformResolvers platformResolver, final ServiceRegistry serviceRegistry, final ModelSchemaStore modelSchemaStore) {
        List<JavaPlatform> javaPlatforms = JvmTestSuiteRules.resolvePlatforms(platformResolver);
        final JavaPlatform platform = testedBinary != null ? testedBinary.getTargetPlatform() : javaPlatforms.get(0);
        final BinaryNamingScheme namingScheme = JvmTestSuiteRules.namingSchemeFor(testSuite, testedBinary, javaPlatforms, platform);
        testBinaries.create(namingScheme.getBinaryName(), testSuiteBinaryClass, new Action<T>(){

            public void execute(T binary) {
                JvmTestSuiteBinarySpecInternal testBinary = (JvmTestSuiteBinarySpecInternal)binary;
                testBinary.setNamingScheme(namingScheme);
                testBinary.setTargetPlatform(platform);
                testBinary.setToolChain((JavaToolChain)toolChains.getForPlatform((Platform)platform));
                testBinary.setTestedBinary(testedBinary);
                this.addTestSuiteDependencies(testBinary);
                this.injectDependencyResolutionServices(testBinary);
                this.configureCompileClasspath(testBinary);
            }

            private boolean addTestSuiteDependencies(JvmTestSuiteBinarySpecInternal testBinary) {
                return testBinary.getDependencies().addAll(testSuite.getDependencies().getDependencies());
            }

            private void injectDependencyResolutionServices(JvmTestSuiteBinarySpecInternal testBinary) {
                ArtifactDependencyResolver dependencyResolver = (ArtifactDependencyResolver)serviceRegistry.get(ArtifactDependencyResolver.class);
                RepositoryHandler repositories = (RepositoryHandler)serviceRegistry.get(RepositoryHandler.class);
                List resolutionAwareRepositories = CollectionUtils.collect((List)repositories, (Transformer)Transformers.cast(ResolutionAwareRepository.class));
                testBinary.setArtifactDependencyResolver(dependencyResolver);
                testBinary.setRepositories(resolutionAwareRepositories);
                ModelSchema schema = (ModelSchema)Cast.uncheckedCast((Object)modelSchemaStore.getSchema(testBinary.getPublicType()));
                testBinary.setVariantsMetaData(DefaultVariantsMetaData.extractFrom((BinarySpec)testBinary, (ModelSchema)schema));
            }

            private void configureCompileClasspath(JvmTestSuiteBinarySpecInternal testSuiteBinary) {
                if (testedBinary != null) {
                    Collection dependencies = testSuiteBinary.getDependencies();
                    BinarySpecInternal binary = (BinarySpecInternal)testedBinary;
                    LibraryBinaryIdentifier id = binary.getId();
                    dependencies.add(DefaultLibraryBinaryDependencySpec.of((LibraryBinaryIdentifier)id));
                    if (testedBinary instanceof JarBinarySpecInternal) {
                        dependencies.addAll(((JarBinarySpecInternal)testedBinary).getApiDependencies());
                    }
                }
            }
        });
    }

    public static Collection<JvmBinarySpec> testedBinariesOf(JvmTestSuiteSpec testSuite) {
        return JvmTestSuiteRules.testedBinariesWithType(JvmBinarySpec.class, testSuite);
    }

    public static <S> Collection<S> testedBinariesWithType(Class<S> type, JvmTestSuiteSpec testSuite) {
        JvmComponentSpec spec = testSuite.getTestedComponent();
        return spec.getBinaries().withType(type).values();
    }

    private static BinaryNamingScheme namingSchemeFor(JvmTestSuiteSpec testSuiteSpec, JvmBinarySpec testedBinary, List<JavaPlatform> selectedPlatforms, JavaPlatform platform) {
        BinaryNamingScheme namingScheme = DefaultBinaryNamingScheme.component((String)testSuiteSpec.getName()).withBinaryType("binary").withRole("assembly", true).withVariantDimension((Named)platform, selectedPlatforms);
        if (testedBinary != null) {
            return namingScheme.withVariantDimension(((BinarySpecInternal)testedBinary).getProjectScopedName());
        }
        return namingScheme;
    }

    private static List<JavaPlatform> resolvePlatforms(PlatformResolvers platformResolver) {
        PlatformRequirement defaultPlatformRequirement = DefaultPlatformRequirement.create((String)DefaultJavaPlatform.current().getName());
        return Collections.singletonList(platformResolver.resolve(JavaPlatform.class, defaultPlatformRequirement));
    }

    private static String testTaskNameFor(JvmTestSuiteBinarySpec binary) {
        return ((BinarySpecInternal)binary).getProjectScopedName() + "Test";
    }
}

