/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javajs.util.Lst;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptProcess;
import org.jmol.script.ScriptProcessRunnable;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class ScriptParallelProcessor
extends ScriptFunction
implements JmolParallelProcessor {
    Viewer vwr;
    public volatile int counter = 0;
    public volatile Error error = null;
    Object lock = new Object();
    private Lst<ScriptProcess> processes = new Lst();

    @Override
    public Object getExecutor() {
        return Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAllProcesses(Viewer viewer) {
        if (this.processes.size() == 0) {
            return;
        }
        this.vwr = viewer;
        boolean bl = !viewer.isParallel() && viewer.setParallel(true);
        Lst<ShapeManager> lst = new Lst<ShapeManager>();
        this.error = null;
        this.counter = 0;
        if (Logger.debugging) {
            Logger.debug("running " + this.processes.size() + " processes on " + Viewer.nProcessors + " processesors inParallel=" + bl);
        }
        this.counter = this.processes.size();
        int n = this.processes.size();
        while (--n >= 0) {
            ShapeManager shapeManager = null;
            if (bl) {
                shapeManager = new ShapeManager(viewer);
                shapeManager.setParallel();
                lst.addLast(shapeManager);
            }
            this.runProcess((ScriptProcess)this.processes.remove(0), shapeManager);
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.counter > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.error == null) continue;
                throw this.error;
            }
        }
        this.mergeResults(lst);
        viewer.setParallel(false);
    }

    void mergeResults(Lst<ShapeManager> lst) {
        try {
            for (int i = 0; i < lst.size(); ++i) {
                this.mergeShapes((ShapeManager)lst.get(i));
            }
        }
        catch (Error error) {
            throw error;
        }
        finally {
            this.counter = -1;
            lst = null;
        }
    }

    private void mergeShapes(ShapeManager shapeManager) {
        Shape[] shapeArray = shapeManager.shapes;
        if (shapeArray == null) {
            return;
        }
        if (this.vwr.shm.shapes == null) {
            this.vwr.shm.shapes = shapeArray;
        } else {
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeArray[i] == null || !(shapeArray[i] instanceof MeshCollection)) continue;
                if (this.vwr.shm.shapes[i] == null) {
                    this.vwr.shm.loadShape(i);
                }
                ((MeshCollection)this.vwr.shm.shapes[i]).merge((MeshCollection)shapeArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearShapeManager(Error error) {
        ScriptParallelProcessor scriptParallelProcessor = this;
        synchronized (scriptParallelProcessor) {
            this.error = error;
            this.notifyAll();
        }
    }

    @Override
    public void addProcess(String string, ScriptContext scriptContext) {
        this.processes.addLast(new ScriptProcess(string, scriptContext));
    }

    private void runProcess(ScriptProcess scriptProcess, ShapeManager shapeManager) {
        Executor executor;
        ScriptProcessRunnable scriptProcessRunnable = new ScriptProcessRunnable(this, scriptProcess, this.lock, shapeManager);
        Executor executor2 = executor = shapeManager == null ? null : this.getMyExecutor();
        if (executor != null) {
            executor.execute(scriptProcessRunnable);
        } else {
            scriptProcessRunnable.run();
        }
    }

    void eval(ScriptContext scriptContext, ShapeManager shapeManager) {
        this.vwr.evalParallel(scriptContext, shapeManager);
    }

    private Executor getMyExecutor() {
        if (this.vwr.executor != null || Viewer.nProcessors < 2) {
            return (Executor)this.vwr.executor;
        }
        try {
            this.vwr.executor = this.getExecutor();
        }
        catch (Exception exception) {
            this.vwr.executor = null;
        }
        catch (Error error) {
            this.vwr.executor = null;
        }
        if (this.vwr.executor == null) {
            Logger.error("parallel processing is not available");
        }
        return (Executor)this.vwr.executor;
    }
}

