/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.DSSPInterface;
import org.jmol.api.Interface;
import org.jmol.api.JmolAnnotationParser;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.JmolBioModel;
import org.jmol.modelset.JmolBioModelSet;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioExt;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Resolver;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public final class BioModel
extends Model
implements JmolBioModelSet,
JmolBioModel {
    int bioPolymerCount = 0;
    public BioPolymer[] bioPolymers;
    boolean isMutated;
    private String defaultStructure;
    private Viewer vwr;
    private Map<String, BS>[] unitIdSets;
    private BioExt bx;
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};

    public Map<String, String> getAllHeteroList(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        int n2 = this.ms.mc;
        while (--n2 >= 0) {
            Map map;
            if (n >= 0 && n2 != n || (map = (Map)this.ms.getInfo(n2, "hetNames")) == null) continue;
            bl = true;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                hashtable.put(string, (String)entry.getValue());
            }
        }
        return bl ? hashtable : null;
    }

    public void setAllProteinType(BS bS, STR sTR) {
        Group group;
        short s;
        int n;
        int n2 = -1;
        int n3 = -1;
        BS bS2 = this.ms.getModelBS(bS, false);
        this.setAllDefaultStructure(bS2);
        Atom[] atomArray = this.ms.at;
        Model[] modelArray = this.ms.am;
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            if (!atomArray[n4].group.isAdded(n4)) {
                n2 = atomArray[n4].group.setProteinStructureType(sTR, n3 == n4 - 1 ? n2 : -1);
                n = atomArray[n4].mi;
                modelArray[n].structureTainted = true;
                this.ms.proteinStructureTainted = true;
                n3 = n4 = atomArray[n4].group.lastAtomIndex;
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        int[] nArray = new int[this.ms.mc];
        for (n = 0; n < this.ms.ac; ++n) {
            s = atomArray[n].mi;
            if (!bS2.get((int)s)) {
                n = modelArray[s].firstAtomIndex + modelArray[s].act - 1;
                continue;
            }
            group = atomArray[n].group;
            if (group.isAdded(n)) continue;
            n3 = group.getStrucNo();
            if (n3 < 1000 && n3 > nArray[s]) {
                nArray[s] = n3;
            }
            n = group.lastAtomIndex;
        }
        for (n = 0; n < this.ms.ac; ++n) {
            s = atomArray[n].mi;
            if (!bS2.get((int)s)) {
                n = modelArray[s].firstAtomIndex + modelArray[s].act - 1;
                continue;
            }
            group = atomArray[n].group;
            if (group.isAdded(n)) continue;
            n = group.lastAtomIndex;
            if (group.getStrucNo() <= 1000) continue;
            short s2 = s;
            int n5 = nArray[s2] + 1;
            nArray[s2] = n5;
            group.setStrucNo(n5);
        }
    }

    private BS modelsOf(BS bS, BS bS2) {
        int n;
        BS bS3 = BS.newN((int)this.ms.mc);
        boolean bl = bS == null;
        int n2 = n = bl ? this.ms.ac - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = this.ms.am[this.ms.at[n2].mi].trajectoryBaseIndex;
            if (!this.ms.isJmolDataFrameForModel(n3)) {
                bS3.set(n3);
                bS2.set(n2);
            }
            n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        return bS3;
    }

    public String getAllDefaultStructures(BS bS, BS bS2) {
        BS bS3 = this.modelsOf(bS, bS2);
        SB sB = new SB();
        int n = bS3.nextSetBit(0);
        while (n >= 0) {
            if (this.ms.am[n].isBioModel && ((BioModel)this.ms.am[n]).defaultStructure != null) {
                sB.append(((BioModel)this.ms.am[n]).defaultStructure);
            }
            n = bS3.nextSetBit(n + 1);
        }
        return sB.toString();
    }

    public String calculateAllStuctures(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        BS bS2 = new BS();
        BS bS3 = BSUtil.copyInvert((BS)this.modelsOf(bS, bS2), (int)this.ms.mc);
        if (!bl4) {
            return this.ms.calculateStructuresAllExcept(bS3, bl, bl2, bl3, false, false);
        }
        this.ms.recalculatePolymers(bS3);
        String string = this.ms.calculateStructuresAllExcept(bS3, bl, bl2, bl3, true, false);
        this.vwr.shm.resetBioshapes(bS2);
        this.ms.setStructureIndexes();
        return string;
    }

    public String calculateAllStructuresExcept(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string = "";
        BS bS2 = BSUtil.copyInvert((BS)bS, (int)this.ms.mc);
        if (bl4) {
            this.setAllDefaultStructure(bS2);
        }
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            if (this.ms.am[n].isBioModel) {
                string = string + ((BioModel)this.ms.am[n]).calculateStructures(bl, bl2, bl3, bl4, bl5);
            }
            n = bS2.nextSetBit(n + 1);
        }
        if (bl4) {
            this.ms.setStructureIndexes();
        }
        return string;
    }

    public void setAllDefaultStructure(BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.ms.am[n].isBioModel) {
                BioModel bioModel = (BioModel)this.ms.am[n];
                if (bioModel.defaultStructure == null) {
                    bioModel.defaultStructure = this.getFullProteinStructureState(bioModel.bsAtoms, 1073742158);
                }
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    public void setAllStructureList(Map<STR, float[]> map) {
        int n = this.ms.mc;
        while (--n >= 0) {
            if (!this.ms.am[n].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[n];
            bioModel.bioPolymers = (BioPolymer[])AU.arrayCopyObject((Object)bioModel.bioPolymers, (int)bioModel.bioPolymerCount);
            int n2 = bioModel.bioPolymerCount;
            while (--n2 >= 0) {
                BioPolymer bioPolymer = bioModel.bioPolymers[n2];
                if (!(bioPolymer instanceof AminoPolymer)) continue;
                ((AminoPolymer)bioPolymer).setStructureList(map);
            }
        }
    }

    public void setAllConformation(BS bS) {
        BS bS2 = this.ms.getModelBS(bS, false);
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            if (this.ms.am[n].isBioModel) {
                BioModel bioModel = (BioModel)this.ms.am[n];
                if (bioModel.altLocCount > 0) {
                    int n2 = bioModel.bioPolymerCount;
                    while (--n2 >= 0) {
                        bioModel.bioPolymers[n2].setConformation(bS);
                    }
                }
            }
            n = bS2.nextSetBit(n + 1);
        }
    }

    public void getAllPolymerPointsAndVectors(BS bS, Lst<P3[]> lst, boolean bl, float f) {
        for (int i = 0; i < this.ms.mc; ++i) {
            if (!this.ms.am[i].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[i];
            int n = 0x7FFFFFFE;
            for (int j = 0; j < bioModel.bioPolymerCount; ++j) {
                n = bioModel.bioPolymers[j].getPolymerPointsAndVectors(n, bS, lst, bl, f);
            }
        }
    }

    public void calcSelectedMonomersCount() {
        BS bS = this.vwr.bsA();
        int n = this.ms.mc;
        while (--n >= 0) {
            if (!this.ms.am[n].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[n];
            int n2 = bioModel.bioPolymerCount;
            while (--n2 >= 0) {
                bioModel.bioPolymers[n2].calcSelectedMonomersCount(bS);
            }
        }
    }

    public int getBioPolymerCountInModel(int n) {
        if (n < 0) {
            int n2 = 0;
            int n3 = this.ms.mc;
            while (--n3 >= 0) {
                if (this.ms.isTrajectorySubFrame(n3) || !this.ms.am[n3].isBioModel) continue;
                n2 += ((BioModel)this.ms.am[n3]).getBioPolymerCount();
            }
            return n2;
        }
        return this.ms.isTrajectorySubFrame(n) || !this.ms.am[n].isBioModel ? 0 : ((BioModel)this.ms.am[n]).getBioPolymerCount();
    }

    public void calculateAllPolymers(Group[] groupArray, int n, int n2, BS bS) {
        int n3;
        boolean bl;
        boolean bl2 = bl = !this.vwr.getBoolean(603979894);
        if (n < 0) {
            n = groupArray.length;
        }
        if (bS != null) {
            for (n3 = 0; n3 < n; ++n3) {
                Group group = groupArray[n3];
                if (!(group instanceof Monomer) || ((Monomer)group).bioPolymer == null || bS.get(group.chain.model.modelIndex)) continue;
                ((Monomer)group).setBioPolymer(null, -1);
            }
        }
        int n4 = this.ms.mc;
        for (n3 = 0; n3 < n4; ++n3) {
            if (bS != null && bS.get(n3) || !this.ms.am[n3].isBioModel) continue;
            for (int i = n2; i < n; ++i) {
                BioPolymer bioPolymer;
                Group group = groupArray[i];
                Model model = group.getModel();
                if (!model.isBioModel || !(group instanceof Monomer)) continue;
                boolean bl3 = bl && !this.ms.isJmolDataFrameForModel((int)this.ms.at[group.firstAtomIndex].mi);
                BioPolymer bioPolymer2 = bioPolymer = ((Monomer)group).bioPolymer == null ? Resolver.allocateBioPolymer(groupArray, i, bl3) : null;
                if (bioPolymer == null || bioPolymer.monomerCount == 0) continue;
                ((BioModel)model).addBioPolymer(bioPolymer);
                i += bioPolymer.monomerCount - 1;
            }
        }
    }

    public void recalculateAllPolymers(BS bS, Group[] groupArray) {
        for (int i = 0; i < this.ms.mc; ++i) {
            if (!this.ms.am[i].isBioModel || bS.get(i)) continue;
            ((BioModel)this.ms.am[i]).clearBioPolymers();
        }
        this.calculateAllPolymers(groupArray, -1, 0, bS);
    }

    public BS getGroupsWithinAll(int n, BS bS) {
        BS bS2 = new BS();
        BS bS3 = this.ms.getIterativeModels(false);
        int n2 = this.ms.mc;
        while (--n2 >= 0) {
            if (!bS3.get(n2) || !this.ms.am[n2].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[n2];
            int n3 = bioModel.bioPolymerCount;
            while (--n3 >= 0) {
                bioModel.bioPolymers[n3].getRangeGroups(n, bS, bS2);
            }
        }
        return bS2;
    }

    public int calculateStruts(BS bS, BS bS2) {
        return this.getBioExt().calculateAllstruts(this.vwr, this.ms, bS, bS2);
    }

    public void recalculatePoints(int n) {
        if (n < 0) {
            int n2 = this.ms.mc;
            while (--n2 >= 0) {
                if (this.ms.isTrajectorySubFrame(n2) || !this.ms.am[n2].isBioModel) continue;
                ((BioModel)this.ms.am[n2]).recalculateLeadMidpointsAndWingVectors();
            }
            return;
        }
        if (!this.ms.isTrajectorySubFrame(n) && this.ms.am[n].isBioModel) {
            ((BioModel)this.ms.am[n]).recalculateLeadMidpointsAndWingVectors();
        }
    }

    public String getFullProteinStructureState(BS bS, int n) {
        int n2;
        int n3;
        boolean bl;
        boolean bl2 = bl = n == 1073742327;
        if (bl && !this.ms.proteinStructureTainted) {
            return "";
        }
        boolean bl3 = n == 1073742158 || n == 1073742327;
        Atom[] atomArray = this.ms.at;
        int n4 = n3 = bS == null ? 0 : bS.nextSetBit(0);
        if (n3 < 0) {
            return "";
        }
        if (bS != null && n == 4138) {
            bS = BSUtil.copy((BS)bS);
            n2 = this.ms.ac;
            while (--n2 >= 0) {
                if (!Float.isNaN(atomArray[n2].group.getGroupParameter(1111490569)) && !Float.isNaN(atomArray[n2].group.getGroupParameter(1111490570))) continue;
                bS.clear(n2);
            }
        }
        n2 = (bS == null ? this.ms.ac : bS.length()) - 1;
        int n5 = atomArray[n3].mi;
        short s = atomArray[n2].mi;
        Lst lst = new Lst();
        Hashtable<ProteinStructure, Boolean> hashtable = new Hashtable<ProteinStructure, Boolean>();
        SB sB = new SB();
        for (int i = n5; i <= s; ++i) {
            if (!this.ms.am[i].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[i];
            if (bl && !bioModel.structureTainted) continue;
            BS bS2 = new BS();
            bS2.or(bioModel.bsAtoms);
            bS2.andNot(bioModel.bsAtomsDeleted);
            int n6 = bS2.nextSetBit(0);
            if (n6 < 0) continue;
            if (bl3) {
                sB.append("  structure none ").append(Escape.eBS((BS)this.ms.getModelAtomBitSetIncludingDeleted(i, false))).append("    \t# model=" + this.ms.getModelNumberDotted(i)).append(";\n");
            }
            int n7 = n6;
            while (n7 >= 0) {
                ProteinStructure proteinStructure;
                Atom atom = atomArray[n7];
                if (atom.group instanceof AlphaMonomer && (proteinStructure = ((AlphaMonomer)atom.group).proteinStructure) != null && !hashtable.containsKey(proteinStructure)) {
                    lst.addLast((Object)proteinStructure);
                    hashtable.put(proteinStructure, Boolean.TRUE);
                }
                n7 = bS2.nextSetBit(n7 + 1);
            }
        }
        this.getStructureLines(bS, sB, (Lst<ProteinStructure>)lst, STR.HELIX, bl3, n);
        this.getStructureLines(bS, sB, (Lst<ProteinStructure>)lst, STR.SHEET, bl3, n);
        this.getStructureLines(bS, sB, (Lst<ProteinStructure>)lst, STR.TURN, bl3, n);
        return sB.toString();
    }

    private int getStructureLines(BS bS, SB sB, Lst<ProteinStructure> lst, STR sTR, boolean bl, int n) {
        boolean bl2 = n == 134222350;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        BS bS2 = new BS();
        int n5 = 0;
        int n6 = lst.size();
        block12: for (int i = 0; i < n6; ++i) {
            ProteinStructure proteinStructure = (ProteinStructure)lst.get(i);
            if (proteinStructure.type != sTR) continue;
            Monomer monomer = proteinStructure.findMonomer(bS, true);
            Monomer monomer2 = proteinStructure.findMonomer(bS, false);
            if (monomer == null || monomer2 == null) continue;
            int n7 = proteinStructure.apolymer.model.modelIndex;
            String string2 = bl ? "    \t# model=" + this.ms.getModelNumberDotted(n7) : null;
            int n8 = monomer.getResno();
            int n9 = monomer2.getResno();
            STR sTR2 = proteinStructure.subtype;
            switch (sTR) {
                case HELIX: 
                case SHEET: 
                case TURN: {
                    String string3;
                    ++n5;
                    if (bl) {
                        bS2.clearAll();
                        proteinStructure.setAtomBits(bS2);
                        string3 = sTR2.getBioStructureTypeName(false);
                        sB.append("  structure ").append(string3).append(" ").append(Escape.eBS((BS)bS2)).append(string2).append(" & (" + n8 + " - " + n9 + ")").append(";\n");
                        continue block12;
                    }
                    switch (sTR) {
                        case HELIX: {
                            int n10 = ++n2;
                            string = PT.formatStringI((String)"%3N %3N", (String)"N", (int)n10);
                            string3 = "HELIX  %ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB";
                            String string4 = null;
                            switch (sTR2) {
                                case HELIX: 
                                case HELIXALPHA: {
                                    string4 = "  1";
                                    break;
                                }
                                case HELIX310: {
                                    string4 = "  5";
                                    break;
                                }
                                case HELIXPI: {
                                    string4 = "  3";
                                }
                            }
                            if (string4 == null) break;
                            string3 = string3 + string4;
                            break;
                        }
                        case SHEET: {
                            int n10 = ++n3;
                            string = PT.formatStringI((String)"%3N %3A 0", (String)"N", (int)n10);
                            string = PT.formatStringS((String)string, (String)"A", (String)("S" + n10));
                            string3 = "SHEET  %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                            break;
                        }
                        default: {
                            int n10 = ++n4;
                            string = PT.formatStringI((String)"%3N %3N", (String)"N", (int)n10);
                            string3 = "TURN   %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                        }
                    }
                    string3 = PT.formatStringS((String)string3, (String)"ID", (String)string);
                    string3 = PT.formatStringS((String)string3, (String)"GROUPA", (String)monomer.getGroup3());
                    string3 = PT.formatStringS((String)string3, (String)"CA", (String)monomer.getLeadAtom().getChainIDStr());
                    string3 = PT.formatStringI((String)string3, (String)"RESA", (int)n8);
                    string3 = PT.formatStringS((String)string3, (String)"GROUPB", (String)monomer2.getGroup3());
                    string3 = PT.formatStringS((String)string3, (String)"CB", (String)monomer2.getLeadAtom().getChainIDStr());
                    string3 = PT.formatStringI((String)string3, (String)"RESB", (int)n9);
                    sB.append(string3);
                    if (bl2) {
                        sB.append(" strucno= ").appendI(proteinStructure.strucNo);
                    }
                    sB.append("\n");
                }
            }
        }
        if (n5 > 0) {
            sB.append("\n");
        }
        return n5;
    }

    public BS getAllSequenceBits(String string, BS bS, BS bS2) {
        if (string.length() > 0) {
            if (bS == null) {
                bS = this.vwr.getAllAtoms();
            }
            if (string.indexOf(124) < string.lastIndexOf(124)) {
                return this.getAllUnitIds(string, bS, bS2);
            }
            Model[] modelArray = this.ms.am;
            int n = this.ms.mc;
            while (--n >= 0) {
                if (!modelArray[n].isBioModel) continue;
                BioModel bioModel = (BioModel)modelArray[n];
                int n2 = string.length();
                block1: for (int i = 0; i < bioModel.bioPolymerCount; ++i) {
                    String string2 = bioModel.bioPolymers[i].getSequence();
                    int n3 = -1;
                    while (true) {
                        ++n3;
                        if ((n3 = string2.indexOf(string, n3)) < 0) continue block1;
                        bioModel.bioPolymers[i].getPolymerSequenceAtoms(n3, n2, bS, bS2);
                    }
                }
            }
        }
        return bS2;
    }

    private BS getAllUnitIds(String string, BS bS, BS bS2) {
        Object object;
        Object object2;
        Map<String, BS>[] mapArray = this.unitIdSets;
        if (mapArray == null) {
            int n;
            mapArray = this.unitIdSets = new Map[7];
            for (n = 0; n < 7; ++n) {
                mapArray[n] = new Hashtable<String, BS>();
            }
            n = this.ms.mc;
            while (--n >= 0) {
                object2 = this.ms.am[n];
                if (!object2.isBioModel) continue;
                if (this.ms.isTrajectory(n)) {
                    n = object2.trajectoryBaseIndex;
                    object2 = this.ms.am[n];
                }
                object = "|" + this.ms.getInfo(n, "modelNumber");
                this.checkMap(mapArray[0], this.ms.getInfo(n, "modelName") + (String)object, object2.bsAtoms);
                this.checkMap(mapArray[0], (String)object, object2.bsAtoms);
            }
        }
        BS bS3 = null;
        object2 = null;
        object = new BS();
        String[] stringArray = PT.getTokens((String)PT.replaceAllCharacters((String)string, (String)", \t\n[]\"", (String)" "));
        int[] nArray = new int[8];
        int n = stringArray.length;
        while (--n >= 0) {
            String string2 = stringArray[n] + "|";
            if (string2.length() < 5) continue;
            int n2 = 0;
            int n3 = 0;
            int n4 = string2.lastIndexOf(124) + 1;
            for (int i = 0; i < n4 && n3 < 8; ++i) {
                if (string2.charAt(i) == '|') {
                    nArray[n3++] = i;
                    continue;
                }
                n2 |= 1 << n3;
            }
            if ((n2 & 0x16) != 22) continue;
            object.clearAll();
            object.or(bS);
            String string3 = string2.substring(0, nArray[2]);
            if (object2 != null && object2.equals(string3)) {
                object.or(bS3);
            } else {
                if (!this.addUnit(1094717454, string2.substring(0, nArray[1]).toUpperCase(), (BS)object, mapArray[0]) || !this.addUnit(1073742357, string2.substring(nArray[1] + 1, nArray[2]), (BS)object, mapArray[1])) continue;
                bS3 = BSUtil.copy((BS)object);
                object2 = string3;
            }
            n3 = (n2 & 0x20) != 0 ? 1 : 0;
            int n5 = n4 = (n2 & 0x40) != 0 ? 1 : 0;
            if (!this.addUnit(1094715412, string2.substring(nArray[3] + 1, nArray[4]), (BS)object, mapArray[2]) || !this.addUnit(5, (n2 & 0x80) == 0 ? "\u0000" : string2.substring(nArray[6] + 1, nArray[7]), (BS)object, mapArray[3]) || (n3 != 0 ? !this.addUnit(1086326786, string2.substring(nArray[4] + 1, nArray[5]).toUpperCase(), (BS)object, mapArray[4]) || !this.addUnit(1073742355, string2.substring(nArray[5] + 1, nArray[6]), (BS)object, mapArray[5]) : n4 != 0 && !this.addUnit(1094717448, string2.substring(nArray[5] + 1, nArray[6]), (BS)object, mapArray[6]))) continue;
            bS2.or(object);
        }
        return bS2;
    }

    private BS checkMap(Map<String, BS> map, String string, BS bS) {
        BS bS2 = BSUtil.copy((BS)bS);
        BS bS3 = map.get(string);
        if (bS3 == null) {
            bS3 = bS2;
            map.put(string, bS3);
        } else {
            bS3.or(bS2);
        }
        return bS3;
    }

    private boolean addUnit(int n, String string, BS bS, Map<String, BS> map) {
        BS bS2 = map.get(string);
        if (bS2 == null) {
            Object object;
            switch (n) {
                default: {
                    return false;
                }
                case 1073742357: {
                    object = this.vwr.getChainID(string, false);
                    break;
                }
                case 1094715412: {
                    object = PT.parseInt((String)string);
                    break;
                }
                case 5: {
                    object = (int)string.charAt(0);
                    break;
                }
                case 1094717448: {
                    n = 1073742355;
                    bS2 = this.ms.getAtomBitsMDa(1073742355, null, new BS());
                }
                case 1086326786: {
                    object = string;
                    break;
                }
                case 1073742355: {
                    object = string.length() == 0 ? null : string;
                }
            }
            bS2 = this.ms.getAtomBitsMDa(n, object, bS2 == null ? new BS() : bS2);
            map.put(string, bS2);
        }
        bS.and(bS2);
        return bS.nextSetBit(0) >= 0;
    }

    private BS getAllBasePairBits(String string) {
        BS bS = null;
        BS bS2 = null;
        Lst lst = new Lst();
        if (string.length() == 0) {
            bS = bS2 = this.vwr.getAllAtoms();
            this.calcAllRasmolHydrogenBonds(bS, bS2, (Lst<Bond>)lst, true, 1, false, null);
        } else {
            int n = 0;
            while (n < string.length()) {
                if ((bS = this.ms.getSequenceBits(string.substring(n++, n), null, new BS())).nextSetBit(0) < 0 || (bS2 = this.ms.getSequenceBits(string.substring(n++, n), null, new BS())).nextSetBit(0) < 0) continue;
                this.calcAllRasmolHydrogenBonds(bS, bS2, (Lst<Bond>)lst, true, 1, false, null);
            }
        }
        BS bS3 = new BS();
        int n = lst.size();
        while (--n >= 0) {
            Bond bond = (Bond)lst.get(n);
            bS3.set(bond.atom1.i);
            bS3.set(bond.atom2.i);
        }
        return bS3;
    }

    public void calcAllRasmolHydrogenBonds(BS bS, BS bS2, Lst<Bond> lst, boolean bl, int n, boolean bl2, BS bS3) {
        Model[] modelArray = this.ms.am;
        if (lst == null) {
            BS bS4 = bS;
            if (bS2 != null && !bS.equals((Object)bS2)) {
                bS4 = BSUtil.copy((BS)bS);
                bS4.or(bS2);
            }
            BS bS5 = new BS();
            BS bS6 = new BS();
            Model[] modelArray2 = this.ms.am;
            Bond[] bondArray = this.ms.bo;
            int n2 = this.ms.bondCount;
            while (--n2 >= 0) {
                Bond bond = bondArray[n2];
                if ((bond.order & 0x7000) == 0) continue;
                if (bS4.get(bond.atom1.i)) {
                    bS5.set(n2);
                    continue;
                }
                bS6.set(modelArray2[bond.atom1.mi].trajectoryBaseIndex);
            }
            n2 = this.ms.mc;
            while (--n2 >= 0) {
                if (!modelArray2[n2].isBioModel) continue;
                ((BioModel)modelArray2[n2]).hasRasmolHBonds = bS6.get(n2);
            }
            if (bS5.nextSetBit(0) >= 0) {
                this.ms.deleteBonds(bS5, false);
            }
        }
        int n3 = this.ms.mc;
        while (--n3 >= 0) {
            if (!modelArray[n3].isBioModel || this.ms.isTrajectorySubFrame(n3)) continue;
            ((BioModel)modelArray[n3]).getRasmolHydrogenBonds(bS, bS2, lst, bl, n, bl2, bS3);
        }
    }

    private void getRasmolHydrogenBonds(BS bS, BS bS2, Lst<Bond> lst, boolean bl, int n, boolean bl2, BS bS3) {
        int n2;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = lst == null;
        if (bl4) {
            lst = new Lst();
        }
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        boolean bl6 = bl3 = bS2 == null;
        if (bl3 && this.bioPolymerCount > 0) {
            this.calculateDssx((Lst<Bond>)lst, false, bl2, false);
        } else {
            n2 = this.bioPolymerCount;
            block4: while (--n2 >= 0) {
                BioPolymer bioPolymer = this.bioPolymers[n2];
                if (bioPolymer.monomerCount == 0) continue;
                int n3 = bioPolymer.getType();
                boolean bl7 = false;
                switch (n3) {
                    case 1: {
                        if (bl) continue block4;
                        bioPolymer.calcRasmolHydrogenBonds(null, bS, bS2, (Lst<Bond>)lst, n, null, true, false);
                        break;
                    }
                    case 2: {
                        bl7 = bioPolymer.monomers[0].isRna();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                int n4 = this.bioPolymerCount;
                while (--n4 >= 0) {
                    BioPolymer bioPolymer2 = this.bioPolymers[n4];
                    if (bioPolymer2 == null || !bl7 && n2 == n4 || n3 != bioPolymer2.getType()) continue;
                    bioPolymer2.calcRasmolHydrogenBonds(bioPolymer, bS, bS2, (Lst<Bond>)lst, n, null, true, false);
                }
            }
        }
        if (lst.size() == 0 || !bl4) {
            return;
        }
        this.hasRasmolHBonds = true;
        for (n2 = 0; n2 < lst.size(); ++n2) {
            HBond hBond = (HBond)lst.get(n2);
            Atom atom = hBond.atom1;
            Atom atom2 = hBond.atom2;
            if (atom.isBonded(atom2)) continue;
            int n5 = this.ms.addHBond(atom, atom2, hBond.order, hBond.getEnergy());
            if (bS3 == null) continue;
            bS3.set(n5);
        }
    }

    public void calculateStraightnessAll() {
        this.getBioExt().calculateStraightnessAll(this.vwr, this.ms);
    }

    public boolean mutate(BS bS, String string, String[] stringArray) {
        return this.getBioExt().mutate(this.vwr, bS, string, stringArray);
    }

    BioModel(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        this.vwr = modelSet.vwr;
        this.set(modelSet, n, n2, string, properties, map);
        this.isBioModel = true;
        modelSet.bioModelset = this;
        this.clearBioPolymers();
        modelSet.am[n] = this;
        this.pdbID = (String)map.get("name");
    }

    private void clearBioPolymers() {
        this.bioPolymers = new BioPolymer[8];
        this.bioPolymerCount = 0;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    public void fixIndices(int n, int n2, BS bS) {
        this.fixIndicesM(n, n2, bS);
        this.recalculateLeadMidpointsAndWingVectors();
        this.unitIdSets = null;
    }

    private void recalculateLeadMidpointsAndWingVectors() {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].recalculateLeadMidpointsAndWingVectors();
        }
    }

    public boolean freeze() {
        this.freezeM();
        this.bioPolymers = (BioPolymer[])AU.arrayCopyObject((Object)this.bioPolymers, (int)this.bioPolymerCount);
        return true;
    }

    public void addSecondaryStructure(STR sTR, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, BS bS) {
        int n9 = this.bioPolymerCount;
        while (--n9 >= 0) {
            if (!(this.bioPolymers[n9] instanceof AlphaPolymer)) continue;
            ((AlphaPolymer)this.bioPolymers[n9]).addStructure(sTR, string, n, n2, n3, n4, n5, n6, n7, n8, bS);
        }
    }

    private String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n;
        if (this.bioPolymerCount == 0 || !bl4 && !bl) {
            return "";
        }
        this.structureTainted = true;
        this.ms.proteinStructureTainted = true;
        if (bl4) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                if (bl && this.bioPolymers[n].monomers[0].getNitrogenAtom() == null) continue;
                this.bioPolymers[n].clearStructures();
            }
        }
        if (!bl || bl5) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                if (!(this.bioPolymers[n] instanceof AlphaPolymer)) continue;
                ((AlphaPolymer)this.bioPolymers[n]).calculateStructures(bl5);
            }
        }
        return bl ? this.calculateDssx(null, bl2, bl3, bl4) : "";
    }

    private String calculateDssx(Lst<Bond> lst, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; !(i >= this.bioPolymerCount || bl4 && bl5); ++i) {
            if (this.bioPolymers[i].isNucleic()) {
                bl5 = true;
                continue;
            }
            if (!(this.bioPolymers[i] instanceof AminoPolymer)) continue;
            bl4 = true;
        }
        String string = "";
        if (bl4) {
            string = string + ((DSSPInterface)Interface.getOption((String)"dssx.DSSP", (Viewer)this.vwr, (String)"ms")).calculateDssp((Object[])this.bioPolymers, this.bioPolymerCount, lst, bl, bl2, bl3);
        }
        if (bl5 && this.auxiliaryInfo.containsKey("dssr") && lst != null) {
            string = string + this.vwr.getAnnotationParser(true).getHBonds(this.ms, this.modelIndex, lst, bl);
        }
        return string;
    }

    public boolean getConformation(int n, boolean bl, BS bS, BS bS2) {
        int n2;
        if (n >= 0 && (n2 = this.altLocCount) > 0) {
            Atom[] atomArray = this.ms.at;
            Group group = null;
            char c = '\u0000';
            int n3 = n;
            BS bS3 = new BS();
            int n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                Atom atom = atomArray[n4];
                char c2 = atom.altloc;
                if (c2 != '\u0000') {
                    if (atom.group != group) {
                        group = atom.group;
                        c = '\u0000';
                        n3 = n;
                        bS3.clearAll();
                    }
                    if (n3 >= 0 && c2 != c && !bS3.get((int)c2)) {
                        c = c2;
                        --n3;
                        bS3.set((int)c2);
                    }
                    if (n3 >= 0 || c2 != c) {
                        bS.clear(n4);
                    }
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        if (bS.nextSetBit(0) >= 0) {
            bS2.or(bS);
            if (bl) {
                n2 = this.bioPolymerCount;
                while (--n2 >= 0) {
                    this.bioPolymers[n2].setConformation(bS);
                }
            }
        }
        return true;
    }

    private void addBioPolymer(BioPolymer bioPolymer) {
        if (this.bioPolymers.length == 0) {
            this.clearBioPolymers();
        }
        if (this.bioPolymerCount == this.bioPolymers.length) {
            this.bioPolymers = (BioPolymer[])AU.doubleLength((Object)this.bioPolymers);
        }
        bioPolymer.bioPolymerIndexInModel = this.bioPolymerCount;
        this.bioPolymers[this.bioPolymerCount++] = bioPolymer;
    }

    public Lst<BS> getBioBranches(Lst<BS> lst) {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            BS bS = new BS();
            this.bioPolymers[i].getRange(bS, this.isMutated);
            int n = bS.nextSetBit(0);
            if (n < 0) continue;
            if (lst == null) {
                lst = new Lst();
            }
            lst.addLast((Object)bS);
        }
        return lst;
    }

    public void getAllPolymerInfo(BS bS, Map<String, Lst<Map<String, Object>>> map) {
        this.getBioExt().getAllPolymerInfo(this.ms, bS, map);
    }

    private BioExt getBioExt() {
        return this.bx == null ? (this.bx = (BioExt)Interface.getInterface((String)"org.jmol.modelsetbio.BioExt", (Viewer)this.vwr, (String)"script")) : this.bx;
    }

    public String getFullPDBHeader() {
        if (this.modelIndex < 0) {
            return "";
        }
        String string = (String)this.auxiliaryInfo.get("fileHeader");
        if (string != null) {
            return string;
        }
        string = this.vwr.getCurrentFileAsString("biomodel");
        int n = string.length();
        int n2 = pdbRecords.length;
        block4: while (--n2 >= 0) {
            String string2 = pdbRecords[n2];
            int n3 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n3) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    this.auxiliaryInfo.put("fileHeader", "");
                    return "";
                }
            }
            if (n3 >= n) continue;
            n = ++n3;
        }
        string = string.substring(0, n);
        this.auxiliaryInfo.put("fileHeader", string);
        return string;
    }

    public void getPdbData(String string, char c, boolean bl, BS bS, OC oC, LabelToken[] labelTokenArray, SB sB, BS bS2) {
        this.getBioExt().getPdbDataM(this, this.vwr, string, c, bl, bS, oC, labelTokenArray, sB, bS2);
    }

    public void resetRasmolBonds(BS bS) {
        BS bS2 = new BS();
        this.hasRasmolHBonds = false;
        Model[] modelArray = this.ms.am;
        Bond[] bondArray = this.ms.bo;
        int n = this.ms.bondCount;
        while (--n >= 0) {
            Bond bond = bondArray[n];
            if ((bond.order & 0x7000) == 0 || modelArray[bond.atom1.mi].trajectoryBaseIndex != this.modelIndex) continue;
            bS2.set(n);
        }
        if (bS2.nextSetBit(0) >= 0) {
            this.ms.deleteBonds(bS2, false);
        }
        this.getRasmolHydrogenBonds(bS, bS, null, false, Integer.MAX_VALUE, false, null);
    }

    public void getDefaultLargePDBRendering(SB sB, int n) {
        BS bS = new BS();
        if (this.getBondCount() == 0) {
            bS = this.bsAtoms;
        }
        if (bS != this.bsAtoms) {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                this.bioPolymers[i].getRange(bS, this.isMutated);
            }
        }
        if (bS.nextSetBit(0) < 0) {
            return;
        }
        BS bS2 = new BS();
        if (bS == this.bsAtoms) {
            bS2 = bS;
        } else {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                if (this.bioPolymers[i].getType() != 0) continue;
                this.bioPolymers[i].getRange(bS2, this.isMutated);
            }
        }
        if (bS2.nextSetBit(0) >= 0) {
            sB.append("select ").append(Escape.eBS((BS)bS2)).append(";backbone only;");
        }
        if (this.act <= n) {
            return;
        }
        sB.append("select ").append(Escape.eBS((BS)bS)).append(" & connected; wireframe only;");
        if (bS != this.bsAtoms) {
            bS2.clearAll();
            bS2.or(this.bsAtoms);
            bS2.andNot(bS);
            if (bS2.nextSetBit(0) >= 0) {
                sB.append("select " + Escape.eBS((BS)bS2) + " & !connected;stars 0.5;spacefill off;");
            }
        }
    }

    public BS getAtomBitsStr(int n, String string, BS bS) {
        switch (n) {
            default: {
                return new BS();
            }
            case 1073741925: {
                return this.getAnnotationBits("domains", 1073741925, string);
            }
            case 1073742189: {
                return this.getAnnotationBits("validation", 1073742189, string);
            }
            case 1073742128: {
                return this.getAnnotationBits("rna3d", 1073742128, string);
            }
            case 1073741864: {
                String string2 = string;
                bS = new BS();
                return string2.length() % 2 != 0 ? bS : this.ms.getAtomBitsMDa(1086324742, (Object)this.getAllBasePairBits(string2), bS);
            }
            case 1073741916: {
                return this.getAnnotationBits("dssr", 1073741916, string);
            }
            case 1086324744: 
        }
        return this.getAllSequenceBits(string, null, bS);
    }

    public BS getAtomBitsBS(int n, BS bS, BS bS2) {
        Atom[] atomArray = this.ms.at;
        int n2 = this.ms.ac;
        int n3 = 0;
        switch (n) {
            case 0x200020: 
            case 136314895: {
                Group group;
                STR sTR = n == 136314895 ? STR.HELIX : STR.SHEET;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isWithinStructure(sTR)) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200024: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isCarbohydrate()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200004: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isDna()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x20000E: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isNucleic()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200010: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isProtein()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200012: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isPurine()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 2097172: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isPyrimidine()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 2097174: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isRna()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
        }
        if (n3 < 0) {
            return bS2;
        }
        int n4 = bS.nextSetBit(0);
        if (n4 < 0) {
            return bS2;
        }
        n3 = 0;
        switch (n) {
            case 1094713362: {
                n3 = n4;
                while (n3 >= 0) {
                    int n5 = atomArray[n3].group.getBioPolymerIndexInModel();
                    if (n5 >= 0) {
                        ((Monomer)atomArray[n3].group).bioPolymer.setAtomBitsAndClear(bS2, bS);
                    }
                    n3 = bS.nextSetBit(n3 + 1);
                }
                break;
            }
            case 1639976963: {
                n3 = n4;
                while (n3 >= 0) {
                    Structure structure = atomArray[n3].group.getStructure();
                    if (structure != null) {
                        structure.setAtomBitsAndClear(bS2, bS);
                    }
                    n3 = bS.nextSetBit(n3 + 1);
                }
                break;
            }
        }
        if (n3 == 0) {
            Logger.error((String)("MISSING getAtomBits entry for " + T.nameOf((int)n)));
        }
        return bS2;
    }

    private BS getAnnotationBits(String string, int n, String string2) {
        BS bS = new BS();
        JmolAnnotationParser jmolAnnotationParser = this.vwr.getAnnotationParser(string.equals("dssr"));
        int n2 = this.ms.mc;
        while (--n2 >= 0) {
            Object object = this.ms.getInfo(n2, string);
            if (object == null) continue;
            bS.or(jmolAnnotationParser.getAtomBits(this.vwr, string2, ((BioModel)this.ms.am[n2]).getCachedAnnotationMap(string + " V ", object), this.ms.am[n2].dssrCache, n, n2, this.ms.am[n2].bsAtoms));
        }
        return bS;
    }

    Object getCachedAnnotationMap(String string, Object object) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = this.dssrCache == null && object != null ? (this.dssrCache = new Hashtable()) : this.dssrCache;
        if (hashtable == null) {
            return null;
        }
        Object object2 = hashtable.get(string);
        if (object2 == null && object != null) {
            object2 = object instanceof SV || object instanceof Hashtable ? object : this.vwr.parseJSON((String)object);
            hashtable.put(string, object2);
        }
        return object2 instanceof SV || object2 instanceof Hashtable ? object2 : null;
    }

    public BS getIdentifierOrNull(String string) {
        int n;
        BS bS;
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && PT.isLetter((char)string.charAt(n2)); ++n2) {
        }
        BS bS2 = this.ms.getSpecNameOrNull(string.substring(0, n2), false);
        if (n2 == n3) {
            return bS2;
        }
        if (bS2 == null) {
            bS2 = new BS();
        }
        int n4 = n2;
        while (n2 < n3 && PT.isDigit((char)string.charAt(n2))) {
            ++n2;
        }
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string.substring(n4, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        char c = ' ';
        if (n2 < n3 && string.charAt(n2) == '^' && ++n2 < n3) {
            c = string.charAt(n2);
        }
        if ((bS = this.ms.getSeqcodeBits(n = Group.getSeqcodeFor((int)n5, (char)c), false)) == null) {
            if (c != ' ') {
                bS = this.ms.getSeqcodeBits((int)Character.toUpperCase(string.charAt(n2)), false);
            }
            if (bS == null) {
                return null;
            }
            ++n2;
        }
        bS2.and(bS);
        if (n2 >= n3) {
            return bS2;
        }
        if (n2 != n3 - 1) {
            return null;
        }
        bS2.and(this.ms.getChainBits((int)string.charAt(n2)));
        return bS2;
    }

    public String getUnitID(Atom atom, int n) {
        boolean bl;
        SB sB = new SB();
        Group group = atom.group;
        boolean bl2 = (n & 0x10) != 16;
        char c = (n & 8) == 8 ? group.getInsertionCode() : (char)'\u0000';
        boolean bl3 = bl = c != '\u0000';
        if ((n & 1) == 1 && this.pdbID != null) {
            sB.append(this.pdbID);
        }
        sB.append("|").appendO(this.ms.getInfo(this.modelIndex, "modelNumber")).append("|").append(this.vwr.getChainIDStr(group.chain.chainID)).append("|").append(group.getGroup3()).append("|").appendI(group.getResno());
        if ((n & 4) == 4) {
            sB.append("|").append(atom.getAtomName());
            if (atom.altloc != '\u0000') {
                sB.append("|").appendC(atom.altloc);
            } else if (bl2 || bl) {
                sB.append("|");
            }
        } else if (bl2 || bl) {
            sB.append("||");
        }
        if (bl) {
            sB.append("|").appendC(c);
        } else if (bl2) {
            sB.append("|");
        }
        if (bl2) {
            sB.append("|");
        }
        return sB.toString();
    }
}

