/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.util.ArrayList;
import java.util.Arrays;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.RegexValidator;

public class InetAddressValidator
extends AbstractValidator {
    private static final int IPV4_MAX_OCTET_VALUE = 255;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int BASE_16 = 16;
    private static final String IPV4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
    private static final int IPV6_MAX_HEX_GROUPS = 8;
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    private static final InetAddressValidator VALIDATOR = new InetAddressValidator();
    private final RegexValidator ipv4Validator = new RegexValidator("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");

    public static InetAddressValidator getInstance() {
        return VALIDATOR;
    }

    @Override
    public boolean isValid(String string) {
        return this.isValidInet4Address(string) || this.isValidInet6Address(string);
    }

    public boolean isValidInet4Address(String string) {
        String[] stringArray = this.ipv4Validator.match(string);
        if (stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (string2 == null || string2.isEmpty()) {
                return false;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n > 255) {
                return false;
            }
            if (string2.length() <= 1 || !string2.startsWith("0")) continue;
            return false;
        }
        return true;
    }

    public boolean isValidInet6Address(String string) {
        boolean bl = string.contains("::");
        if (bl && string.indexOf("::") != string.lastIndexOf("::")) {
            return false;
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(":") && !string.endsWith("::")) {
            return false;
        }
        String[] stringArray = string.split(":");
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            if (string.endsWith("::")) {
                arrayList.add("");
            } else if (string.startsWith("::") && !arrayList.isEmpty()) {
                arrayList.remove(0);
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        if (stringArray.length > 8) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) {
                if (++n2 > 1) {
                    return false;
                }
            } else {
                n2 = 0;
                if (string2.contains(".")) {
                    if (!string.endsWith(string2)) {
                        return false;
                    }
                    if (i > stringArray.length - 1 || i > 6) {
                        return false;
                    }
                    if (!this.isValidInet4Address(string2)) {
                        return false;
                    }
                    n += 2;
                    continue;
                }
                if (string2.length() > 4) {
                    return false;
                }
                int n3 = 0;
                try {
                    n3 = Integer.valueOf(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (n3 < 0 || n3 > 65535) {
                    return false;
                }
            }
            ++n;
        }
        return n >= 8 || bl;
    }
}

