/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.net.IDN;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.EmailValidator;
import org.openstreetmap.josm.data.validation.routines.UrlValidator;
import org.openstreetmap.josm.tools.I18n;

public class InternetTags
extends Test {
    public static final int INVALID_URL = 3301;
    public static final int INVALID_EMAIL = 3302;
    private static final Pattern ASCII_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static String[] URL_KEYS = new String[]{"url", "source:url", "website", "contact:website", "heritage:website", "source:website"};
    private static String[] EMAIL_KEYS = new String[]{"email", "contact:email"};

    public InternetTags() {
        super(I18n.tr("Internet tags", new Object[0]), I18n.tr("Checks for errors in internet-related tags.", new Object[0]));
    }

    private boolean doTest(OsmPrimitive osmPrimitive, String string, String[] stringArray, AbstractValidator abstractValidator, int n) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            TestError testError = this.validateTag(osmPrimitive, string, abstractValidator, n);
            if (testError == null) break;
            this.errors.add(testError);
            break;
        }
        return false;
    }

    public TestError validateTag(OsmPrimitive osmPrimitive, String string, AbstractValidator abstractValidator, int n) {
        String string2;
        TestError testError = this.doValidateTag(osmPrimitive, string, null, abstractValidator, n);
        if (testError != null && !ASCII_PATTERN.matcher(string2 = osmPrimitive.get(string)).matches()) {
            try {
                String string3 = "";
                if (string2.contains("://")) {
                    string3 = string2.substring(0, string2.indexOf("://") + 3);
                }
                String string4 = !string3.isEmpty() ? string2.substring(string3.length(), string2.length()) : string2;
                String string5 = "";
                if (string4.contains("/")) {
                    int n2 = string4.indexOf(47);
                    string5 = string4.substring(n2, string4.length());
                    string4 = string4.substring(0, n2);
                }
                testError = this.doValidateTag(osmPrimitive, string, string3 + IDN.toASCII(string4) + string5, abstractValidator, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                testError.setMessage(testError.getMessage() + I18n.tr(" URL cannot be converted to ASCII: {0}", illegalArgumentException.getMessage()));
            }
        }
        return testError;
    }

    private TestError doValidateTag(OsmPrimitive osmPrimitive, String string, String string2, AbstractValidator abstractValidator, int n) {
        String string3;
        TestError testError = null;
        String string4 = string3 = string2 != null ? string2 : osmPrimitive.get(string);
        if (!abstractValidator.isValid(string3)) {
            String string5 = abstractValidator.getErrorMessage();
            if (I18n.tr("URL contains an invalid protocol: {0}", new Object[]{null}).equals(string5)) {
                String string6 = abstractValidator instanceof EmailValidator ? "mailto://" : "http://";
                return this.doValidateTag(osmPrimitive, string, string6 + string3, abstractValidator, n);
            }
            String string7 = I18n.tr("''{0}'': {1}", string, string5);
            testError = new TestError((Test)this, Severity.WARNING, string7, n, osmPrimitive);
        }
        return testError;
    }

    private void test(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            if (this.doTest(osmPrimitive, string, URL_KEYS, UrlValidator.getInstance(), 3301)) continue;
            this.doTest(osmPrimitive, string, EMAIL_KEYS, EmailValidator.getInstance(), 3302);
        }
    }

    @Override
    public void visit(Node node) {
        this.test(node);
    }

    @Override
    public void visit(Way way) {
        this.test(way);
    }

    @Override
    public void visit(Relation relation) {
        this.test(relation);
    }
}

