/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;

public class WMTSLayer
extends AbstractCachedTileSourceLayer<WMTSTileSource>
implements NativeScaleLayer {
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.wmts.default_autozoom", true);
    private static final String CACHE_REGION_NAME = "WMTS";

    public WMTSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
    }

    @Override
    protected WMTSTileSource getTileSource(ImageryInfo imageryInfo) {
        try {
            if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.WMTS && imageryInfo.getUrl() != null) {
                WMTSTileSource.checkUrl(imageryInfo.getUrl());
                WMTSTileSource wMTSTileSource = new WMTSTileSource(imageryInfo);
                imageryInfo.setAttribution(wMTSTileSource);
                return wMTSTileSource;
            }
            return null;
        }
        catch (IOException iOException) {
            Main.warn(iOException);
            throw new IllegalArgumentException(iOException);
        }
    }

    @Override
    protected int getBestZoom() {
        if (!Main.isDisplayingMapView()) {
            return 0;
        }
        return Math.max(this.getMinZoomLvl(), Math.min(this.getNativeScales().getSnapScale(Main.map.mapView.getScale(), false).getIndex(), this.getMaxZoomLvl()));
    }

    @Override
    protected int getMinZoomLvl() {
        return 0;
    }

    @Override
    public boolean isProjectionSupported(Projection projection) {
        Set<String> set = ((WMTSTileSource)this.tileSource).getSupportedProjections();
        return set.contains(projection.toCode());
    }

    @Override
    public String nameSupportedProjections() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : ((WMTSTileSource)this.tileSource).getSupportedProjections()) {
            stringBuilder.append(string).append(", ");
        }
        return stringBuilder.length() > 2 ? stringBuilder.substring(0, stringBuilder.length() - 2) : stringBuilder.toString();
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        super.projectionChanged(projection, projection2);
        ((WMTSTileSource)this.tileSource).initProjection(projection2);
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return WMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }

    @Override
    public NativeScaleLayer.ScaleList getNativeScales() {
        return ((WMTSTileSource)this.tileSource).getNativeScales();
    }
}

