/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.preferences.ListSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AbstractListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class ListEditor
extends AbstractListEditor<String> {
    private final List<String> data;

    public ListEditor(JComponent jComponent, PrefEntry prefEntry, ListSetting listSetting) {
        super((Component)jComponent, I18n.tr("Change list setting", new Object[0]), prefEntry);
        List list = (List)listSetting.getValue();
        this.data = list != null ? new ArrayList<String>(list) : new ArrayList<String>();
        this.setContent(this.build(), false);
    }

    @Override
    public List<String> getData() {
        return new ArrayList<String>(Utils.filter(this.data, new Predicate<String>(){

            @Override
            public boolean evaluate(String string) {
                return string != null && !string.isEmpty();
            }
        }));
    }

    @Override
    protected final JPanel build() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.eol().insets(0, 0, 5, 0));
        ListSettingTableModel listSettingTableModel = new ListSettingTableModel();
        JTable jTable = new JTable(listSettingTableModel);
        jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        jTable.setTableHeader(null);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JosmTextField());
        defaultCellEditor.setClickCountToStart(1);
        jTable.setDefaultEditor(jTable.getColumnClass(0), defaultCellEditor);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, GBC.eol().insets(5, 10, 0, 0).fill());
        return jPanel;
    }

    class ListSettingTableModel
    extends AbstractTableModel {
        ListSettingTableModel() {
        }

        public List<String> getData() {
            return ListEditor.this.data;
        }

        @Override
        public int getRowCount() {
            return ListEditor.this.data.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ListEditor.this.data.size() == n ? "" : (String)ListEditor.this.data.get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n == ListEditor.this.data.size()) {
                ListEditor.this.data.add(string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                ListEditor.this.data.set(n, string);
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

