/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.interop.Execute;
import com.oracle.truffle.api.interop.ForeignObjectAccessHeadNode;
import com.oracle.truffle.api.interop.GetSize;
import com.oracle.truffle.api.interop.HasSize;
import com.oracle.truffle.api.interop.IsBoxed;
import com.oracle.truffle.api.interop.IsExecutable;
import com.oracle.truffle.api.interop.IsNull;
import com.oracle.truffle.api.interop.Read;
import com.oracle.truffle.api.interop.Unbox;
import com.oracle.truffle.api.interop.Write;
import com.oracle.truffle.api.nodes.Node;

public abstract class Message {
    public static final Message READ = Read.INSTANCE;
    public static final Message UNBOX = Unbox.INSTANCE;
    public static Message WRITE = Write.INSTANCE;
    public static final Message IS_EXECUTABLE = IsExecutable.INSTANCE;
    public static final Message IS_NULL = IsNull.INSTANCE;
    public static final Message HAS_SIZE = HasSize.INSTANCE;
    public static final Message GET_SIZE = GetSize.INSTANCE;
    public static final Message IS_BOXED = IsBoxed.INSTANCE;

    protected Message() {
    }

    public static Message createExecute(int argumentsLength) {
        return Execute.create(423430, argumentsLength);
    }

    public static Message createInvoke(int argumentsLength) {
        return Execute.create(423429, argumentsLength);
    }

    public static Message createNew(int argumentsLength) {
        return Execute.create(423428, argumentsLength);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public final Node createNode() {
        return new ForeignObjectAccessHeadNode(this);
    }

    public static String toString(Message message) {
        if (READ == message) {
            return "READ";
        }
        if (WRITE == message) {
            return "WRITE";
        }
        if (UNBOX == message) {
            return "UNBOX";
        }
        if (GET_SIZE == message) {
            return "GET_SIZE";
        }
        if (HAS_SIZE == message) {
            return "HAS_SIZE";
        }
        if (IS_NULL == message) {
            return "IS_NULL";
        }
        if (IS_BOXED == message) {
            return "IS_BOXED";
        }
        if (IS_EXECUTABLE == message) {
            return "IS_EXECUTABLE";
        }
        if (message instanceof Execute) {
            return ((Execute)message).name();
        }
        return message.getClass().getName();
    }

    public static Message valueOf(String message) {
        try {
            return (Message)Message.class.getField(message).get(null);
        }
        catch (Exception ex) {
            try {
                String factory = "create" + message.charAt(0) + message.substring(1).toLowerCase();
                return (Message)Message.class.getMethod(factory, Integer.TYPE).invoke(null, 0);
            }
            catch (Exception ex2) {
                try {
                    ClassLoader l = Message.class.getClassLoader();
                    if (l == null) {
                        l = ClassLoader.getSystemClassLoader();
                    }
                    return (Message)Class.forName(message, false, l).newInstance();
                }
                catch (Exception ex1) {
                    throw new IllegalArgumentException("Cannot find message for " + message, ex);
                }
            }
        }
    }
}

