/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.ArgumentsMishmashException;

final class SymbolInvokerImpl {
    SymbolInvokerImpl() {
    }

    static CallTarget createCallTarget(TruffleLanguage<?> lang, Object symbol, Object ... arr) {
        RootNode symbolNode;
        Class type = lang != null ? lang.getClass() : TruffleLanguage.class;
        if (symbol instanceof String || symbol instanceof Number || symbol instanceof Boolean || symbol instanceof Character) {
            symbolNode = RootNode.createConstantNode(symbol);
        } else {
            Node executeMain = Message.createExecute(arr.length).createNode();
            symbolNode = SymbolInvokerImpl.createTemporaryRoot(type, executeMain, (TruffleObject)symbol, arr.length);
        }
        return Truffle.getRuntime().createCallTarget(symbolNode);
    }

    public static RootNode createTemporaryRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess, TruffleObject function, int argumentLength) {
        return new TemporaryRoot(lang, foreignAccess, function, argumentLength);
    }

    private static final class ConvertNode
    extends Node {
        @Node.Child
        private Node isNull = Message.IS_NULL.createNode();
        @Node.Child
        private Node isBoxed = Message.IS_BOXED.createNode();
        @Node.Child
        private Node unbox = Message.UNBOX.createNode();

        Object convert(VirtualFrame frame, Object obj) {
            if (obj instanceof TruffleObject) {
                return this.convert(frame, (TruffleObject)obj);
            }
            return obj;
        }

        private Object convert(VirtualFrame frame, TruffleObject obj) {
            Object isBoxedResult;
            try {
                isBoxedResult = ForeignAccess.execute(this.isBoxed, frame, obj, new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                isBoxedResult = false;
            }
            if (Boolean.TRUE.equals(isBoxedResult)) {
                return ForeignAccess.execute(this.unbox, frame, obj, new Object[0]);
            }
            try {
                Object isNullResult = ForeignAccess.execute(this.isNull, frame, obj, new Object[0]);
                if (Boolean.TRUE.equals(isNullResult)) {
                    return null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return obj;
        }
    }

    static class TemporaryRoot
    extends RootNode {
        @Node.Child
        private Node foreignAccess;
        @Node.Child
        private ConvertNode convert;
        private final int argumentLength;
        private final TruffleObject function;

        public TemporaryRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess, TruffleObject function, int argumentLength) {
            super(lang, null, null);
            this.foreignAccess = foreignAccess;
            this.convert = new ConvertNode();
            this.function = function;
            this.argumentLength = argumentLength;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] args = frame.getArguments();
            if (args.length != this.argumentLength) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new ArgumentsMishmashException();
            }
            Object tmp = ForeignAccess.execute(this.foreignAccess, frame, this.function, args);
            return this.convert.convert(frame, tmp);
        }
    }
}

