/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.runtime.exceptions.OutsideOfStringException;
import org.jruby.truffle.runtime.RubyContext;

public class BackUnpackNode
extends PackNode {
    private boolean star;

    public BackUnpackNode(RubyContext context, boolean star) {
        super(context);
        this.star = star;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int position = this.getSourcePosition(frame);
        if (this.star) {
            int remaining = this.getSourceLength(frame) - position;
            int target = position - remaining;
            if (target < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new OutsideOfStringException();
            }
            this.setSourcePosition(frame, target);
        } else {
            if (position == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new OutsideOfStringException();
            }
            this.setSourcePosition(frame, position - 1);
        }
        return null;
    }
}

