/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.ObjectSpaceNodes;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.object.ObjectIDOperations;

@GeneratedBy(value=ObjectSpaceNodes.class)
public final class ObjectSpaceNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(ID2RefNodeFactory.getInstance(), EachObjectNodeFactory.getInstance(), DefineFinalizerNodeFactory.getInstance(), UndefineFinalizerNodeFactory.getInstance());
    }

    @GeneratedBy(value=ObjectSpaceNodes.UndefineFinalizerNode.class)
    public static final class UndefineFinalizerNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.UndefineFinalizerNode> {
        private static UndefineFinalizerNodeFactory undefineFinalizerNodeFactoryInstance;

        private UndefineFinalizerNodeFactory() {
            super(ObjectSpaceNodes.UndefineFinalizerNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ObjectSpaceNodes.UndefineFinalizerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UndefineFinalizerNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.UndefineFinalizerNode> getInstance() {
            if (undefineFinalizerNodeFactoryInstance == null) {
                undefineFinalizerNodeFactoryInstance = new UndefineFinalizerNodeFactory();
            }
            return undefineFinalizerNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.UndefineFinalizerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UndefineFinalizerNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.UndefineFinalizerNode.class)
        public static final class UndefineFinalizerNodeGen
        extends ObjectSpaceNodes.UndefineFinalizerNode {
            @Node.Child
            private RubyNode arguments0_;

            private UndefineFinalizerNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.undefineFinalizer(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
    public static final class DefineFinalizerNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.DefineFinalizerNode> {
        private static DefineFinalizerNodeFactory defineFinalizerNodeFactoryInstance;

        private DefineFinalizerNodeFactory() {
            super(ObjectSpaceNodes.DefineFinalizerNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ObjectSpaceNodes.DefineFinalizerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefineFinalizerNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.DefineFinalizerNode> getInstance() {
            if (defineFinalizerNodeFactoryInstance == null) {
                defineFinalizerNodeFactoryInstance = new DefineFinalizerNodeFactory();
            }
            return defineFinalizerNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.DefineFinalizerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DefineFinalizerNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
        public static final class DefineFinalizerNodeGen
        extends ObjectSpaceNodes.DefineFinalizerNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DefineFinalizerNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.defineFinalizer(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
    public static final class EachObjectNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.EachObjectNode> {
        private static EachObjectNodeFactory eachObjectNodeFactoryInstance;

        private EachObjectNodeFactory() {
            super(ObjectSpaceNodes.EachObjectNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ObjectSpaceNodes.EachObjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachObjectNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.EachObjectNode> getInstance() {
            if (eachObjectNodeFactoryInstance == null) {
                eachObjectNodeFactoryInstance = new EachObjectNodeFactory();
            }
            return eachObjectNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.EachObjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachObjectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
        public static final class EachObjectNodeGen
        extends ObjectSpaceNodes.EachObjectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachObjectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="eachObject(VirtualFrame, DynamicObject, DynamicObject)", value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class EachObject1Node_
            extends BaseNode_ {
                EachObject1Node_(EachObjectNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyModule(arguments0Value_)) {
                        return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments0Value_)) {
                            return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new EachObject1Node_(root);
                }
            }

            @GeneratedBy(methodName="eachObject(VirtualFrame, NotProvided, DynamicObject)", value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class EachObject0Node_
            extends BaseNode_ {
                EachObject0Node_(EachObjectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof NotProvided && arguments1Value instanceof DynamicObject) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new EachObject0Node_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachObjectNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachObjectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EachObjectNodeGen root;

                BaseNode_(EachObjectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EachObjectNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_;
                        if (arguments0Value instanceof NotProvided) {
                            return EachObject0Node_.create(this.root);
                        }
                        if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyModule(arguments0Value_ = (DynamicObject)arguments0Value)) {
                            return EachObject1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
    public static final class ID2RefNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.ID2RefNode> {
        private static ID2RefNodeFactory iD2RefNodeFactoryInstance;

        private ID2RefNodeFactory() {
            super(ObjectSpaceNodes.ID2RefNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ObjectSpaceNodes.ID2RefNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ID2RefNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.ID2RefNode> getInstance() {
            if (iD2RefNodeFactoryInstance == null) {
                iD2RefNodeFactoryInstance = new ID2RefNodeFactory();
            }
            return iD2RefNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.ID2RefNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ID2RefNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class ID2RefNodeGen
        extends ObjectSpaceNodes.ID2RefNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ID2RefNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="id2RefFloat(DynamicObject)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefFloatNode_
            extends BaseNode_ {
                Id2RefFloatNode_(ID2RefNodeGen root) {
                    super(root, 7);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && this.root.isFloatID(arguments0Value_)) {
                        return this.root.id2RefFloat(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value) && this.root.isFloatID(arguments0Value_)) {
                        return this.root.id2RefFloat(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new Id2RefFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="id2RefLargeFixnum(DynamicObject)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefLargeFixnumNode_
            extends BaseNode_ {
                Id2RefLargeFixnumNode_(ID2RefNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value) && this.root.isLargeFixnumID(arguments0Value_)) {
                        return this.root.id2RefLargeFixnum(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new Id2RefLargeFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="id2Ref(long, ReadHeadObjectFieldNode)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefNode_
            extends BaseNode_ {
                @Node.Child
                private ReadHeadObjectFieldNode readObjectIdNode;
                private final Class<?> arguments0ImplicitType;

                Id2RefNode_(ID2RefNodeGen root, Object arguments0Value, ReadHeadObjectFieldNode readObjectIdNode) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.readObjectIdNode = readObjectIdNode;
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (ObjectIDOperations.isBasicObjectID(arguments0Value_)) {
                        return this.root.id2Ref(arguments0Value_, this.readObjectIdNode);
                    }
                    return ID2RefNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && ObjectIDOperations.isBasicObjectID(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.id2Ref(arguments0Value_, this.readObjectIdNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value, ReadHeadObjectFieldNode readObjectIdNode) {
                    return new Id2RefNode_(root, arguments0Value, readObjectIdNode);
                }
            }

            @GeneratedBy(methodName="id2RefSmallInt(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefSmallIntNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefSmallIntNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefSmallIntNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (ObjectIDOperations.isSmallFixnumID(arguments0Value_)) {
                        return this.root.id2RefSmallInt(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && ObjectIDOperations.isSmallFixnumID(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.id2RefSmallInt(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefSmallIntNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="id2RefFalse(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefFalseNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefFalseNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefFalseNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ == 0L) {
                        return this.root.id2RefFalse(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) == 0L) {
                        return this.root.id2RefFalse(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefFalseNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="id2RefTrue(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefTrueNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefTrueNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefTrueNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ == 2L) {
                        return this.root.id2RefTrue(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) == 2L) {
                        return this.root.id2RefTrue(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefTrueNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="id2RefNil(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefNilNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefNilNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefNilNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    if (arguments0Value_ == 4L) {
                        return this.root.id2RefNil(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) == 4L) {
                        return this.root.id2RefNil(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefNilNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ID2RefNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ID2RefNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ID2RefNodeGen root;

                BaseNode_(ID2RefNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ID2RefNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectBoolean(this.execute(frameValue));
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectDouble(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments0Value_ == 4L) {
                            return Id2RefNilNode_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value_ == 2L) {
                            return Id2RefTrueNode_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value_ == 0L) {
                            return Id2RefFalseNode_.create(this.root, arguments0Value);
                        }
                        if (ObjectIDOperations.isSmallFixnumID(arguments0Value_)) {
                            return Id2RefSmallIntNode_.create(this.root, arguments0Value);
                        }
                        if (ObjectIDOperations.isBasicObjectID(arguments0Value_)) {
                            ReadHeadObjectFieldNode readObjectIdNode5 = this.root.createReadObjectIDNode();
                            return Id2RefNode_.create(this.root, arguments0Value, readObjectIdNode5);
                        }
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && this.root.isLargeFixnumID(arguments0Value_)) {
                            return Id2RefLargeFixnumNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyBignum(arguments0Value_) && this.root.isFloatID(arguments0Value_)) {
                            return Id2RefFloatNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }
            }
        }
    }
}

