/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jcodings.transcode.EConv;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.EncodingConverterLayout;

public class EncodingConverterLayoutImpl
extends BasicObjectLayoutImpl
implements EncodingConverterLayout {
    public static final EncodingConverterLayout INSTANCE = new EncodingConverterLayoutImpl();
    protected static final Shape.Allocator ENCODING_CONVERTER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ECONV_IDENTIFIER = new HiddenKey("econv");
    protected static final Property ECONV_PROPERTY = Property.create(ECONV_IDENTIFIER, ENCODING_CONVERTER_ALLOCATOR.locationForType(EConv.class), 0);

    protected EncodingConverterLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createEncodingConverterShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new EncodingConverterType(logicalClass, metaClass)).addProperty(ECONV_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createEncodingConverter(DynamicObjectFactory factory, EConv econv) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsEncodingConverter(factory));
        assert (factory.getShape().hasProperty(ECONV_IDENTIFIER));
        return factory.newInstance(econv);
    }

    @Override
    public boolean isEncodingConverter(DynamicObject object) {
        return this.isEncodingConverter(object.getShape().getObjectType());
    }

    private boolean isEncodingConverter(ObjectType objectType) {
        return objectType instanceof EncodingConverterType;
    }

    private boolean createsEncodingConverter(DynamicObjectFactory factory) {
        return this.isEncodingConverter(factory.getShape().getObjectType());
    }

    @Override
    public EConv getEconv(DynamicObject object) {
        assert (this.isEncodingConverter(object));
        assert (object.getShape().hasProperty(ECONV_IDENTIFIER));
        return (EConv)ECONV_PROPERTY.get(object, true);
    }

    @Override
    public void setEconv(DynamicObject object, EConv value) {
        assert (this.isEncodingConverter(object));
        assert (object.getShape().hasProperty(ECONV_IDENTIFIER));
        try {
            ECONV_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class EncodingConverterType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public EncodingConverterType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public EncodingConverterType setLogicalClass(DynamicObject logicalClass) {
            return new EncodingConverterType(logicalClass, this.metaClass);
        }

        @Override
        public EncodingConverterType setMetaClass(DynamicObject metaClass) {
            return new EncodingConverterType(this.logicalClass, metaClass);
        }
    }
}

