/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.ext.psych;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ext.psych.EmitterLayout;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;

public class EmitterLayoutImpl
extends BasicObjectLayoutImpl
implements EmitterLayout {
    public static final EmitterLayout INSTANCE = new EmitterLayoutImpl();
    protected static final Shape.Allocator EMITTER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey EMITTER_IDENTIFIER = new HiddenKey("emitter");
    protected static final Property EMITTER_PROPERTY = Property.create(EMITTER_IDENTIFIER, EMITTER_ALLOCATOR.locationForType(Emitter.class), 0);
    protected static final HiddenKey OPTIONS_IDENTIFIER = new HiddenKey("options");
    protected static final Property OPTIONS_PROPERTY = Property.create(OPTIONS_IDENTIFIER, EMITTER_ALLOCATOR.locationForType(DumperOptions.class), 0);
    protected static final HiddenKey IO_IDENTIFIER = new HiddenKey("io");
    protected static final Property IO_PROPERTY = Property.create(IO_IDENTIFIER, EMITTER_ALLOCATOR.locationForType(Object.class), 0);

    protected EmitterLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createEmitterShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new EmitterType(logicalClass, metaClass)).addProperty(EMITTER_PROPERTY).addProperty(OPTIONS_PROPERTY).addProperty(IO_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createEmitter(DynamicObjectFactory factory, Emitter emitter, DumperOptions options, Object io) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsEmitter(factory));
        assert (factory.getShape().hasProperty(EMITTER_IDENTIFIER));
        assert (factory.getShape().hasProperty(OPTIONS_IDENTIFIER));
        assert (factory.getShape().hasProperty(IO_IDENTIFIER));
        return factory.newInstance(emitter, options, io);
    }

    @Override
    public boolean isEmitter(DynamicObject object) {
        return this.isEmitter(object.getShape().getObjectType());
    }

    private boolean isEmitter(ObjectType objectType) {
        return objectType instanceof EmitterType;
    }

    private boolean createsEmitter(DynamicObjectFactory factory) {
        return this.isEmitter(factory.getShape().getObjectType());
    }

    @Override
    public Emitter getEmitter(DynamicObject object) {
        assert (this.isEmitter(object));
        assert (object.getShape().hasProperty(EMITTER_IDENTIFIER));
        return (Emitter)EMITTER_PROPERTY.get(object, true);
    }

    @Override
    public void setEmitter(DynamicObject object, Emitter value) {
        assert (this.isEmitter(object));
        assert (object.getShape().hasProperty(EMITTER_IDENTIFIER));
        try {
            EMITTER_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public DumperOptions getOptions(DynamicObject object) {
        assert (this.isEmitter(object));
        assert (object.getShape().hasProperty(OPTIONS_IDENTIFIER));
        return (DumperOptions)OPTIONS_PROPERTY.get(object, true);
    }

    @Override
    public void setOptions(DynamicObject object, DumperOptions value) {
        assert (this.isEmitter(object));
        assert (object.getShape().hasProperty(OPTIONS_IDENTIFIER));
        try {
            OPTIONS_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Object getIo(DynamicObject object) {
        assert (this.isEmitter(object));
        assert (object.getShape().hasProperty(IO_IDENTIFIER));
        return IO_PROPERTY.get(object, true);
    }

    @Override
    public void setIo(DynamicObject object, Object value) {
        assert (this.isEmitter(object));
        assert (object.getShape().hasProperty(IO_IDENTIFIER));
        try {
            IO_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class EmitterType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public EmitterType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public EmitterType setLogicalClass(DynamicObject logicalClass) {
            return new EmitterType(logicalClass, this.metaClass);
        }

        @Override
        public EmitterType setMetaClass(DynamicObject metaClass) {
            return new EmitterType(this.logicalClass, metaClass);
        }
    }
}

