/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import java.awt.Component;
import java.awt.Point;

public class MusicCursorPosition {
    private int numMeasure = 1;
    private int numBeat = 1;
    private Point point = new Point();
    private Object songObject = null;
    private Component guiComponent;
    private boolean beat;
    private int width = 10;

    public int getNumMeasure() {
        return this.numMeasure;
    }

    public void setNumBeat(int numBeat) {
        if (numBeat >= 1) {
            this.numBeat = numBeat;
        }
    }

    public void setNumMeasure(int numMeasure) {
        if (numMeasure >= 1) {
            this.numMeasure = numMeasure;
        }
    }

    public int getNumBeat() {
        return this.numBeat;
    }

    public String toString() {
        String res = "Music Cursor Position ";
        res = String.valueOf(res) + "Measure: " + this.numMeasure;
        res = String.valueOf(res) + ", Beat: " + this.numBeat;
        res = String.valueOf(res) + ", point: " + this.point;
        if (this.songObject != null) {
            res = String.valueOf(res) + (this.beat ? "isBeat" : "isBar");
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setSongObject(Object obj) {
        boolean success = false;
        if (obj == null) throw new NullPointerException("Object must not bet null");
        Class<?> c = obj.getClass();
        if (c.isInstance(new GPBeat())) {
            this.beat = true;
        } else {
            if (!c.isInstance(new GPMeasureTrackPair())) throw new ClassCastException("Object must be GPBeat or GPMeasureTrackPair");
            this.beat = false;
        }
        this.songObject = obj;
        return success;
    }

    public boolean isBeat() {
        return this.beat;
    }

    public boolean isMTP() {
        return !this.beat;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public Object getSongObject() {
        return this.songObject;
    }

    public void setGuiComponent(Component aGuiComponent) {
        if (aGuiComponent != null) {
            this.guiComponent = aGuiComponent;
        }
    }

    public Component getGuiComponent() {
        return this.guiComponent;
    }
}

