/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.gui.ColorDialog;
import dguitar.gui.DisplayOptions;
import dguitar.gui.OptionsDisplay;
import dguitar.gui.listeners.MenuIndexedListener;
import javax.swing.JFrame;
import javax.swing.JMenu;

public class SongOptionsListener
implements MenuIndexedListener {
    private DisplayOptions displayOptions;
    private JFrame jFrame;
    private OptionsDisplay reference;

    public SongOptionsListener(JFrame aFrame, OptionsDisplay aReference) {
        this.jFrame = aFrame;
        this.reference = aReference;
        this.displayOptions = this.reference.getDisplayOptions();
    }

    public void menuClicked(JMenu aMenu, int idMenu) {
        System.err.println("MENU CLICKED" + idMenu);
        boolean refresh = true;
        switch (idMenu) {
            case 1: {
                refresh = this.viewDisplayColorDialog();
                break;
            }
            case 2: {
                this.displayOptions.toggleMinPieceSpacing();
                break;
            }
            case 3: {
                this.displayOptions.toggleMultiTrackView();
                System.err.println("MULTI_TRACK toggled");
                break;
            }
            case 4: {
                this.displayOptions.toggleViewMusicCursors();
                break;
            }
            case 5: {
                this.displayOptions.toggleSingleMusicCursorColor();
                break;
            }
            case 99: {
                this.displayOptions.toggleDisplayUnsupportedEffects();
            }
        }
        if (refresh) {
            this.reference.setDisplayOptions(this.displayOptions);
        }
    }

    private boolean viewDisplayColorDialog() {
        ColorDialog CP = new ColorDialog(this.jFrame);
        CP.fretColors.setColors(this.displayOptions.fretColors, this.displayOptions.coloringForFrets);
        CP.rhythmColors.setColors(this.displayOptions.rhythmColors, this.displayOptions.coloringForRhythm);
        CP.setVisible(true);
        boolean changed = false;
        if (CP.OKclicked()) {
            if (CP.fretColors.selectionChanged()) {
                this.displayOptions.fretColors = CP.fretColors.getColors();
                this.displayOptions.coloringForFrets = CP.fretColors.getTypeOfColoring();
                changed = true;
            }
            if (CP.rhythmColors.selectionChanged()) {
                this.displayOptions.rhythmColors = CP.rhythmColors.getColors();
                this.displayOptions.coloringForRhythm = CP.rhythmColors.getTypeOfColoring();
                changed = true;
            }
        }
        return changed;
    }
}

