#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-binary-instances
version: 0.2.1.1
id: vector-binary-instances-0.2.1.1-c0febfb5ca69d46d3d7932a3e5b87de1
key: vecto_CBpitSy1URqJ55rwnmqL4b
license: BSD3
maintainer: dons00@gmail.com, bos@serpentine.com, Ben Gamari <ben@smart-cactus.org>
stability: Experimental
homepage: https://github.com/bos/vector-binary-instances
synopsis: Instances of Data.Binary and Data.Serialize for vector
description:
    Instances for Binary for the types defined in the vector package,
    making it easy to serialize vectors to and from disk. We use the
    generic interface to vectors, so all vector types are supported.
    Specific instances are provided for unboxed, boxed and storable
    vectors.
    .
    To serialize a vector:
    .
    > *Data.Vector.Binary> let v = Data.Vector.fromList [1..10]
    > *Data.Vector.Binary> v
    > fromList [1,2,3,4,5,6,7,8,9,10] :: Data.Vector.Vector
    > *Data.Vector.Binary> encode v
    > Chunk "\NUL\NUL\NUL\NUL\NUL...\NUL\NUL\NUL\t\NUL\NUL\NUL\NUL\n" Empty
    .
    Which you can in turn compress before writing to disk:
    .
    > compress . encode $ v
    > Chunk "\US\139\b\NUL\NUL\N...\229\240,\254:\NUL\NUL\NUL" Empty
category: Data
author: Don Stewart
exposed: True
exposed-modules:
    Data.Vector.Binary
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/vector-binary-instances-0.2.1.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/vector-binary-instances-0.2.1.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/vector-binary-instances-0.2.1.1
hs-libraries: HSvector-binary-instances-0.2.1.1-CBpitSy1URqJ55rwnmqL4b
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    binary-0.7.5.0-29f7044fa0b12dc5c2dcec897db5c464
    vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
haddock-interfaces: /usr/share/doc/haskell-vector-binary-instances/html/vector-binary-instances.haddock
haddock-html: /usr/share/doc/haskell-vector-binary-instances/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
