/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.File;

public final class ClassInfo {
    private final ArgType type;
    private String pkg;
    private String name;
    private String fullName;
    private ClassInfo parentClass;
    private ClassInfo alias;

    private ClassInfo(DexNode dex, ArgType type) {
        this(dex, type, true);
    }

    private ClassInfo(DexNode dex, ArgType type, boolean inner) {
        if (!type.isObject() || type.isGeneric()) {
            throw new JadxRuntimeException("Not class type: " + type);
        }
        this.type = type;
        this.alias = this;
        this.splitNames(dex, inner);
    }

    public static ClassInfo fromType(DexNode dex, ArgType type) {
        ClassInfo cls;
        if (type.isArray()) {
            type = ArgType.OBJECT;
        }
        if ((cls = dex.getInfoStorage().getCls(type)) != null) {
            return cls;
        }
        cls = new ClassInfo(dex, type);
        return dex.getInfoStorage().putCls(cls);
    }

    public static ClassInfo fromDex(DexNode dex, int clsIndex) {
        if (clsIndex == -1) {
            return null;
        }
        return ClassInfo.fromType(dex, dex.getType(clsIndex));
    }

    public static ClassInfo fromName(DexNode dex, String clsName) {
        return ClassInfo.fromType(dex, ArgType.object(clsName));
    }

    public static ClassInfo extCls(DexNode dex, ArgType type) {
        ClassInfo classInfo = ClassInfo.fromName(dex, type.getObject());
        return classInfo.alias;
    }

    public void rename(DexNode dex, String fullName) {
        ClassInfo newAlias = new ClassInfo(dex, ArgType.object(fullName), this.isInner());
        if (!this.alias.getFullName().equals(newAlias.getFullName())) {
            this.alias = newAlias;
        }
    }

    public boolean isRenamed() {
        return this.alias != this;
    }

    public ClassInfo getAlias() {
        return this.alias;
    }

    private void splitNames(DexNode dex, boolean canBeInner) {
        String clsName;
        String fullObjectName = this.type.getObject();
        int dot = fullObjectName.lastIndexOf(46);
        if (dot == -1) {
            this.pkg = "";
            clsName = fullObjectName;
        } else {
            this.pkg = fullObjectName.substring(0, dot);
            clsName = fullObjectName.substring(dot + 1);
        }
        int sep = clsName.lastIndexOf(36);
        if (canBeInner && sep > 0 && sep != clsName.length() - 1) {
            String parClsName = this.pkg + "." + clsName.substring(0, sep);
            this.parentClass = ClassInfo.fromName(dex, parClsName);
            clsName = clsName.substring(sep + 1);
        } else {
            this.parentClass = null;
        }
        this.name = clsName;
        this.fullName = this.makeFullClsName(clsName, false);
    }

    public String makeFullClsName(String shortName, boolean raw) {
        if (this.parentClass != null) {
            String innerSep = raw ? "$" : ".";
            return this.parentClass.makeFullClsName(this.parentClass.getShortName(), raw) + innerSep + shortName;
        }
        return this.pkg.isEmpty() ? shortName : this.pkg + "." + shortName;
    }

    public String getFullPath() {
        ClassInfo alias = this.getAlias();
        return alias.getPackage().replace('.', File.separatorChar) + File.separatorChar + alias.getNameWithoutPackage().replace('.', '_');
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.name;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getRawName() {
        return this.type.getObject();
    }

    public String getNameWithoutPackage() {
        if (this.parentClass == null) {
            return this.name;
        }
        return this.parentClass.getNameWithoutPackage() + "." + this.name;
    }

    public ClassInfo getParentClass() {
        return this.parentClass;
    }

    public ClassInfo getTopParentClass() {
        if (this.parentClass != null) {
            ClassInfo topCls = this.parentClass.getTopParentClass();
            return topCls != null ? topCls : this.parentClass;
        }
        return null;
    }

    public boolean isInner() {
        return this.parentClass != null;
    }

    public void notInner(DexNode dex) {
        this.splitNames(dex, false);
    }

    public ArgType getType() {
        return this.type;
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassInfo) {
            ClassInfo other = (ClassInfo)obj;
            return this.type.equals(other.type);
        }
        return false;
    }
}

