/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.codegen.CodeWriter;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.CommonBinaryParser;
import jadx.core.xmlgen.ManifestAttributes;
import jadx.core.xmlgen.ParserStream;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryXMLParser
extends CommonBinaryParser {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryXMLParser.class);
    private static final String ANDROID_R_STYLE_CLS = "android.R$style";
    private CodeWriter writer;
    private String[] strings;
    private String nsPrefix = "ERROR";
    private String nsURI = "ERROR";
    private String currentTag = "ERROR";
    private boolean firstElement;
    private boolean wasOneLiner = false;
    private final Map<Integer, String> styleMap = new HashMap<Integer, String>();
    private final Map<Integer, FieldNode> localStyleMap = new HashMap<Integer, FieldNode>();
    private final Map<Integer, String> resNames;
    private ValuesParser valuesParser;
    private final ManifestAttributes attributes;

    public BinaryXMLParser(RootNode root) {
        try {
            try {
                Class<?> rStyleCls = Class.forName(ANDROID_R_STYLE_CLS);
                for (Field f : rStyleCls.getFields()) {
                    this.styleMap.put(f.getInt(f.getType()), f.getName());
                }
            }
            catch (Throwable th) {
                LOG.error("R class loading failed", th);
            }
            for (DexNode dexNode : root.getDexNodes()) {
                for (Map.Entry<Object, FieldNode> entry : dexNode.getConstFields().entrySet()) {
                    Object key = entry.getKey();
                    FieldNode field = entry.getValue();
                    if (!field.getType().equals(ArgType.INT) || !(key instanceof Integer)) continue;
                    this.localStyleMap.put((Integer)key, field);
                }
            }
            this.resNames = root.getResourcesNames();
            this.attributes = new ManifestAttributes();
            this.attributes.parse();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("BinaryXMLParser init error", e);
        }
    }

    public synchronized CodeWriter parse(InputStream inputStream) throws IOException {
        this.writer = new CodeWriter();
        this.writer.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.is = new ParserStream(inputStream);
        this.firstElement = true;
        this.decode();
        this.writer.finish();
        return this.writer;
    }

    void decode() throws IOException {
        if (this.is.readInt16() != 3) {
            this.die("Version is not 3");
        }
        if (this.is.readInt16() != 8) {
            this.die("Size of header is not 8");
        }
        int size = this.is.readInt32();
        block9: while (this.is.getPos() < (long)size) {
            int type = this.is.readInt16();
            switch (type) {
                case 0: {
                    continue block9;
                }
                case 1: {
                    this.strings = this.parseStringPoolNoType();
                    this.valuesParser = new ValuesParser(this.strings, this.resNames);
                    continue block9;
                }
                case 384: {
                    this.parseResourceMap();
                    continue block9;
                }
                case 256: {
                    this.parseNameSpace();
                    continue block9;
                }
                case 257: {
                    this.parseNameSpaceEnd();
                    continue block9;
                }
                case 258: {
                    this.parseElement();
                    continue block9;
                }
                case 259: {
                    this.parseElementEnd();
                    continue block9;
                }
            }
            this.die("Type: 0x" + Integer.toHexString(type) + " not yet implemented");
        }
    }

    private void parseResourceMap() throws IOException {
        if (this.is.readInt16() != 8) {
            this.die("Header size of resmap is not 8!");
        }
        int rhsize = this.is.readInt32();
        int[] ids = new int[(rhsize - 8) / 4];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.is.readInt32();
        }
    }

    private void parseNameSpace() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("NAMESPACE header is not 0x0010");
        }
        if (this.is.readInt32() != 24) {
            this.die("NAMESPACE header chunk is not 0x18 big");
        }
        int beginLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int beginPrefix = this.is.readInt32();
        this.nsPrefix = this.strings[beginPrefix];
        int beginURI = this.is.readInt32();
        this.nsURI = this.strings[beginURI];
    }

    private void parseNameSpaceEnd() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("NAMESPACE header is not 0x0010");
        }
        if (this.is.readInt32() != 24) {
            this.die("NAMESPACE header chunk is not 0x18 big");
        }
        int endLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int endPrefix = this.is.readInt32();
        this.nsPrefix = this.strings[endPrefix];
        int endURI = this.is.readInt32();
        this.nsURI = this.strings[endURI];
    }

    private void parseElement() throws IOException {
        int attributeSize;
        if (this.firstElement) {
            this.firstElement = false;
        } else {
            this.writer.incIndent();
        }
        if (this.is.readInt16() != 16) {
            this.die("ELEMENT HEADER SIZE is not 0x10");
        }
        this.is.readInt32();
        int elementBegLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int startNS = this.is.readInt32();
        int startNSName = this.is.readInt32();
        if (!(this.wasOneLiner || "ERROR".equals(this.currentTag) || this.currentTag.equals(this.strings[startNSName]))) {
            this.writer.add(">");
        }
        this.wasOneLiner = false;
        this.currentTag = this.strings[startNSName];
        this.writer.startLine("<").add(this.strings[startNSName]);
        this.writer.attachSourceLine(elementBegLineNumber);
        int attributeStart = this.is.readInt16();
        if (attributeStart != 20) {
            this.die("startNS's attributeStart is not 0x14");
        }
        if ((attributeSize = this.is.readInt16()) != 20) {
            this.die("startNS's attributeSize is not 0x14");
        }
        int attributeCount = this.is.readInt16();
        int idIndex = this.is.readInt16();
        int classIndex = this.is.readInt16();
        int styleIndex = this.is.readInt16();
        if ("manifest".equals(this.strings[startNSName])) {
            this.writer.add(" xmlns:\"").add(this.nsURI).add("\"");
        }
        if (attributeCount > 0) {
            this.writer.add(" ");
        }
        for (int i = 0; i < attributeCount; ++i) {
            this.parseAttribute(i);
            this.writer.add('\"');
            if (i + 1 >= attributeCount) continue;
            this.writer.add(" ");
        }
    }

    private void parseAttribute(int i) throws IOException {
        int attributeNS = this.is.readInt32();
        int attributeName = this.is.readInt32();
        int attributeRawValue = this.is.readInt32();
        int attrValSize = this.is.readInt16();
        if (attrValSize != 8) {
            this.die("attrValSize != 0x08 not supported");
        }
        if (this.is.readInt8() != 0) {
            this.die("res0 is not 0");
        }
        int attrValDataType = this.is.readInt8();
        int attrValData = this.is.readInt32();
        if (attributeNS != -1) {
            this.writer.add(this.nsPrefix).add(':');
        }
        String attrName = this.strings[attributeName];
        this.writer.add(attrName).add("=\"");
        String decodedAttr = this.attributes.decode(attrName, attrValData);
        if (decodedAttr != null) {
            this.writer.add(decodedAttr);
        } else {
            this.decodeAttribute(attributeNS, attrValDataType, attrValData);
        }
    }

    private void decodeAttribute(int attributeNS, int attrValDataType, int attrValData) {
        if (attrValDataType == 1) {
            String name = this.styleMap.get(attrValData);
            if (name != null) {
                this.writer.add("@*");
                if (attributeNS != -1) {
                    this.writer.add(this.nsPrefix).add(':');
                }
                this.writer.add("style/").add(name.replaceAll("_", "."));
            } else {
                FieldNode field = this.localStyleMap.get(attrValData);
                if (field != null) {
                    String cls = field.getParentClass().getShortName().toLowerCase();
                    this.writer.add("@").add(cls).add("/").add(field.getName());
                } else {
                    String resName = this.resNames.get(attrValData);
                    if (resName != null) {
                        this.writer.add("@").add(resName);
                    } else {
                        this.writer.add("0x").add(Integer.toHexString(attrValData));
                    }
                }
            }
        } else {
            String str = this.valuesParser.decodeValue(attrValDataType, attrValData);
            this.writer.add(str != null ? str : "null");
        }
    }

    private void parseElementEnd() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("ELEMENT END header is not 0x10");
        }
        if (this.is.readInt32() != 24) {
            this.die("ELEMENT END header chunk is not 0x18 big");
        }
        int endLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int elementNS = this.is.readInt32();
        int elementName = this.is.readInt32();
        if (this.currentTag.equals(this.strings[elementName])) {
            this.writer.add(" />");
            this.wasOneLiner = true;
        } else {
            this.writer.startLine("</");
            this.writer.attachSourceLine(endLineNumber);
            if (elementNS != -1) {
                this.writer.add(this.strings[elementNS]).add(':');
            }
            this.writer.add(this.strings[elementName]).add(">");
        }
        if (this.writer.getIndent() != 0) {
            this.writer.decIndent();
        }
    }
}

