/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.Language;
import org.languagetool.tokenizers.LocalSRXSentenceTokenizer;

public class LocalSRXSentenceTokenizerTest {
    private final LocalSRXSentenceTokenizer tokenizer = new LocalSRXSentenceTokenizer((Language)new FakeLanguage("yy"), "/org/languagetool/tokenizers/segment-test.srx");

    @Test
    public void testTokenize() {
        this.assertTokenize("A sentence. Another one.", "[A sentence. , Another one.]");
        this.assertTokenize("A fooabbr. doesn't end a sentence.", "[A fooabbr. doesn't end a sentence.]");
        this.assertTokenize("A barabbr. doesn't end a sentence.", "[A barabbr. doesn't end a sentence.]");
        this.tokenizer.setSingleLineBreaksMarksParagraph(true);
        this.assertTokenize("A sentence.\nAnother one.", "[A sentence.\n, Another one.]");
        this.assertTokenize("A sentence.\n\nAnother one.", "[A sentence.\n, \n, Another one.]");
        this.tokenizer.setSingleLineBreaksMarksParagraph(false);
        this.assertTokenize("A sentence\nwhich goes on here.", "[A sentence\nwhich goes on here.]");
        this.assertTokenize("A sentence.\n\nAnother one.", "[A sentence.\n, \nAnother one.]");
    }

    private void assertTokenize(String input, String output) {
        Assert.assertThat((Object)this.tokenizer.tokenize(input).toString(), (Matcher)CoreMatchers.is((Object)output));
    }
}

